/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.keyboard;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Collectors;
import net.sf.jabref.gui.keyboard.KeyBindingTable;

public class KeyBindingsListener
extends KeyAdapter {
    private final KeyBindingTable table;

    public KeyBindingsListener(KeyBindingTable table) {
        this.table = table;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void keyPressed(KeyEvent evt) {
        String newKey;
        int code;
        boolean isFunctionKey = false;
        boolean isEscapeKey = false;
        boolean isDeleteKey = false;
        int selRow = this.table.getSelectedRow();
        if (selRow < 0) return;
        boolean bl = true;
        boolean isAnyRowSelected = bl;
        if (!isAnyRowSelected) {
            return;
        }
        String modifier = this.getModifierText(evt);
        if ("".equals(modifier)) {
            int kc = evt.getKeyCode();
            isFunctionKey = kc >= 112 && kc <= 123;
            isEscapeKey = kc == 27;
            boolean bl2 = isDeleteKey = kc == 127;
            if (!(isFunctionKey || isEscapeKey || isDeleteKey)) {
                return;
            }
        }
        if ((code = evt.getKeyCode()) == 18) return;
        if (code == 9) return;
        if (code == 8) return;
        if (code == 10) return;
        if (code == 32) return;
        if (code == 17) return;
        if (code == 16) return;
        if (code == 157) {
            return;
        }
        if ("".equals(modifier)) {
            if (isFunctionKey) {
                newKey = KeyEvent.getKeyText(code);
            } else if (isEscapeKey) {
                newKey = "ESCAPE";
            } else {
                if (!isDeleteKey) return;
                newKey = "DELETE";
            }
        } else {
            newKey = modifier.toLowerCase(Locale.ENGLISH) + " " + KeyEvent.getKeyText(code);
        }
        this.table.setValueAt(newKey, selRow, 1);
        this.table.revalidate();
        this.table.repaint();
    }

    private String getModifierText(KeyEvent evt) {
        ArrayList<String> modifiersList = new ArrayList<String>();
        if (evt.isControlDown()) {
            modifiersList.add("ctrl");
        }
        if (evt.isAltDown()) {
            modifiersList.add("alt");
        }
        if (evt.isShiftDown()) {
            modifiersList.add("shift");
        }
        if (evt.isAltGraphDown()) {
            modifiersList.add("alt gr");
        }
        if (evt.isMetaDown()) {
            modifiersList.add("meta");
        }
        String modifiersAsString = modifiersList.stream().collect(Collectors.joining(" "));
        return modifiersAsString;
    }
}

