/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.keyboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.keyboard.KeyBinder;
import net.sf.jabref.gui.keyboard.KeyBindingRepository;
import net.sf.jabref.gui.keyboard.KeyBindingTable;
import net.sf.jabref.gui.keyboard.KeyBindingTableModel;
import net.sf.jabref.gui.keyboard.KeyBindingsListener;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.l10n.Localization;

public class KeyBindingsDialog
extends JDialog {
    private static final int KEYBIND_COL_0 = 200;
    private static final int KEYBIND_COL_1 = 80;
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
    private final JButton resetToDefaultKeyBindings = new JButton(Localization.lang("Default", new String[0]));
    private final JButton grabB = new JButton(Localization.lang("Grab", new String[0]));
    private final Box buttonBox = new Box(0);
    private final KeyBindingRepository keyBindingRepository;
    private final KeyBindingTable table;

    public KeyBindingsDialog(KeyBindingRepository keyBindingRepository) {
        this.setTitle(Localization.lang("Key bindings", new String[0]));
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.keyBindingRepository = keyBindingRepository;
        this.table = this.setupTable();
        this.updateTableData();
        JScrollPane listScroller = new JScrollPane(this.table);
        listScroller.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add((Component)listScroller, "Center");
        this.grabB.addKeyListener(new KeyBindingsListener(this.table));
        this.buttonBox.add(this.grabB);
        this.buttonBox.add(this.resetToDefaultKeyBindings);
        this.buttonBox.add(this.ok);
        this.buttonBox.add(this.cancel);
        this.getContentPane().add((Component)this.buttonBox, "South");
        this.activateListeners();
        KeyBinder.bindCloseDialogKeyToCancelAction(this.getRootPane(), this.cancel.getAction());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                KeyBindingsDialog.this.dispose();
            }
        });
    }

    private KeyBindingTable setupTable() {
        KeyBindingTable table = new KeyBindingTable();
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(false);
        table.setSelectionMode(0);
        table.setAutoCreateRowSorter(true);
        GUIUtil.correctRowHeight(table);
        return table;
    }

    private void updateTableData() {
        KeyBindingTableModel tableModel = new KeyBindingTableModel(this.keyBindingRepository);
        this.table.setModel(tableModel);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(200);
        cm.getColumn(1).setPreferredWidth(80);
    }

    private void activateListeners() {
        this.ok.addActionListener(e -> {
            Globals.getKeyPrefs().setNewKeyBindings(this.keyBindingRepository.getKeyBindings());
            JOptionPane.showMessageDialog(this, Localization.lang("Your new key bindings have been stored.", new String[0]) + '\n' + Localization.lang("You must restart JabRef for the new key bindings to work properly.", new String[0]), Localization.lang("Key bindings changed", new String[0]), 1);
            this.dispose();
        });
        this.cancel.addActionListener(e -> this.dispose());
        this.resetToDefaultKeyBindings.addActionListener(e -> {
            boolean hasNothingSelected;
            int[] selected = this.table.getSelectedRows();
            boolean bl = hasNothingSelected = selected.length == 0;
            if (hasNothingSelected) {
                int answer = JOptionPane.showOptionDialog(this, Localization.lang("All key bindings will be reset to their defaults.", new String[0]) + " " + Localization.lang("Continue?", new String[0]), Localization.lang("Resetting all key bindings", new String[0]), 0, 3, null, new String[]{Localization.lang("OK", new String[0]), Localization.lang("Cancel", new String[0])}, Localization.lang("OK", new String[0]));
                if (answer == 0) {
                    this.keyBindingRepository.resetToDefault();
                    this.updateTableData();
                }
            } else {
                for (int row : selected) {
                    String name = String.valueOf(this.table.getValueAt(row, 0));
                    this.keyBindingRepository.resetToDefault(name);
                    String newKey = this.keyBindingRepository.get(name);
                    this.table.setValueAt(newKey, row, 1);
                    this.table.repaint();
                }
            }
        });
    }
}

