/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.keyboard;

import java.util.LinkedList;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.keyboard.KeyBindingRepository;
import net.sf.jabref.logic.l10n.Localization;

public class KeyBindingTableModel
extends AbstractTableModel {
    private final KeyBindingRepository keyBindingRepository;

    public KeyBindingTableModel(KeyBindingRepository keyBindingRepository) {
        this.keyBindingRepository = keyBindingRepository;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public String getColumnName(int col) {
        return col == 0 ? Localization.lang("Action", new String[0]) : Localization.lang("Shortcut", new String[0]);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.keyBindingRepository.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Map.Entry<KeyBinding, String> row = this.getRowData(rowIndex);
        if (columnIndex == 0) {
            return row.getKey().getLocalization();
        }
        return row.getValue();
    }

    public String getOriginalName(int rowIndex) {
        return this.getRowData(rowIndex).getKey().getKey();
    }

    private Map.Entry<KeyBinding, String> getRowData(int rowIndex) {
        LinkedList<Map.Entry<KeyBinding, String>> entries = new LinkedList<Map.Entry<KeyBinding, String>>(this.keyBindingRepository.getKeyBindings().entrySet());
        return (Map.Entry)entries.get(rowIndex);
    }

    @Override
    public void setValueAt(Object o, int row, int col) {
        if (col == 1) {
            this.keyBindingRepository.put(this.getRowData(row).getKey(), String.valueOf(o));
        }
    }
}

