/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.keyboard;

import java.util.Arrays;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.jabref.gui.keyboard.KeyBinding;

public class KeyBindingRepository {
    private final SortedMap<KeyBinding, String> bindings;

    public KeyBindingRepository() {
        this.bindings = new TreeMap<KeyBinding, String>((k1, k2) -> k1.getLocalization().compareTo(k2.getLocalization()));
        for (KeyBinding keyBinding : KeyBinding.values()) {
            this.bindings.put(keyBinding, keyBinding.getDefaultBinding());
        }
    }

    public KeyBindingRepository(SortedMap<KeyBinding, String> bindings) {
        this.bindings = bindings;
    }

    public Optional<String> get(KeyBinding key) {
        return this.getKeyBinding(key).flatMap(k -> Optional.ofNullable((String)this.bindings.get(k)));
    }

    public String get(String key) {
        Optional<KeyBinding> keyBinding = this.getKeyBinding(key);
        Optional result = keyBinding.flatMap(k -> Optional.ofNullable((String)this.bindings.get(k)));
        if (result.isPresent()) {
            return (String)result.get();
        }
        if (keyBinding.isPresent()) {
            return keyBinding.get().getDefaultBinding();
        }
        return "Not associated";
    }

    public SortedMap<KeyBinding, String> getKeyBindings() {
        return new TreeMap<KeyBinding, String>(this.bindings);
    }

    public void overwriteBindings(SortedMap<KeyBinding, String> newBindings) {
        this.bindings.clear();
        newBindings.forEach(this::put);
    }

    public void put(KeyBinding key, String value) {
        this.getKeyBinding(key).ifPresent(binding -> this.bindings.put((KeyBinding)((Object)binding), value));
    }

    public void put(String key, String value) {
        this.getKeyBinding(key).ifPresent(binding -> this.bindings.put((KeyBinding)((Object)binding), value));
    }

    private Optional<KeyBinding> getKeyBinding(String key) {
        return Arrays.stream(KeyBinding.values()).filter(b -> b.getKey().equals(key)).findFirst();
    }

    private Optional<KeyBinding> getKeyBinding(KeyBinding key) {
        return Arrays.stream(KeyBinding.values()).filter(b -> b.equals((Object)key)).findFirst();
    }

    public void resetToDefault(String key) {
        this.getKeyBinding(key).ifPresent(b -> this.bindings.put((KeyBinding)((Object)b), b.getDefaultBinding()));
    }

    public void resetToDefault() {
        this.bindings.forEach((b, s) -> this.bindings.put((KeyBinding)((Object)b), b.getDefaultBinding()));
    }

    public int size() {
        return this.bindings.size();
    }
}

