/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.keyboard;

import java.awt.AWTError;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.keyboard.KeyBindingRepository;
import net.sf.jabref.logic.util.OS;
import net.sf.jabref.preferences.JabRefPreferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyBindingPreferences {
    private static final Log LOGGER = LogFactory.getLog(KeyBindingPreferences.class);
    private int shortcutMask = -1;
    private final JabRefPreferences prefs;
    private KeyBindingRepository keyBindingRepository = new KeyBindingRepository();

    public KeyBindingPreferences(JabRefPreferences prefs) {
        this.prefs = Objects.requireNonNull(prefs);
        this.restoreKeyBindings();
    }

    public KeyStroke getKey(KeyBinding bindName) {
        String s = this.keyBindingRepository.get(bindName.getKey());
        if (OS.OS_X) {
            return this.getKeyForMac(KeyStroke.getKeyStroke(s));
        }
        return KeyStroke.getKeyStroke(s);
    }

    private KeyStroke getKeyForMac(KeyStroke ks) {
        if (ks == null) {
            return null;
        }
        int keyCode = ks.getKeyCode();
        if ((ks.getModifiers() & 2) == 0) {
            return ks;
        }
        int modifiers = 0;
        if ((ks.getModifiers() & 1) != 0) {
            modifiers |= 1;
        }
        if ((ks.getModifiers() & 8) != 0) {
            modifiers |= 8;
        }
        if (this.shortcutMask == -1) {
            try {
                this.shortcutMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            }
            catch (AWTError | HeadlessException e) {
                LOGGER.warn("Problem geting shortcut mask", e);
            }
        }
        return KeyStroke.getKeyStroke(keyCode, this.shortcutMask + modifiers);
    }

    public void setNewKeyBindings(SortedMap<KeyBinding, String> newBindings) {
        if (!newBindings.equals(this.keyBindingRepository.getKeyBindings())) {
            List<String> bindNames = newBindings.keySet().stream().map(KeyBinding::getKey).collect(Collectors.toList());
            ArrayList<String> bindings = new ArrayList<String>(newBindings.values());
            this.prefs.putStringList("bindNames", bindNames);
            this.prefs.putStringList("bindings", bindings);
            this.keyBindingRepository.overwriteBindings(newBindings);
        }
    }

    private void restoreKeyBindings() {
        List<String> bindNames = this.prefs.getStringList("bindNames");
        List<String> bindings = this.prefs.getStringList("bindings");
        if (bindNames.isEmpty() || bindings.isEmpty() || bindNames.size() != bindings.size()) {
            this.keyBindingRepository = new KeyBindingRepository();
            return;
        }
        for (int i = 0; i < bindNames.size(); ++i) {
            this.keyBindingRepository.put(bindNames.get(i), bindings.get(i));
        }
    }

    public SortedMap<KeyBinding, String> getKeyBindings() {
        return this.keyBindingRepository.getKeyBindings();
    }
}

