/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.keyboard;

import net.sf.jabref.logic.l10n.Localization;

public enum KeyBinding {
    ABBREVIATE("Abbreviate", Localization.lang("Abbreviate journal names", new String[0]), "ctrl alt A"),
    ACCEPT("Accept", Localization.lang("Accept", new String[0]), "ctrl ENTER"),
    AUTOGENERATE_BIBTEX_KEYS("Autogenerate BibTeX keys", Localization.lang("Autogenerate BibTeX keys", new String[0]), "ctrl G"),
    AUTOMATICALLY_LINK_FILES("Automatically link files", Localization.lang("Automatically set file links", new String[0]), "F7"),
    BACK("Back", Localization.lang("Back", new String[0]), "alt LEFT"),
    CHECK_INTEGRITY("Check integrity", Localization.menuTitle("Check integrity", new String[0]), "ctrl F8"),
    CLEANUP("Cleanup", Localization.lang("Cleanup entries", new String[0]), "F8"),
    CLEAR_SEARCH("Clear search", Localization.lang("Clear search", new String[0]), "ESCAPE"),
    CLOSE_DATABASE("Close database", Localization.lang("Close database", new String[0]), "ctrl W"),
    CLOSE_DIALOG("Close dialog", Localization.lang("Close dialog", new String[0]), "ESCAPE"),
    CLOSE_ENTRY_EDITOR("Close entry editor", Localization.lang("Close entry editor", new String[0]), "ESCAPE"),
    COPY("Copy", Localization.lang("Copy", new String[0]), "ctrl C"),
    COPY_CITE_BIBTEX_KEY("Copy \\cite{BibTeX key}", Localization.lang("Copy \\cite{BibTeX key}", new String[0]), "ctrl K"),
    COPY_BIBTEX_KEY("Copy BibTeX key", Localization.lang("Copy BibTeX key", new String[0]), "ctrl shift K"),
    COPY_BIBTEX_KEY_AND_TITLE("Copy BibTeX key and title", Localization.lang("Copy BibTeX key and title", new String[0]), "ctrl shift alt K"),
    COPY_BIBTEX_KEY_AND_LINK("Copy BibTeX key and link", Localization.lang("Copy BibTeX key and link", new String[0]), "ctrl alt K"),
    COPY_PREVIEW("Copy preview", Localization.lang("Copy preview", new String[0]), "ctrl shift C"),
    CUT("Cut", Localization.lang("Cut", new String[0]), "ctrl X"),
    DECREASE_TABLE_FONT_SIZE("Decrease table font size", Localization.lang("Decrease table font size", new String[0]), "ctrl MINUS"),
    DELETE_ENTRY("Delete entry", Localization.lang("Delete entry", new String[0]), "DELETE"),
    EDIT_ENTRY("Edit entry", Localization.lang("Edit entry", new String[0]), "ctrl E"),
    EDIT_STRINGS("Edit strings", Localization.lang("Edit strings", new String[0]), "ctrl T"),
    ENTRY_EDITOR_NEXT_ENTRY("Entry editor, next entry", Localization.lang("Entry editor, next entry", new String[0]), "ctrl shift DOWN"),
    ENTRY_EDITOR_NEXT_PANEL("Entry editor, next panel", Localization.lang("Entry editor, next panel", new String[0]), "ctrl TAB"),
    ENTRY_EDITOR_NEXT_PANEL_2("Entry editor, next panel 2", Localization.lang("Entry editor, next panel 2", new String[0]), "ctrl PLUS"),
    ENTRY_EDITOR_PREVIOUS_ENTRY("Entry editor, previous entry", Localization.lang("Entry editor, previous entry", new String[0]), "ctrl shift UP"),
    ENTRY_EDITOR_PREVIOUS_PANEL("Entry editor, previous panel", Localization.lang("Entry editor, previous panel", new String[0]), "ctrl shift TAB"),
    ENTRY_EDITOR_PREVIOUS_PANEL_2("Entry editor, previous panel 2", Localization.lang("Entry editor, previous panel 2", new String[0]), "ctrl MINUS"),
    ENTRY_EDITOR_STORE_FIELD("Entry editor, store field", Localization.lang("Entry editor, store field", new String[0]), "alt S"),
    FILE_LIST_EDITOR_MOVE_ENTRY_DOWN("File list editor, move entry down", Localization.lang("File list editor, move entry down", new String[0]), "ctrl DOWN"),
    FILE_LIST_EDITOR_MOVE_ENTRY_UP("File list editor, move entry up", Localization.lang("File list editor, move entry up", new String[0]), "ctrl UP"),
    FIND_UNLINKED_FILES("Find unlinked files", Localization.lang("Find unlinked files", new String[0]), "shift F7"),
    FOCUS_ENTRY_TABLE("Focus entry table", Localization.lang("Focus entry table", new String[0]), "alt 1"),
    FORWARD("Forward", Localization.lang("Forward", new String[0]), "alt RIGHT"),
    GLOBAL_SEARCH("Search globally", Localization.lang("Search globally", new String[0]), "ctrl shift F"),
    HELP("Help", Localization.lang("Help", new String[0]), "F1"),
    IMPORT_INTO_CURRENT_DATABASE("Import into current database", Localization.lang("Import into current database", new String[0]), "ctrl I"),
    IMPORT_INTO_NEW_DATABASE("Import into new database", Localization.lang("Import into new database", new String[0]), "ctrl alt I"),
    INCREASE_TABLE_FONT_SIZE("Increase table font size", Localization.lang("Increase table font size", new String[0]), "ctrl PLUS"),
    MARK_ENTRIES("Mark entries", Localization.lang("Mark entries", new String[0]), "ctrl M"),
    NEW_ARTICLE("New article", Localization.lang("New article", new String[0]), "ctrl shift A"),
    NEW_BOOK("New book", Localization.lang("New book", new String[0]), "ctrl shift B"),
    NEW_ENTRY("New entry", Localization.lang("New entry", new String[0]), "ctrl N"),
    NEW_FROM_PLAIN_TEXT("New from plain text", Localization.lang("New from plain text", new String[0]), "ctrl shift N"),
    NEW_INBOOK("New inbook", Localization.lang("New inbook", new String[0]), "ctrl shift I"),
    NEW_MASTERSTHESIS("New mastersthesis", Localization.lang("New mastersthesis", new String[0]), "ctrl shift M"),
    NEW_PHDTHESIS("New phdthesis", Localization.lang("New phdthesis", new String[0]), "ctrl shift T"),
    NEW_PROCEEDINGS("New proceedings", Localization.lang("New proceedings", new String[0]), "ctrl shift P"),
    NEW_UNPUBLISHED("New unpublished", Localization.lang("New unpublished", new String[0]), "ctrl shift U"),
    NEW_TECHREPORT("New technical report", Localization.lang("New technical report", new String[0]), "ctrl shift R"),
    NEXT_PREVIEW_LAYOUT("Next preview layout", Localization.lang("Next preview layout", new String[0]), "F9"),
    NEXT_TAB("Next tab", Localization.lang("Next tab", new String[0]), "ctrl PAGE_DOWN"),
    OPEN_CONSOLE("Open terminal here", Localization.lang("Open terminal here", new String[0]), "ctrl shift L"),
    OPEN_DATABASE("Open database", Localization.lang("Open database", new String[0]), "ctrl O"),
    OPEN_FILE("Open file", Localization.lang("Open file", new String[0]), "F4"),
    OPEN_FOLDER("Open folder", Localization.lang("Open folder", new String[0]), "ctrl shift O"),
    OPEN_OPEN_OFFICE_LIBRE_OFFICE_CONNECTION("Open OpenOffice/LibreOffice connection", Localization.lang("Open OpenOffice/LibreOffice connection", new String[0]), "alt 0"),
    OPEN_URL_OR_DOI("Open URL or DOI", Localization.lang("Open URL or DOI", new String[0]), "F3"),
    PASTE("Paste", Localization.lang("Paste", new String[0]), "ctrl V"),
    PULL_CHANGES_FROM_SHARED_DATABASE("Pull changes from shared database", Localization.lang("Pull changes from shared database", new String[0]), "ctrl shift R"),
    PREAMBLE_EDITOR_STORE_CHANGES("Preamble editor, store changes", Localization.lang("Preamble editor, store changes", new String[0]), "alt S"),
    PREVIOUS_PREVIEW_LAYOUT("Previous preview layout", Localization.lang("Previous preview layout", new String[0]), "shift F9"),
    PREVIOUS_TAB("Previous tab", Localization.lang("Previous tab", new String[0]), "ctrl PAGE_UP"),
    PUSH_TO_APPLICATION("Push to application", Localization.lang("Push to application", new String[0]), "ctrl L"),
    QUIT_JABREF("Quit JabRef", Localization.lang("Quit JabRef", new String[0]), "ctrl Q"),
    REDO("Redo", Localization.lang("Redo", new String[0]), "ctrl Y"),
    REFRESH_OO("Refresh OO", Localization.lang("Refresh OpenOffice/LibreOffice", new String[0]), "ctrl alt O"),
    REPLACE_STRING("Replace string", Localization.lang("Replace string", new String[0]), "ctrl R"),
    RESOLVE_DUPLICATE_BIBTEX_KEYS("Resolve duplicate BibTeX keys", Localization.lang("Resolve duplicate BibTeX keys", new String[0]), "ctrl shift D"),
    SAVE_ALL("Save all", Localization.lang("Save all", new String[0]), "ctrl alt S"),
    SAVE_DATABASE("Save database", Localization.lang("Save database", new String[0]), "ctrl S"),
    SAVE_DATABASE_AS("Save database as ...", Localization.lang("Save database as...", new String[0]), "ctrl shift S"),
    SEARCH("Search", Localization.lang("Search", new String[0]), "ctrl F"),
    SELECT_ALL("Select all", Localization.lang("Select all", new String[0]), "ctrl A"),
    SELECT_FIRST_ENTRY("Select first entry", Localization.lang("Select first entry", new String[0]), "HOME"),
    SELECT_LAST_ENTRY("Select last entry", Localization.lang("Select last entry", new String[0]), "END"),
    STRING_DIALOG_ADD_STRING("String dialog, add string", Localization.lang("String dialog, add string", new String[0]), "ctrl N"),
    STRING_DIALOG_REMOVE_STRING("String dialog, remove string", Localization.lang("String dialog, remove string", new String[0]), "shift DELETE"),
    SYNCHRONIZE_FILES("Synchronize files", Localization.lang("Synchronize files", new String[0]), "ctrl shift F7"),
    TOGGLE_ENTRY_PREVIEW("Toggle entry preview", Localization.lang("Toggle entry preview", new String[0]), "alt 2"),
    TOGGLE_GROUPS_INTERFACE("Toggle groups interface", Localization.lang("Toggle groups interface", new String[0]), "alt 3"),
    UNABBREVIATE("Unabbreviate", Localization.lang("Unabbreviate", new String[0]), "ctrl alt shift A"),
    UNDO("Undo", Localization.lang("Undo", new String[0]), "ctrl Z"),
    UNMARK_ENTRIES("Unmark entries", Localization.lang("Unmark entries", new String[0]), "ctrl shift M"),
    WEB_SEARCH("Web search", Localization.lang("Web search", new String[0]), "alt 4"),
    WRITE_XMP("Write XMP", Localization.lang("Write XMP", new String[0]), "F6");

    private final String key;
    private final String localization;
    private final String defaultBinding;

    private KeyBinding(String key, String localization, String defaultBinding) {
        this.key = key;
        this.localization = localization;
        this.defaultBinding = defaultBinding;
    }

    public String getKey() {
        return this.key;
    }

    public String getLocalization() {
        return this.localization;
    }

    public String getDefaultBinding() {
        return this.defaultBinding;
    }
}

