/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.journals;

import javax.swing.undo.CompoundEdit;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.journals.Abbreviation;
import net.sf.jabref.logic.journals.JournalAbbreviationRepository;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;

public class UndoableAbbreviator {
    private final JournalAbbreviationRepository journalAbbreviationRepository;
    private final boolean isoAbbreviationStyle;

    public UndoableAbbreviator(JournalAbbreviationRepository journalAbbreviationRepository, boolean isoAbbreviationStyle) {
        this.journalAbbreviationRepository = journalAbbreviationRepository;
        this.isoAbbreviationStyle = isoAbbreviationStyle;
    }

    public boolean abbreviate(BibDatabase database, BibEntry entry, String fieldName, CompoundEdit ce) {
        String text;
        if (!entry.hasField(fieldName)) {
            return false;
        }
        String origText = text = entry.getField(fieldName).get();
        if (database != null) {
            text = database.resolveForStrings(text);
        }
        if (!this.journalAbbreviationRepository.isKnownName(text)) {
            return false;
        }
        String newText = this.getAbbreviatedName(this.journalAbbreviationRepository.getAbbreviation(text).get());
        if (newText.equals(origText)) {
            return false;
        }
        entry.setField(fieldName, newText);
        ce.addEdit(new UndoableFieldChange(entry, fieldName, origText, newText));
        return true;
    }

    private String getAbbreviatedName(Abbreviation text) {
        if (this.isoAbbreviationStyle) {
            return text.getIsoAbbreviation();
        }
        return text.getMedlineAbbreviation();
    }
}

