/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.journals;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.journals.JournalAbbreviationsUtil;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.net.MonitoredURLDownload;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.journals.Abbreviation;
import net.sf.jabref.logic.journals.JournalAbbreviationLoader;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.OS;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ManageJournalsPanel
extends JPanel {
    private static final Log LOGGER = LogFactory.getLog(ManageJournalsPanel.class);
    private final JabRefFrame frame;
    private final JTextField personalFile = new JTextField();
    private final AbbreviationsTableModel tableModel = new AbbreviationsTableModel();
    private JTable userTable;
    private final JPanel userPanel = new JPanel();
    private final JPanel journalEditPanel;
    private final JPanel externalFilesPanel = new JPanel();
    private final JPanel addExtPan = new JPanel();
    private final JTextField nameTf = new JTextField();
    private final JTextField newNameTf = new JTextField();
    private final JTextField abbrTf = new JTextField();
    private final List<ExternalFileEntry> externals = new ArrayList<ExternalFileEntry>();
    private final JDialog dialog;
    private final JRadioButton newFile = new JRadioButton(Localization.lang("New file", new String[0]));
    private final JRadioButton oldFile = new JRadioButton(Localization.lang("Existing file", new String[0]));
    private final JButton add = new JButton(IconTheme.JabRefIcon.ADD_NOBOX.getIcon());
    private final JButton remove = new JButton(IconTheme.JabRefIcon.REMOVE_NOBOX.getIcon());

    public ManageJournalsPanel(JabRefFrame frame) {
        this.frame = frame;
        this.personalFile.setEditable(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.newFile);
        group.add(this.oldFile);
        this.addExtPan.setLayout(new BorderLayout());
        JButton addExt = new JButton(IconTheme.JabRefIcon.ADD.getIcon());
        this.addExtPan.add((Component)addExt, "East");
        this.addExtPan.setToolTipText(Localization.lang("Add", new String[0]));
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:200dlu:grow, 4dlu, fill:pref", "pref, pref, pref, 20dlu, 20dlu, fill:200dlu, 4dlu, pref");
        FormBuilder builder = FormBuilder.create().layout(layout);
        builder.addSeparator(Localization.lang("Built-in journal list", new String[0]), new Object[0]).xyw(2, 1, 6);
        JLabel description = new JLabel("<HTML>" + Localization.lang("JabRef includes a built-in list of journal abbreviations.", new String[0]) + "<br>" + Localization.lang("You can add additional journal names by setting up a personal journal list,<br>as well as linking to external journal lists.", new String[0]) + "</HTML>");
        description.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        builder.add(description).xyw(2, 2, 6);
        JButton viewBuiltin = new JButton(Localization.lang("View", new String[0]));
        builder.add(viewBuiltin).xy(7, 2);
        builder.addSeparator(Localization.lang("Personal journal list", new String[0]), new Object[0]).xyw(2, 3, 6);
        builder.add(this.newFile).xy(3, 4);
        builder.add(this.newNameTf).xy(5, 4);
        JButton browseNew = new JButton(Localization.lang("Browse", new String[0]));
        builder.add(browseNew).xy(7, 4);
        builder.add(this.oldFile).xy(3, 5);
        builder.add(this.personalFile).xy(5, 5);
        JButton browseOld = new JButton(Localization.lang("Browse", new String[0]));
        builder.add(browseOld).xy(7, 5);
        this.userPanel.setLayout(new BorderLayout());
        builder.add(this.userPanel).xyw(2, 6, 4);
        ButtonStackBuilder butBul = new ButtonStackBuilder();
        butBul.addButton((JComponent)this.add);
        butBul.addButton((JComponent)this.remove);
        butBul.addGlue();
        builder.add(butBul.getPanel()).xy(7, 6);
        builder.addSeparator(Localization.lang("External files", new String[0]), new Object[0]).xyw(2, 8, 6);
        this.externalFilesPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)builder.getPanel(), "North");
        this.add((Component)this.externalFilesPanel, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        bb.addButton((JComponent)ok);
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        bb.addButton((JComponent)cancel);
        bb.addUnrelatedGap();
        JButton help = new HelpAction(HelpFile.JOURNAL_ABBREV).getHelpButton();
        bb.addButton((JComponent)help);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dialog = new JDialog(frame, Localization.lang("Journal abbreviations", new String[0]), false);
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.getContentPane().add((Component)bb.getPanel(), "South");
        FormLayout layout2 = new FormLayout("right:pref, 4dlu, fill:180dlu", "p, 2dlu, p");
        FormBuilder builder2 = FormBuilder.create().layout(layout2);
        builder2.add(Localization.lang("Journal name", new String[0]), new Object[0]).xy(1, 1);
        builder2.add(this.nameTf).xy(3, 1);
        builder2.add(Localization.lang("ISO abbreviation", new String[0]), new Object[0]).xy(1, 3);
        builder2.add(this.abbrTf).xy(3, 3);
        this.journalEditPanel = builder2.getPanel();
        viewBuiltin.addActionListener(e -> {
            JTable table = new JTable(JournalAbbreviationsUtil.getTableModel(Globals.journalAbbreviationLoader.getRepository(Globals.prefs.getJournalAbbreviationPreferences()).getAbbreviations()));
            GUIUtil.correctRowHeight(table);
            JScrollPane pane = new JScrollPane(table);
            JOptionPane.showMessageDialog(null, pane, Localization.lang("Journal list preview", new String[0]), 1);
        });
        browseNew.addActionListener(e -> {
            Optional<Path> path = new FileDialog(frame, this.newNameTf.getText()).saveNewFile();
            path.ifPresent(fileName -> {
                this.newNameTf.setText(fileName.toString());
                this.newFile.setSelected(true);
            });
        });
        browseOld.addActionListener(e -> {
            Optional<Path> path = new FileDialog(frame, this.personalFile.getText()).showDialogAndGetSelectedFile();
            path.ifPresent(fileName -> {
                this.personalFile.setText(fileName.toString());
                this.oldFile.setSelected(true);
                this.oldFile.setEnabled(true);
                this.setupUserTable();
            });
        });
        ok.addActionListener(e -> {
            if (this.readyToClose()) {
                this.storeSettings();
                this.dialog.dispose();
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageJournalsPanel.this.dialog.dispose();
            }
        };
        cancel.addActionListener(cancelAction);
        this.add.addActionListener(this.tableModel);
        this.remove.addActionListener(this.tableModel);
        addExt.addActionListener(e -> {
            this.externals.add(new ExternalFileEntry());
            this.buildExternalsPanel();
        });
        ActionMap am = this.getActionMap();
        InputMap im = this.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
        int xSize = this.getPreferredSize().width;
        this.dialog.setSize(xSize + 10, 700);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setValues() {
        this.personalFile.setText(Globals.prefs.get("personalJournalList"));
        if (this.personalFile.getText().isEmpty()) {
            this.newFile.setSelected(true);
            this.newFile.setEnabled(true);
            this.oldFile.setSelected(false);
            this.oldFile.setEnabled(false);
        } else {
            this.newFile.setSelected(false);
            this.newFile.setEnabled(false);
            this.oldFile.setSelected(true);
            this.oldFile.setEnabled(true);
        }
        this.setupUserTable();
        this.setupExternals();
        this.buildExternalsPanel();
    }

    private void buildExternalsPanel() {
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("fill:pref:grow", "p"));
        int row = 1;
        for (ExternalFileEntry efe : this.externals) {
            builder.add(efe.getPanel()).xy(1, row);
            builder.appendRows("2dlu, p", new Object[0]);
            row += 2;
        }
        builder.add(Box.createVerticalGlue()).xy(1, row);
        builder.appendRows("2dlu, p, 2dlu, p", new Object[0]);
        builder.add(this.addExtPan).xy(1, row + 2);
        builder.add(Box.createVerticalGlue()).xy(1, row + 2);
        JScrollPane pane = new JScrollPane(builder.getPanel());
        pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.externalFilesPanel.setMinimumSize(new Dimension(400, 400));
        this.externalFilesPanel.setPreferredSize(new Dimension(400, 400));
        this.externalFilesPanel.removeAll();
        this.externalFilesPanel.add((Component)pane, "Center");
        this.externalFilesPanel.revalidate();
        this.externalFilesPanel.repaint();
    }

    private void setupExternals() {
        List<String> externalFiles = Globals.prefs.getStringList("externalJournalLists");
        if (externalFiles.isEmpty()) {
            ExternalFileEntry efe = new ExternalFileEntry();
            this.externals.add(efe);
        } else {
            for (String externalFile : externalFiles) {
                ExternalFileEntry efe = new ExternalFileEntry(externalFile);
                this.externals.add(efe);
            }
        }
    }

    private void setupUserTable() {
        List<Abbreviation> userAbbreviations = new ArrayList<Abbreviation>();
        String filename = this.personalFile.getText();
        if (!filename.isEmpty() && Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
            try {
                userAbbreviations = JournalAbbreviationLoader.readJournalListFromFile(new File(filename), Globals.prefs.getDefaultEncoding());
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("Problem reading abbreviation file", e);
            }
        }
        this.tableModel.setJournals(userAbbreviations);
        this.userTable = new JTable(this.tableModel);
        GUIUtil.correctRowHeight(this.userTable);
        this.userTable.addMouseListener(this.tableModel.getMouseListener());
        this.userPanel.add((Component)new JScrollPane(this.userTable), "Center");
    }

    private boolean readyToClose() {
        if (this.newFile.isSelected()) {
            if (this.newNameTf.getText().isEmpty()) {
                if (this.tableModel.getRowCount() > 0) {
                    JOptionPane.showMessageDialog(this, Localization.lang("You must choose a filename to store journal abbreviations", new String[0]), Localization.lang("Store journal abbreviations", new String[0]), 0);
                    return false;
                }
                return true;
            }
            Path filePath = Paths.get(this.newNameTf.getText(), new String[0]);
            return !Files.exists(filePath, new LinkOption[0]) || JOptionPane.showConfirmDialog(this, Localization.lang("'%0' exists. Overwrite file?", filePath.getFileName().toString()), Localization.lang("Store journal abbreviations", new String[0]), 2) == 0;
        }
        return true;
    }

    private void storeSettings() {
        Path filePath = null;
        if (this.newFile.isSelected()) {
            if (!this.newNameTf.getText().isEmpty()) {
                filePath = Paths.get(this.newNameTf.getText(), new String[0]);
            }
        } else {
            filePath = Paths.get(this.personalFile.getText(), new String[0]);
        }
        if (filePath != null) {
            try {
                OutputStream stream = Files.newOutputStream(filePath, StandardOpenOption.CREATE);
                Object object = null;
                try (OutputStreamWriter writer2 = new OutputStreamWriter(stream, Globals.prefs.getDefaultEncoding());){
                    for (JournalEntry entry : this.tableModel.getJournals()) {
                        writer2.write(entry.getName());
                        writer2.write(" = ");
                        writer2.write(entry.getAbbreviation());
                        writer2.write(OS.NEWLINE);
                    }
                }
                catch (Throwable writer2) {
                    object = writer2;
                    throw writer2;
                }
                finally {
                    if (stream != null) {
                        if (object != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable writer2) {
                                ((Throwable)object).addSuppressed(writer2);
                            }
                        } else {
                            stream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                LOGGER.warn("Problem writing abbreviation file", e);
            }
            String filename = filePath.toString();
            if ("".equals(filename)) {
                filename = null;
            }
            Globals.prefs.put("personalJournalList", filename);
        }
        ArrayList<String> extFiles = new ArrayList<String>();
        for (ExternalFileEntry efe : this.externals) {
            if ("".equals(efe.getValue())) continue;
            extFiles.add(efe.getValue());
        }
        Globals.prefs.putStringList("externalJournalLists", extFiles);
        Globals.journalAbbreviationLoader.update(Globals.prefs.getJournalAbbreviationPreferences());
    }

    static class JournalEntry
    implements Comparable<JournalEntry> {
        private String name;
        private String abbreviation;

        public JournalEntry(String name, String abbreviation) {
            this.name = name;
            this.abbreviation = abbreviation;
        }

        @Override
        public int compareTo(JournalEntry other) {
            return this.name.compareTo(other.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof JournalEntry) {
                return this.name.equals(((JournalEntry)o).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public void setAbbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
        }
    }

    private class ExternalFileEntry {
        private JPanel pan;
        private final JTextField tf;
        private final JButton browse = new JButton(Localization.lang("Browse", new String[0]));
        private final JButton view = new JButton(Localization.lang("Preview", new String[0]));
        private final JButton clear = new JButton(IconTheme.JabRefIcon.DELETE_ENTRY.getIcon());
        private final JButton download = new JButton(Localization.lang("Download", new String[0]));

        public ExternalFileEntry() {
            this.tf = new JTextField();
            this.setupPanel();
        }

        public ExternalFileEntry(String filename) {
            this.tf = new JTextField(filename);
            this.setupPanel();
        }

        private void setupPanel() {
            this.tf.setEditable(false);
            this.browse.addActionListener(e -> new FileDialog(ManageJournalsPanel.this.frame).showDialogAndGetSelectedFile().ifPresent(f -> this.tf.setText(f.toAbsolutePath().toString())));
            DownloadAction da = new DownloadAction(this.tf);
            this.download.addActionListener(da);
            FormBuilder builder = FormBuilder.create().layout(new FormLayout("fill:pref:grow, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, fill:pref", "p"));
            builder.add(this.tf).xy(1, 1);
            builder.add(this.browse).xy(3, 1);
            builder.add(this.download).xy(5, 1);
            builder.add(this.view).xy(7, 1);
            builder.add(this.clear).xy(9, 1);
            this.pan = builder.getPanel();
            this.view.addActionListener(e -> {
                try {
                    List<Abbreviation> abbreviations = JournalAbbreviationLoader.readJournalListFromFile(new File(this.tf.getText()));
                    JTable table = new JTable(JournalAbbreviationsUtil.getTableModel(abbreviations));
                    GUIUtil.correctRowHeight(table);
                    JScrollPane pane = new JScrollPane(table);
                    JOptionPane.showMessageDialog(null, pane, Localization.lang("Journal list preview", new String[0]), 1);
                }
                catch (FileNotFoundException ex) {
                    LOGGER.debug("File not found", ex);
                    JOptionPane.showMessageDialog(null, Localization.lang("File '%0' not found", this.tf.getText()), Localization.lang("Error", new String[0]), 0);
                }
            });
            this.clear.addActionListener(e -> {
                ManageJournalsPanel.this.externals.remove(this);
                ManageJournalsPanel.this.buildExternalsPanel();
            });
            this.clear.setToolTipText(Localization.lang("Remove", new String[0]));
        }

        public JPanel getPanel() {
            return this.pan;
        }

        public String getValue() {
            return this.tf.getText();
        }
    }

    class AbbreviationsTableModel
    extends AbstractTableModel
    implements ActionListener {
        private final String[] names = new String[]{Localization.lang("Journal name", new String[0]), Localization.lang("Abbreviation", new String[0])};
        private List<JournalEntry> journals;

        AbbreviationsTableModel() {
        }

        public void setJournals(List<Abbreviation> abbreviations) {
            this.journals = new ArrayList<JournalEntry>();
            for (Abbreviation abbreviation : abbreviations) {
                this.journals.add(new JournalEntry(abbreviation.getName(), abbreviation.getIsoAbbreviation()));
            }
            this.fireTableDataChanged();
        }

        public List<JournalEntry> getJournals() {
            return this.journals;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.journals.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.journals.get(row).getName();
            }
            return this.journals.get(row).getAbbreviation();
        }

        @Override
        public void setValueAt(Object object, int row, int col) {
            JournalEntry entry = this.journals.get(row);
            if (col == 0) {
                entry.setName((String)object);
            } else {
                entry.setAbbreviation((String)object);
            }
        }

        @Override
        public String getColumnName(int i) {
            return this.names[i];
        }

        @Override
        public boolean isCellEditable(int i, int i1) {
            return false;
        }

        public MouseListener getMouseListener() {
            return new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        JTable table = (JTable)e.getSource();
                        int row = table.rowAtPoint(e.getPoint());
                        ManageJournalsPanel.this.nameTf.setText((String)AbbreviationsTableModel.this.getValueAt(row, 0));
                        ManageJournalsPanel.this.abbrTf.setText((String)AbbreviationsTableModel.this.getValueAt(row, 1));
                        if (JOptionPane.showConfirmDialog(ManageJournalsPanel.this.dialog, ManageJournalsPanel.this.journalEditPanel, Localization.lang("Edit journal", new String[0]), 2) == 0) {
                            AbbreviationsTableModel.this.setValueAt(ManageJournalsPanel.this.nameTf.getText(), row, 0);
                            AbbreviationsTableModel.this.setValueAt(ManageJournalsPanel.this.abbrTf.getText(), row, 1);
                            Collections.sort(AbbreviationsTableModel.this.journals);
                            AbbreviationsTableModel.this.fireTableDataChanged();
                        }
                    }
                }
            };
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows;
            if (e.getSource() == ManageJournalsPanel.this.add) {
                ManageJournalsPanel.this.nameTf.setText("");
                ManageJournalsPanel.this.abbrTf.setText("");
                if (JOptionPane.showConfirmDialog(ManageJournalsPanel.this.dialog, ManageJournalsPanel.this.journalEditPanel, Localization.lang("Edit journal", new String[0]), 2) == 0) {
                    this.journals.add(new JournalEntry(ManageJournalsPanel.this.nameTf.getText(), ManageJournalsPanel.this.abbrTf.getText()));
                    Collections.sort(this.journals);
                    this.fireTableDataChanged();
                }
            } else if (e.getSource() == ManageJournalsPanel.this.remove && (rows = ManageJournalsPanel.this.userTable.getSelectedRows()).length > 0) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    this.journals.remove(rows[i]);
                }
                this.fireTableDataChanged();
            }
        }
    }

    class DownloadAction
    extends AbstractAction {
        private final JTextField comp;

        public DownloadAction(JTextField tc) {
            super(Localization.lang("Download", new String[0]));
            this.comp = tc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String chosen = JOptionPane.showInputDialog(Localization.lang("Choose the URL to download.", new String[0]), (Object)"");
            if (chosen == null || this.comp.getText().isEmpty()) {
                return;
            }
            try {
                Optional<Path> path = new FileDialog(ManageJournalsPanel.this.frame, System.getProperty("user.home")).saveNewFile();
                if (!path.isPresent()) {
                    return;
                }
                File toFile = new File(path.get().toString());
                URL url = new URL(chosen);
                MonitoredURLDownload.buildMonitoredDownload(this.comp, url).downloadToFile(toFile);
                this.comp.setText(toFile.getPath());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, Localization.lang("Error downloading file '%0'", chosen), Localization.lang("Download failed", new String[0]), 0);
                LOGGER.debug("Error downloading file", ex);
            }
        }
    }
}

