/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.journals;

import java.util.List;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.journals.UndoableAbbreviator;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.InternalBibtexFields;

public class AbbreviateAction
extends AbstractWorker {
    private final BasePanel panel;
    private String message = "";
    private final boolean iso;

    public AbbreviateAction(BasePanel panel, boolean iso) {
        this.panel = panel;
        this.iso = iso;
    }

    @Override
    public void init() {
        this.panel.output(Localization.lang("Abbreviating...", new String[0]));
    }

    @Override
    public void run() {
        List<BibEntry> entries = this.panel.getSelectedEntries();
        if (entries == null) {
            return;
        }
        UndoableAbbreviator undoableAbbreviator = new UndoableAbbreviator(Globals.journalAbbreviationLoader.getRepository(Globals.prefs.getJournalAbbreviationPreferences()), this.iso);
        NamedCompound ce = new NamedCompound(Localization.lang("Abbreviate journal names", new String[0]));
        int count = 0;
        for (BibEntry entry : entries) {
            for (String journalField : InternalBibtexFields.getJournalNameFields()) {
                if (!undoableAbbreviator.abbreviate(this.panel.getDatabase(), entry, journalField, ce)) continue;
                ++count;
            }
        }
        if (count > 0) {
            ce.end();
            this.panel.getUndoManager().addEdit(ce);
            this.panel.markBaseChanged();
            this.message = Localization.lang("Abbreviated %0 journal names.", String.valueOf(count));
        } else {
            this.message = Localization.lang("No journal names could be abbreviated.", new String[0]);
        }
    }

    @Override
    public void update() {
        this.panel.output(this.message);
    }
}

