/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.fetcher;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.IOException;
import java.net.URLEncoder;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jabref.gui.importer.ImportInspectionDialog;
import net.sf.jabref.gui.importer.fetcher.EntryFetcher;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.ImportInspector;
import net.sf.jabref.logic.importer.OutputPrinter;
import net.sf.jabref.logic.importer.util.JSONEntryParser;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpringerFetcher
implements EntryFetcher {
    private static final String API_URL = "http://api.springer.com/metadata/json?q=";
    private static final String API_KEY = "b0c7151179b3d9c1119cf325bca8460d";
    private static final Log LOGGER = LogFactory.getLog(SpringerFetcher.class);
    private static final int MAX_PER_PAGE = 100;
    private boolean shouldContinue;

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    @Override
    public boolean processQuery(String query, ImportInspector inspector, OutputPrinter status) {
        this.shouldContinue = true;
        try {
            status.setStatus(Localization.lang("Searching...", new String[0]));
            String encodedQuery = URLEncoder.encode(query, "UTF-8");
            HttpResponse<JsonNode> jsonResponse = Unirest.get(API_URL + encodedQuery + "&api_key=" + API_KEY + "&p=1").header("accept", "application/json").asJson();
            JSONObject jo = jsonResponse.getBody().getObject();
            int numberToFetch = jo.getJSONArray("result").getJSONObject(0).getInt("total");
            if (numberToFetch > 0) {
                if (numberToFetch > 100) {
                    boolean numberEntered = false;
                    do {
                        String strCount;
                        if ((strCount = JOptionPane.showInputDialog(Localization.lang("%0 references found. Number of references to fetch?", String.valueOf(numberToFetch)))) == null) {
                            status.setStatus(Localization.lang("%0 import canceled", this.getTitle()));
                            return false;
                        }
                        try {
                            numberToFetch = Integer.parseInt(strCount.trim());
                            numberEntered = true;
                        }
                        catch (NumberFormatException ex) {
                            status.showMessage(Localization.lang("Please enter a valid number", new String[0]));
                        }
                    } while (!numberEntered);
                }
                int fetched = 0;
                for (int startItem = 1; startItem <= numberToFetch && this.shouldContinue; startItem += 100) {
                    int noToFetch = Math.min(100, numberToFetch - startItem + 1);
                    jsonResponse = Unirest.get(API_URL + encodedQuery + "&api_key=" + API_KEY + "&p=" + noToFetch + "&s=" + startItem).header("accept", "application/json").asJson();
                    jo = jsonResponse.getBody().getObject();
                    if (!jo.has("records")) continue;
                    JSONArray results = jo.getJSONArray("records");
                    for (int i = 0; i < results.length(); ++i) {
                        JSONObject springerJsonEntry = results.getJSONObject(i);
                        BibEntry entry = JSONEntryParser.parseSpringerJSONtoBibtex(springerJsonEntry);
                        inspector.addEntry(entry);
                        inspector.setProgress(++fetched, numberToFetch);
                    }
                }
                return true;
            }
            status.showMessage(Localization.lang("No entries found for the search string '%0'", encodedQuery), Localization.lang("Search %0", this.getTitle()), 1);
            return false;
        }
        catch (UnirestException | IOException e) {
            LOGGER.error("Error while fetching from " + this.getTitle(), e);
            ((ImportInspectionDialog)inspector).showErrorMessage(this.getTitle(), e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "Springer";
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_SPRINGER;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }
}

