/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.fetcher;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.importer.ImportInspectionDialog;
import net.sf.jabref.gui.importer.fetcher.EntryFetcher;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.ImportInspector;
import net.sf.jabref.logic.importer.OutputPrinter;
import net.sf.jabref.logic.importer.fetcher.BibsonomyScraper;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.net.URLDownload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class ScienceDirectFetcher
implements EntryFetcher {
    private static final String SCIENCE_DIRECT = "ScienceDirect";
    private static final Log LOGGER = LogFactory.getLog(ScienceDirectFetcher.class);
    private static final int MAX_PAGES_TO_LOAD = 8;
    private static final String WEBSITE_URL = "http://www.sciencedirect.com";
    private static final String SEARCH_URL = "http://www.sciencedirect.com/science/quicksearch?query=";
    private static final String LINK_PREFIX = "http://www.sciencedirect.com/science?_ob=ArticleURL&";
    private static final Pattern LINK_PATTERN = Pattern.compile("<a href=\"" + "http://www.sciencedirect.com/science?_ob=ArticleURL&".replaceAll("\\?", "\\\\?") + "([^\"]+)\"\"");
    private boolean stopFetching;

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_SCIENCEDIRECT;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return SCIENCE_DIRECT;
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        this.stopFetching = false;
        try {
            List<String> citations = ScienceDirectFetcher.getCitations(query);
            if (citations == null) {
                return false;
            }
            if (citations.isEmpty()) {
                status.showMessage(Localization.lang("No entries found for the search string '%0'", query), Localization.lang("Search %0", SCIENCE_DIRECT), 1);
                return false;
            }
            int i = 0;
            for (String cit : citations) {
                if (this.stopFetching) break;
                BibsonomyScraper.getEntry(cit, Globals.prefs.getImportFormatPreferences()).ifPresent(dialog::addEntry);
                dialog.setProgress(++i, citations.size());
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.warn("Communcation problems", e);
            ((ImportInspectionDialog)dialog).showErrorMessage(this.getTitle(), e.getLocalizedMessage());
            return false;
        }
    }

    private static List<String> getCitations(String query) throws IOException {
        String nextPage;
        ArrayList<String> ids = new ArrayList<String>();
        String urlQuery = SEARCH_URL + URLEncoder.encode(query, StandardCharsets.UTF_8.name());
        for (int count = 1; (nextPage = ScienceDirectFetcher.getCitationsFromUrl(urlQuery, ids)) != null && count < 8; ++count) {
            urlQuery = nextPage;
        }
        return ids;
    }

    private static String getCitationsFromUrl(String urlQuery, List<String> ids) throws IOException {
        String cont = new URLDownload(urlQuery).downloadToString(Globals.prefs.getDefaultEncoding());
        Matcher m = LINK_PATTERN.matcher(cont);
        if (m.find()) {
            while (m.find()) {
                ids.add(LINK_PREFIX + m.group(1));
                cont = cont.substring(m.end());
                m = LINK_PATTERN.matcher(cont);
            }
        } else {
            return null;
        }
        return null;
    }
}

