/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Locale;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.gui.importer.ImportInspectionDialog;
import net.sf.jabref.gui.importer.fetcher.EntryFetcher;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.ImportInspector;
import net.sf.jabref.logic.importer.OutputPrinter;
import net.sf.jabref.logic.importer.util.OAI2Handler;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.IdGenerator;
import net.sf.jabref.model.entry.MonthUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OAI2Fetcher
implements EntryFetcher {
    private static final Log LOGGER = LogFactory.getLog(OAI2Fetcher.class);
    private static final String OAI2_ARXIV_PREFIXIDENTIFIER = "oai%3AarXiv.org%3A";
    private static final String OAI2_ARXIV_HOST = "export.arxiv.org";
    private static final String OAI2_ARXIV_SCRIPT = "oai2";
    private static final String OAI2_ARXIV_METADATAPREFIX = "arXiv";
    private static final String OAI2_ARXIV_ARCHIVENAME = "ArXiv.org";
    private static final String OAI2_IDENTIFIER_FIELD = "oai2identifier";
    private SAXParser saxParser;
    private final String oai2Host;
    private final String oai2Script;
    private final String oai2MetaDataPrefix;
    private final String oai2PrefixIdentifier;
    private final String oai2ArchiveName;
    private boolean shouldContinue = true;
    private long waitTime = -1L;
    private Date lastCall;

    public OAI2Fetcher(String oai2Host, String oai2Script, String oai2Metadataprefix, String oai2Prefixidentifier, String oai2ArchiveName, long waitTimeMs) {
        this.oai2Host = oai2Host;
        this.oai2Script = oai2Script;
        this.oai2MetaDataPrefix = oai2Metadataprefix;
        this.oai2PrefixIdentifier = oai2Prefixidentifier;
        this.oai2ArchiveName = oai2ArchiveName;
        this.waitTime = waitTimeMs;
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            this.saxParser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            LOGGER.error("Error creating SAXParser for OAI2Fetcher", e);
        }
    }

    public OAI2Fetcher() {
        this(OAI2_ARXIV_HOST, OAI2_ARXIV_SCRIPT, OAI2_ARXIV_METADATAPREFIX, OAI2_ARXIV_PREFIXIDENTIFIER, OAI2_ARXIV_ARCHIVENAME, 20000L);
    }

    public String constructUrl(String key) {
        String identifier;
        try {
            identifier = URLEncoder.encode(key, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
        return "http://" + this.oai2Host + "/" + this.oai2Script + "?" + "verb=GetRecord" + "&identifier=" + this.oai2PrefixIdentifier + identifier + "&metadataPrefix=" + this.oai2MetaDataPrefix;
    }

    private boolean shouldWait() {
        return this.waitTime > 0L;
    }

    public static String fixKey(String key) {
        String resultingKey = key;
        if (resultingKey.toLowerCase(Locale.ENGLISH).startsWith("arxiv:")) {
            resultingKey = resultingKey.substring(6);
        }
        int dot = resultingKey.indexOf(46);
        int slash = resultingKey.indexOf(47);
        if (dot > -1 && dot < slash) {
            resultingKey = resultingKey.substring(0, dot) + resultingKey.substring(slash, resultingKey.length());
        }
        return resultingKey;
    }

    protected BibEntry importOai2Entry(String key) throws IOException, SAXException {
        String fixedKey = OAI2Fetcher.fixKey(key);
        String url = this.constructUrl(fixedKey);
        URL oai2Url = new URL(url);
        HttpURLConnection oai2Connection = (HttpURLConnection)oai2Url.openConnection();
        oai2Connection.setRequestProperty("User-Agent", "JabRef");
        BibEntry entry = new BibEntry(IdGenerator.next(), "article");
        entry.setField(OAI2_IDENTIFIER_FIELD, fixedKey);
        OAI2Handler handlerBase = new OAI2Handler(entry);
        try (InputStream inputStream = oai2Connection.getInputStream();){
            this.saxParser.parse(inputStream, (DefaultHandler)handlerBase);
            for (String name : entry.getFieldNames()) {
                entry.getField(name).ifPresent(content -> entry.setField(name, OAI2Handler.correctLineBreaks(content)));
            }
            if (fixedKey.matches("\\d\\d\\d\\d\\..*")) {
                entry.setField("year", "20" + fixedKey.substring(0, 2));
                int monthNumber = Integer.parseInt(fixedKey.substring(2, 4));
                MonthUtil.Month month = MonthUtil.getMonthByNumber(monthNumber);
                if (month.isValid()) {
                    entry.setField("month", month.bibtexFormat);
                }
            }
        }
        return entry;
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_OAI2_ARXIV;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return OAI2_ARXIV_ARCHIVENAME;
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        try {
            this.shouldContinue = true;
            String[] keys = query.replace(" ", ";").split(";");
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (this.shouldWait() && this.lastCall != null) {
                    long elapsed = new Date().getTime() - this.lastCall.getTime();
                    while (elapsed < this.waitTime) {
                        status.setStatus(Localization.lang("Waiting for ArXiv...", new String[0]) + (this.waitTime - elapsed) / 1000L + " s");
                        Thread.sleep(1000L);
                        elapsed = new Date().getTime() - this.lastCall.getTime();
                    }
                }
                status.setStatus(Localization.lang("Processing %0", key));
                if (!this.shouldContinue) break;
                BibEntry be = null;
                try {
                    be = this.importOai2Entry(key);
                }
                catch (SAXException e) {
                    String url = this.constructUrl(OAI2Fetcher.fixKey(key));
                    LOGGER.error("Error while fetching from " + this.getTitle(), e);
                    ((ImportInspectionDialog)dialog).showMessage(Localization.lang("Error while fetching from %0", this.getTitle()) + "\n" + Localization.lang("A SAX exception occurred while parsing '%0':", url), Localization.lang("Search %0", this.getTitle()), 0);
                }
                if (this.shouldWait()) {
                    this.lastCall = new Date();
                }
                if (be != null) {
                    dialog.addEntry(be);
                }
                dialog.setProgress(i + 1, keys.length);
            }
            return true;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Error while fetching from " + this.getTitle(), e);
            ((ImportInspectionDialog)dialog).showErrorMessage(this.getTitle(), e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }
}

