/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.swing.JPanel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.importer.ImportInspectionDialog;
import net.sf.jabref.gui.importer.fetcher.EntryFetcher;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.ImportInspector;
import net.sf.jabref.logic.importer.OutputPrinter;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.importer.fileformat.BibtexParser;
import net.sf.jabref.logic.importer.util.INSPIREBibtexFilterReader;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class INSPIREFetcher
implements EntryFetcher {
    private static final String INSPIRE_HOST = "inspirehep.net";
    private static final Log LOGGER = LogFactory.getLog(INSPIREFetcher.class);

    private String constructUrl(String key) {
        String identifier;
        try {
            identifier = URLEncoder.encode(key, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
        StringBuilder sb = new StringBuilder(87).append("http://").append(INSPIRE_HOST).append("/search?ln=en&ln=en&p=find+").append(identifier).append("&action_search=Search&sf=&so=d&rm=&rg=1000&sc=0&of=hx");
        LOGGER.debug("Inspire URL: " + sb + "\n");
        return sb.toString();
    }

    private BibDatabase importInspireEntries(String key, OutputPrinter frame) throws IOException {
        String url = this.constructUrl(key);
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("User-Agent", "JabRef");
        InputStream inputStream = conn.getInputStream();
        try (INSPIREBibtexFilterReader reader = new INSPIREBibtexFilterReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            ParserResult pr = BibtexParser.parse(reader, Globals.prefs.getImportFormatPreferences());
            BibDatabase bibDatabase = pr.getDatabase();
            return bibDatabase;
        }
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_INSPIRE;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return "INSPIRE";
    }

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        try {
            status.setStatus(Localization.lang("Fetching entries from Inspire", new String[0]));
            BibDatabase bd = this.importInspireEntries(query, status);
            status.setStatus(Localization.lang("Adding fetched entries", new String[0]));
            bd.getEntries().forEach(dialog::addEntry);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching from " + this.getTitle(), e);
            ((ImportInspectionDialog)dialog).showErrorMessage(this.getTitle(), e.getLocalizedMessage());
            return false;
        }
    }
}

