/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.fetcher;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.SidePaneComponent;
import net.sf.jabref.gui.SidePaneManager;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.importer.FetcherPreviewDialog;
import net.sf.jabref.gui.importer.ImportInspectionDialog;
import net.sf.jabref.gui.importer.fetcher.EntryFetcher;
import net.sf.jabref.gui.importer.fetcher.EntryFetchers;
import net.sf.jabref.gui.importer.fetcher.PreviewEntryFetcher;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.OS;

public class GeneralFetcher
extends SidePaneComponent
implements ActionListener {
    private final JTextField tf = new JTextField();
    private final CardLayout optionsCards = new CardLayout();
    private final JPanel optionsPanel = new JPanel(this.optionsCards);
    private final JPanel optPanel = new JPanel(new BorderLayout());
    private final SidePaneComponent.ToggleAction action;
    private final JabRefFrame frame;
    private EntryFetcher activeFetcher;

    public GeneralFetcher(JabRefFrame frame, SidePaneManager sidePaneManager) {
        super(sidePaneManager, IconTheme.JabRefIcon.WWW.getSmallIcon(), Localization.lang("Web search", new String[0]));
        this.frame = frame;
        List<EntryFetcher> fetchers = new EntryFetchers(Globals.journalAbbreviationLoader).getEntryFetchers();
        EntryFetcher[] fetcherArray = fetchers.toArray(new EntryFetcher[fetchers.size()]);
        Arrays.sort(fetcherArray, new EntryFetcherComparator());
        String[] choices = new String[fetcherArray.length];
        for (int i = 0; i < fetcherArray.length; ++i) {
            choices[i] = fetcherArray[i].getTitle();
        }
        JComboBox<String> fetcherChoice = new JComboBox<String>(choices);
        int defaultFetcher = Globals.prefs.getInt("selectedFetcherIndex");
        if (defaultFetcher >= fetcherArray.length) {
            defaultFetcher = 0;
        }
        this.activeFetcher = fetcherArray[defaultFetcher];
        fetcherChoice.setSelectedIndex(defaultFetcher);
        if (this.activeFetcher.getOptionsPanel() != null) {
            this.optPanel.add((Component)this.activeFetcher.getOptionsPanel(), "Center");
        }
        HelpAction help = new HelpAction(this.activeFetcher.getHelpPage());
        JButton helpBut = help.getHelpButton();
        helpBut.setEnabled(this.activeFetcher.getHelpPage() != null);
        fetcherChoice.addActionListener(actionEvent -> {
            this.activeFetcher = fetcherArray[fetcherChoice.getSelectedIndex()];
            Globals.prefs.putInt("selectedFetcherIndex", fetcherChoice.getSelectedIndex());
            if (this.activeFetcher.getHelpPage() == null) {
                helpBut.setEnabled(false);
            } else {
                help.setHelpFile(this.activeFetcher.getHelpPage());
                helpBut.setEnabled(true);
            }
            this.optionsCards.show(this.optionsPanel, String.valueOf(fetcherChoice.getSelectedIndex()));
            this.optPanel.removeAll();
            if (this.activeFetcher.getOptionsPanel() != null) {
                this.optPanel.add((Component)this.activeFetcher.getOptionsPanel(), "Center");
            }
            this.revalidate();
        });
        this.action = (SidePaneComponent)this.new SidePaneComponent.ToggleAction(Localization.lang("Web search", new String[0]), Localization.lang("Toggle web search interface", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.WEB_SEARCH), IconTheme.JabRefIcon.WWW);
        helpBut.setMargin(new Insets(0, 0, 0, 0));
        this.tf.setPreferredSize(new Dimension(1, this.tf.getPreferredSize().height));
        if (OS.OS_X) {
            this.tf.putClientProperty("JTextField.variant", "search");
        }
        this.tf.setName("tf");
        JButton reset = new JButton(Localization.lang("Reset", new String[0]));
        reset.addActionListener(event -> {
            this.tf.setText("");
            this.tf.requestFocus();
        });
        JPanel main = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        main.setLayout(gbl);
        GridBagConstraints con = new GridBagConstraints();
        con.fill = 1;
        con.insets = new Insets(0, 0, 2, 0);
        con.gridwidth = 0;
        con.weightx = 1.0;
        con.weighty = 1.0;
        con.insets = new Insets(1, 0, 1, 0);
        con.fill = 1;
        gbl.setConstraints(fetcherChoice, con);
        main.add(fetcherChoice);
        con.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(this.tf, con);
        main.add(this.tf);
        con.weighty = 0.0;
        con.gridwidth = 1;
        JButton go = new JButton(Localization.lang("Fetch", new String[0]));
        gbl.setConstraints(go, con);
        main.add(go);
        reset.setName("reset");
        gbl.setConstraints(reset, con);
        main.add(reset);
        con.gridwidth = 0;
        gbl.setConstraints(helpBut, con);
        main.add(helpBut);
        gbl.setConstraints(this.optPanel, con);
        main.add(this.optPanel);
        main.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)main, "Center");
        go.addActionListener(this);
        this.tf.addActionListener(this);
    }

    private JTextField getTextField() {
        return this.tf;
    }

    @Override
    public SidePaneComponent.ToggleAction getToggleAction() {
        return this.action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.tf.getText().trim().isEmpty()) {
            this.frame.output(Localization.lang("Please enter a search string", new String[0]));
            return;
        }
        if (this.frame.getCurrentBasePanel() == null) {
            this.frame.output(Localization.lang("Please open or start a new database before searching", new String[0]));
            return;
        }
        if (this.activeFetcher instanceof PreviewEntryFetcher) {
            this.frame.output(Localization.lang("Searching...", new String[0]));
            this.frame.setProgressBarIndeterminate(true);
            this.frame.setProgressBarVisible(true);
            PreviewEntryFetcher pFetcher = (PreviewEntryFetcher)this.activeFetcher;
            FetcherPreviewDialog dialog = new FetcherPreviewDialog(this.frame, pFetcher.getWarningLimit(), pFetcher.getPreferredPreviewHeight());
            JabRefExecutorService.INSTANCE.execute(() -> {
                boolean result = pFetcher.processQueryGetPreview(this.tf.getText().trim(), dialog, dialog);
                SwingUtilities.invokeLater(() -> {
                    this.frame.setProgressBarVisible(false);
                    this.frame.output("");
                    if (result) {
                        dialog.setLocationRelativeTo(this.frame);
                        dialog.setVisible(true);
                        if (dialog.isOkPressed()) {
                            ImportInspectionDialog d2 = new ImportInspectionDialog(this.frame, this.frame.getCurrentBasePanel(), this.activeFetcher.getTitle(), false);
                            d2.addCallBack(this.activeFetcher);
                            d2.setLocationRelativeTo(this.frame);
                            d2.setVisible(true);
                            JabRefExecutorService.INSTANCE.execute(() -> {
                                pFetcher.getEntries(dialog.getSelection(), d2);
                                d2.entryListComplete();
                            });
                        }
                    }
                });
            });
        } else {
            ImportInspectionDialog dialog = new ImportInspectionDialog(this.frame, this.frame.getCurrentBasePanel(), this.activeFetcher.getTitle(), false);
            dialog.addCallBack(this.activeFetcher);
            dialog.setLocationRelativeTo(this.frame);
            dialog.setVisible(true);
            JabRefExecutorService.INSTANCE.execute(() -> {
                if (this.activeFetcher.processQuery(this.tf.getText().trim(), dialog, dialog)) {
                    dialog.entryListComplete();
                } else {
                    dialog.dispose();
                }
            });
        }
    }

    @Override
    public void grabFocus() {
        this.getTextField().grabFocus();
    }

    @Override
    public void componentClosing() {
        super.componentClosing();
        this.getToggleAction().setSelected(false);
        Globals.prefs.putBoolean("webSearchVisible", Boolean.FALSE);
    }

    @Override
    public void componentOpening() {
        super.componentOpening();
        Globals.prefs.putBoolean("webSearchVisible", Boolean.TRUE);
    }

    @Override
    public int getRescalingWeight() {
        return 0;
    }

    private static class EntryFetcherComparator
    implements Comparator<EntryFetcher> {
        private EntryFetcherComparator() {
        }

        @Override
        public int compare(EntryFetcher entryFetcher, EntryFetcher entryFetcher1) {
            return entryFetcher.getTitle().compareTo(entryFetcher1.getTitle());
        }
    }
}

