/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.fetcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.importer.fetcher.ACMPortalFetcher;
import net.sf.jabref.gui.importer.fetcher.CiteSeerXFetcher;
import net.sf.jabref.gui.importer.fetcher.DBLPFetcher;
import net.sf.jabref.gui.importer.fetcher.DOAJFetcher;
import net.sf.jabref.gui.importer.fetcher.EntryFetcher;
import net.sf.jabref.gui.importer.fetcher.IEEEXploreFetcher;
import net.sf.jabref.gui.importer.fetcher.INSPIREFetcher;
import net.sf.jabref.gui.importer.fetcher.SearchBasedEntryFetcher;
import net.sf.jabref.gui.importer.fetcher.SpringerFetcher;
import net.sf.jabref.logic.importer.IdBasedFetcher;
import net.sf.jabref.logic.importer.fetcher.ArXiv;
import net.sf.jabref.logic.importer.fetcher.AstrophysicsDataSystem;
import net.sf.jabref.logic.importer.fetcher.DiVA;
import net.sf.jabref.logic.importer.fetcher.DoiFetcher;
import net.sf.jabref.logic.importer.fetcher.GoogleScholar;
import net.sf.jabref.logic.importer.fetcher.GvkFetcher;
import net.sf.jabref.logic.importer.fetcher.IsbnFetcher;
import net.sf.jabref.logic.importer.fetcher.MathSciNet;
import net.sf.jabref.logic.importer.fetcher.MedlineFetcher;
import net.sf.jabref.logic.importer.fetcher.zbMATH;
import net.sf.jabref.logic.journals.JournalAbbreviationLoader;

public class EntryFetchers {
    private final List<EntryFetcher> entryFetchers = new LinkedList<EntryFetcher>();

    public EntryFetchers(JournalAbbreviationLoader abbreviationLoader) {
        this.entryFetchers.add(new CiteSeerXFetcher());
        this.entryFetchers.add(new DBLPFetcher());
        this.entryFetchers.add(new IEEEXploreFetcher(abbreviationLoader));
        this.entryFetchers.add(new INSPIREFetcher());
        this.entryFetchers.add(new ACMPortalFetcher());
        this.entryFetchers.add(new DOAJFetcher());
        this.entryFetchers.add(new SpringerFetcher());
        this.entryFetchers.add(new SearchBasedEntryFetcher(new ArXiv(Globals.prefs.getImportFormatPreferences())));
        this.entryFetchers.add(new SearchBasedEntryFetcher(new GvkFetcher()));
        this.entryFetchers.add(new SearchBasedEntryFetcher(new MedlineFetcher()));
        this.entryFetchers.add(new SearchBasedEntryFetcher(new AstrophysicsDataSystem(Globals.prefs.getImportFormatPreferences())));
        this.entryFetchers.add(new SearchBasedEntryFetcher(new MathSciNet(Globals.prefs.getImportFormatPreferences())));
        this.entryFetchers.add(new SearchBasedEntryFetcher(new zbMATH(Globals.prefs.getImportFormatPreferences())));
        this.entryFetchers.add(new SearchBasedEntryFetcher(new GoogleScholar(Globals.prefs.getImportFormatPreferences())));
    }

    public List<EntryFetcher> getEntryFetchers() {
        return Collections.unmodifiableList(this.entryFetchers);
    }

    public static ArrayList<IdBasedFetcher> getIdFetchers() {
        ArrayList<IdBasedFetcher> list = new ArrayList<IdBasedFetcher>();
        list.add(new AstrophysicsDataSystem(Globals.prefs.getImportFormatPreferences()));
        list.add(new IsbnFetcher(Globals.prefs.getImportFormatPreferences()));
        list.add(new DiVA(Globals.prefs.getImportFormatPreferences()));
        list.add(new DoiFetcher(Globals.prefs.getImportFormatPreferences()));
        list.add(new MedlineFetcher());
        list.sort((fetcher1, fetcher2) -> fetcher1.getName().compareTo(fetcher2.getName()));
        return list;
    }
}

