/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.fetcher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.importer.ImportInspectionDialog;
import net.sf.jabref.gui.importer.fetcher.EntryFetcher;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.ImportInspector;
import net.sf.jabref.logic.importer.OutputPrinter;
import net.sf.jabref.logic.importer.fileformat.BibtexParser;
import net.sf.jabref.logic.importer.util.DBLPHelper;
import net.sf.jabref.logic.net.URLDownload;
import net.sf.jabref.model.DuplicateCheck;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBLPFetcher
implements EntryFetcher {
    private static final Log LOGGER = LogFactory.getLog(DBLPFetcher.class);
    private static final String URL_START = "http://www.dblp.org/search/api/";
    private static final String URL_PART1 = "?q=";
    private static final String URL_END = "&h=1000&c=4&f=0&format=json";
    private volatile boolean shouldContinue;
    private String query;
    private final DBLPHelper helper = new DBLPHelper(Globals.prefs.getImportFormatPreferences());

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processQuery(String newQuery, ImportInspector inspector, OutputPrinter status) {
        HashMap<String, Boolean> bibentryKnown = new HashMap<String, Boolean>();
        this.query = newQuery;
        this.shouldContinue = true;
        double saveThreshold = DuplicateCheck.duplicateThreshold;
        try {
            String address = this.makeSearchURL();
            URLDownload dl = new URLDownload(address);
            String page = dl.downloadToString(Globals.prefs.getDefaultEncoding());
            String[] lines = page.split("\n");
            ArrayList<String> bibtexUrlList = new ArrayList<String>();
            for (String line : lines) {
                if (!line.startsWith("\"url\"")) continue;
                String addr = line.replace("\"url\":\"", "");
                addr = addr.substring(0, addr.length() - 2);
                bibtexUrlList.add(addr);
            }
            DuplicateCheck.duplicateThreshold = Double.MAX_VALUE;
            int count = 1;
            for (String urlStr : bibtexUrlList) {
                String[] htmlLines;
                if (!this.shouldContinue) break;
                String bibtexHTMLPage = new URLDownload(urlStr).downloadToString(Globals.prefs.getDefaultEncoding());
                for (String line : htmlLines = bibtexHTMLPage.split("\n")) {
                    if (!line.contains("biburl")) continue;
                    int sidx = line.indexOf(123);
                    int eidx = line.indexOf(125);
                    String bibtexUrl = line.substring(sidx + 1, eidx);
                    bibtexUrl = bibtexUrl.replace("dblp.uni-trier.de", "www.dblp.org");
                    String bibtexPage = new URLDownload(bibtexUrl).downloadToString(Globals.prefs.getDefaultEncoding());
                    List<BibEntry> bibtexEntries = BibtexParser.fromString(bibtexPage, Globals.prefs.getImportFormatPreferences());
                    for (BibEntry be : bibtexEntries) {
                        if (bibentryKnown.containsKey(be.getCiteKey())) continue;
                        inspector.addEntry(be);
                        bibentryKnown.put(be.getCiteKey(), true);
                    }
                }
                inspector.setProgress(count, bibtexUrlList.size());
                ++count;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Error while fetching from " + this.getTitle(), e);
            ((ImportInspectionDialog)inspector).showErrorMessage(this.getTitle(), e.getLocalizedMessage());
        }
        finally {
            DuplicateCheck.duplicateThreshold = saveThreshold;
        }
        return false;
    }

    private String makeSearchURL() {
        StringBuilder sb = new StringBuilder(URL_START).append(URL_PART1);
        String cleanedQuery = this.helper.cleanDBLPQuery(this.query);
        sb.append(cleanedQuery).append(URL_END);
        return sb.toString();
    }

    @Override
    public String getTitle() {
        return "DBLP";
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_DBLP;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }
}

