/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.fetcher;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.importer.FetcherPreviewDialog;
import net.sf.jabref.gui.importer.fetcher.PreviewEntryFetcher;
import net.sf.jabref.logic.formatter.bibtexfields.HtmlToLatexFormatter;
import net.sf.jabref.logic.formatter.bibtexfields.UnitsToLatexFormatter;
import net.sf.jabref.logic.formatter.casechanger.ProtectTermsFormatter;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.ImportInspector;
import net.sf.jabref.logic.importer.OutputPrinter;
import net.sf.jabref.logic.importer.fileformat.BibtexParser;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.net.URLDownload;
import net.sf.jabref.model.entry.BibEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ACMPortalFetcher
implements PreviewEntryFetcher {
    private static final Log LOGGER = LogFactory.getLog(ACMPortalFetcher.class);
    private final HtmlToLatexFormatter htmlToLatexFormatter = new HtmlToLatexFormatter();
    private final ProtectTermsFormatter protectTermsFormatter = new ProtectTermsFormatter();
    private final UnitsToLatexFormatter unitsToLatexFormatter = new UnitsToLatexFormatter();
    private String terms;
    private static final String START_URL = "http://portal.acm.org/";
    private static final String SEARCH_URL_PART = "results.cfm?query=";
    private static final String SEARCH_URL_PART_II = "&dl=";
    private static final String END_URL = "&coll=Portal&short=0";
    private static final String BIBTEX_URL = "exportformats.cfm?id=";
    private static final String BIBTEX_URL_END = "&expformat=bibtex";
    private static final String ABSTRACT_URL = "tab_abstract.cfm?id=";
    private static final String NEXT_ENTRY_PATTERN = "<div class=\"numbering\">";
    private static final String AUTHOR_MARKER = "<div class=\"authors\">";
    private static final String SOURCE_MARKER = "<div class=\"source\">";
    private static final String END_ENTRY_PATTERN = "<br clear=\"all\" />";
    private static final String RESULTS_FOUND_PATTERN = "<div id=\"resfound\">";
    private static final String PAGE_RANGE_PATTERN = "<div class=\"pagerange\">";
    private final JRadioButton acmButton = new JRadioButton(Localization.lang("The ACM Digital Library", new String[0]));
    private final JRadioButton guideButton = new JRadioButton(Localization.lang("The Guide to Computing Literature", new String[0]));
    private final JCheckBox absCheckBox = new JCheckBox(Localization.lang("Include abstracts", new String[0]), false);
    private static final int PER_PAGE = 20;
    private static final int WAIT_TIME = 200;
    private boolean shouldContinue;
    private boolean fetchAbstract;
    private boolean acmOrGuide;
    private int piv;
    private static final Pattern HITS_PATTERN = Pattern.compile("<strong>(\\d+,*\\d*)</strong> results found");
    private static final Pattern MAX_HITS_PATTERN = Pattern.compile("Result \\d+,*\\d* &ndash; \\d+,*\\d* of (\\d+,*\\d*)");
    private static final Pattern FULL_CITATION_PATTERN = Pattern.compile("<a href=\"(citation.cfm.*)\" target.*");
    private static final Pattern ID_PATTERN = Pattern.compile("citation.cfm\\?id=(\\d+)&.*");
    private static final Pattern TITLE_PATTERN = Pattern.compile("<a href=.*?\">([^<]*)</a>");
    private static final Pattern ABSTRACT_PATTERN = Pattern.compile("<div .*?>(.*?)</div>");
    private static final Pattern SOURCE_PATTERN = Pattern.compile("<span style=\"padding-left:10px\">([^<]*)</span>");

    @Override
    public JPanel getOptionsPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(new GridLayout(0, 1));
        this.guideButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.acmButton);
        group.add(this.guideButton);
        pan.add(this.absCheckBox);
        pan.add(this.acmButton);
        pan.add(this.guideButton);
        return pan;
    }

    @Override
    public boolean processQueryGetPreview(String query, FetcherPreviewDialog preview, OutputPrinter status) {
        this.terms = query;
        this.piv = 0;
        this.shouldContinue = true;
        this.acmOrGuide = this.acmButton.isSelected();
        this.fetchAbstract = this.absCheckBox.isSelected();
        String address = this.makeUrl();
        LinkedHashMap<String, JLabel> previews = new LinkedHashMap<String, JLabel>();
        try {
            URLDownload dl = new URLDownload(address);
            String page = dl.downloadToString(Globals.prefs.getDefaultEncoding());
            int hits = ACMPortalFetcher.getNumberOfHits(page, RESULTS_FOUND_PATTERN, HITS_PATTERN);
            int index = page.indexOf(RESULTS_FOUND_PATTERN);
            if (index >= 0) {
                page = page.substring(index + RESULTS_FOUND_PATTERN.length());
            }
            if (hits == 0) {
                status.showMessage(Localization.lang("No entries found for the search string '%0'", this.terms), Localization.lang("Search %0", this.getTitle()), 1);
                return false;
            }
            if (hits > 20) {
                status.showMessage(Localization.lang("%0 entries found. To reduce server load, only %1 will be downloaded.", String.valueOf(hits), String.valueOf(20)), Localization.lang("Search %0", this.getTitle()), 1);
            }
            hits = ACMPortalFetcher.getNumberOfHits(page, PAGE_RANGE_PATTERN, MAX_HITS_PATTERN);
            this.parse(page, Math.min(hits, 20), previews);
            for (Map.Entry<String, JLabel> entry : previews.entrySet()) {
                preview.addEntry(entry.getKey(), entry.getValue());
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Error while fetching from " + this.getTitle(), e);
            preview.showErrorMessage(this.getTitle(), e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public void getEntries(Map<String, Boolean> selection, ImportInspector inspector) {
        for (Map.Entry<String, Boolean> selentry : selection.entrySet()) {
            if (!this.shouldContinue) break;
            if (!selentry.getValue().booleanValue()) continue;
            ACMPortalFetcher.downloadEntryBibTeX(selentry.getKey(), this.fetchAbstract).ifPresent(entry -> {
                entry.getField("title").ifPresent(title -> {
                    title = title.replace("\\&", "&").replace("\\#", "#");
                    title = this.convertHTMLChars((String)title);
                    if (Globals.prefs.getBoolean("useUnitFormatterOnSearch")) {
                        title = this.unitsToLatexFormatter.format((String)title);
                    }
                    if (Globals.prefs.getBoolean("useCaseKeeperOnSearch")) {
                        title = this.protectTermsFormatter.format((String)title);
                    }
                    entry.setField("title", (String)title);
                });
                entry.getField("abstract").ifPresent(abstr -> entry.setField("abstract", this.convertHTMLChars((String)abstr)));
                inspector.addEntry((BibEntry)entry);
            });
        }
    }

    @Override
    public int getWarningLimit() {
        return 10;
    }

    @Override
    public int getPreferredPreviewHeight() {
        return 75;
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        return false;
    }

    private String makeUrl() {
        StringBuilder sb = new StringBuilder(START_URL).append(SEARCH_URL_PART).append(this.terms.replace(" ", "%20")).append(SEARCH_URL_PART_II);
        if (this.acmOrGuide) {
            sb.append("ACM");
        } else {
            sb.append("GUIDE");
        }
        sb.append(END_URL);
        return sb.toString();
    }

    private void parse(String text, int hits, Map<String, JLabel> entries) {
        for (int entryNumber = 1; this.getNextEntryURL(text, entryNumber, entries) && entryNumber <= hits; ++entryNumber) {
        }
    }

    private static String getEntryBibTeXURL(String fullCitation) {
        Matcher idMatcher = ID_PATTERN.matcher(fullCitation);
        if (idMatcher.find()) {
            return idMatcher.group(1);
        }
        LOGGER.info("Did not find ID in: " + fullCitation);
        return null;
    }

    private boolean getNextEntryURL(String allText, int entryNumber, Map<String, JLabel> entries) {
        int endIndex;
        int index = allText.indexOf(NEXT_ENTRY_PATTERN, this.piv);
        this.piv = endIndex = allText.indexOf(END_ENTRY_PATTERN, index);
        if (index >= 0) {
            String text = allText.substring(index, endIndex);
            Matcher fullCitation = FULL_CITATION_PATTERN.matcher(text);
            if (fullCitation.find()) {
                String item;
                String link = ACMPortalFetcher.getEntryBibTeXURL(fullCitation.group(1));
                if (endIndex > 0) {
                    String sourceText;
                    Matcher source;
                    int sourceEnd;
                    int sourceStart;
                    Matcher titM;
                    int authEnd;
                    StringBuilder sb = new StringBuilder();
                    int authStart = text.indexOf(AUTHOR_MARKER);
                    if (authStart >= 0 && (authEnd = text.indexOf("</div>", authStart + AUTHOR_MARKER.length())) >= 0) {
                        sb.append("<p>").append(text.substring(authStart, authEnd)).append("</p>");
                    }
                    if ((titM = TITLE_PATTERN.matcher(text)).find()) {
                        sb.append("<p>").append(titM.group(1)).append("</p>");
                    }
                    if ((sourceStart = text.indexOf(SOURCE_MARKER)) >= 0 && (sourceEnd = text.indexOf("</div>", sourceStart + SOURCE_MARKER.length())) >= 0 && (source = SOURCE_PATTERN.matcher(sourceText = text.substring(sourceStart, sourceEnd))).find()) {
                        sb.append("<p>").append(source.group(1)).append("</p>");
                    }
                    item = sb.toString();
                } else {
                    item = link;
                }
                JLabel preview = new JLabel("<html>" + item + "</html>");
                preview.setPreferredSize(new Dimension(750, 100));
                entries.put(link, preview);
                return true;
            }
            LOGGER.warn("Citation unmatched " + Integer.toString(entryNumber));
            return false;
        }
        return false;
    }

    private static Optional<BibEntry> downloadEntryBibTeX(String id, boolean downloadAbstract) {
        try {
            URL url = new URL("http://portal.acm.org/exportformats.cfm?id=" + id + BIBTEX_URL_END);
            URLConnection connection = url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 5.1; rv:31.0) Gecko/20100101 Firefox/31.0");
            List<BibEntry> items = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                items = BibtexParser.parse(in, Globals.prefs.getImportFormatPreferences()).getDatabase().getEntries();
            }
            catch (IOException e) {
                LOGGER.info("Download of BibTeX information from ACM Portal failed.", e);
            }
            if (items == null || items.isEmpty()) {
                return Optional.empty();
            }
            BibEntry entry = (BibEntry)items.iterator().next();
            Thread.sleep(200L);
            if (downloadAbstract) {
                URLDownload dl = new URLDownload("http://portal.acm.org/tab_abstract.cfm?id=" + id);
                String page = dl.downloadToString(Globals.prefs.getDefaultEncoding());
                Matcher absM = ABSTRACT_PATTERN.matcher(page);
                if (absM.find()) {
                    entry.setField("abstract", absM.group(1).trim());
                }
                Thread.sleep(200L);
            }
            return Optional.of(entry);
        }
        catch (NoSuchElementException e) {
            LOGGER.info("Bad BibTeX record read at: exportformats.cfm?id=" + id + BIBTEX_URL_END, e);
        }
        catch (MalformedURLException e) {
            LOGGER.info("Malformed URL.", e);
        }
        catch (IOException e) {
            LOGGER.info("Cannot connect.", e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Optional.empty();
    }

    private String convertHTMLChars(String text) {
        return this.htmlToLatexFormatter.format(text);
    }

    private static int getNumberOfHits(String page, String marker, Pattern pattern) throws IOException {
        int ind = page.indexOf(marker);
        if (ind >= 0) {
            String substring = page.substring(ind, Math.min(ind + 100, page.length()));
            Matcher m = pattern.matcher(substring);
            if (m.find()) {
                try {
                    String number = m.group(1);
                    number = number.replace(",", "");
                    return Integer.parseInt(number);
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Cannot parse number of hits");
                }
            }
            LOGGER.info("Unmatched! " + substring);
        }
        throw new IOException("Cannot parse number of hits");
    }

    @Override
    public String getTitle() {
        return "ACM Portal";
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_ACM;
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }
}

