/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.FileTime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.gui.autosaveandbackup.BackupUIManager;
import net.sf.jabref.gui.importer.ParserResultWarningDialog;
import net.sf.jabref.gui.importer.actions.CheckForNewEntryTypesAction;
import net.sf.jabref.gui.importer.actions.ConvertLegacyExplicitGroups;
import net.sf.jabref.gui.importer.actions.HandleDuplicateWarnings;
import net.sf.jabref.gui.importer.actions.PostOpenAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.shared.SharedDatabaseUIManager;
import net.sf.jabref.logic.autosaveandbackup.BackupManager;
import net.sf.jabref.logic.importer.OpenDatabase;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.FileExtensions;
import net.sf.jabref.logic.util.io.FileBasedLock;
import net.sf.jabref.migrations.FileLinksUpgradeWarning;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.strings.StringUtil;
import net.sf.jabref.shared.exception.DatabaseNotSupportedException;
import net.sf.jabref.shared.exception.InvalidDBMSConnectionPropertiesException;
import net.sf.jabref.shared.exception.NotASharedDatabaseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenDatabaseAction
extends MnemonicAwareAction {
    public static final Log LOGGER = LogFactory.getLog(OpenDatabaseAction.class);
    private final boolean showDialog;
    private final JabRefFrame frame;
    private static final List<PostOpenAction> POST_OPEN_ACTIONS = new ArrayList<PostOpenAction>();

    public OpenDatabaseAction(JabRefFrame frame, boolean showDialog) {
        super(IconTheme.JabRefIcon.OPEN.getIcon());
        this.frame = frame;
        this.showDialog = showDialog;
        this.putValue("Name", Localization.menuTitle("Open database", new String[0]));
        this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.OPEN_DATABASE));
        this.putValue("ShortDescription", Localization.lang("Open BibTeX database", new String[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<File> filesToOpen = new ArrayList<File>();
        if (this.showDialog) {
            FileDialog dialog = new FileDialog(this.frame).withExtension(FileExtensions.BIBTEX_DB);
            dialog.setDefaultExtension(FileExtensions.BIBTEX_DB);
            List<String> chosenStrings = dialog.showDialogAndGetMultipleFiles();
            filesToOpen.addAll(chosenStrings.stream().map(File::new).collect(Collectors.toList()));
        } else {
            LOGGER.info("Name " + e.getActionCommand());
            filesToOpen.add(new File(StringUtil.getCorrectFileName(e.getActionCommand(), "bib")));
        }
        this.openFiles(filesToOpen, true);
    }

    public void openFile(File file, boolean raisePanel) {
        ArrayList<File> filesToOpen = new ArrayList<File>();
        filesToOpen.add(file);
        this.openFiles(filesToOpen, raisePanel);
    }

    public void openFilesAsStringList(List<String> fileNamesToOpen, boolean raisePanel) {
        ArrayList<File> filesToOpen = new ArrayList<File>();
        for (String fileName : fileNamesToOpen) {
            filesToOpen.add(new File(fileName));
        }
        this.openFiles(filesToOpen, raisePanel);
    }

    public void openFiles(List<File> filesToOpen, boolean raisePanel) {
        BasePanel toRaise = null;
        int initialCount = filesToOpen.size();
        int removed = 0;
        Iterator<File> iterator = filesToOpen.iterator();
        block0: while (iterator.hasNext()) {
            File file = iterator.next();
            for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
                BasePanel basePanel = this.frame.getBasePanelAt(i);
                if (!basePanel.getBibDatabaseContext().getDatabaseFile().isPresent() || !basePanel.getBibDatabaseContext().getDatabaseFile().get().equals(file)) continue;
                iterator.remove();
                if (++removed != initialCount) continue block0;
                toRaise = basePanel;
                continue block0;
            }
        }
        if (!filesToOpen.isEmpty()) {
            List<File> theFiles = Collections.unmodifiableList(filesToOpen);
            JabRefExecutorService.INSTANCE.execute(() -> {
                for (File theFile : theFiles) {
                    this.openTheFile(theFile, raisePanel);
                }
            });
            for (File theFile : theFiles) {
                this.frame.getFileHistory().newFile(theFile.getPath());
            }
        } else if (toRaise != null) {
            this.frame.output(Localization.lang("File '%0' is already open.", toRaise.getBibDatabaseContext().getDatabaseFile().get().getPath()));
            this.frame.getTabbedPane().setSelectedComponent(toRaise);
        }
        this.frame.output(Localization.lang("Files opened", new String[0]) + ": " + filesToOpen.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openTheFile(File file, boolean raisePanel) {
        ParserResult result;
        if (file == null || !file.exists()) return;
        File fileToLoad = file;
        this.frame.output(Localization.lang("Opening", new String[0]) + ": '" + file.getPath() + "'");
        String fileName = file.getPath();
        Globals.prefs.put("workingDirectory", file.getParent());
        if (FileBasedLock.hasLockFile(file.toPath())) {
            Optional<FileTime> modificationTime = FileBasedLock.getLockFileTimeStamp(file.toPath());
            if (modificationTime.isPresent() && System.currentTimeMillis() - modificationTime.get().toMillis() > 60000L) {
                int answer = JOptionPane.showConfirmDialog(null, "<html>" + Localization.lang("Error opening file", new String[0]) + " '" + fileName + "'. " + Localization.lang("File is locked by another JabRef instance.", new String[0]) + "<p>" + Localization.lang("Do you want to override the file lock?", new String[0]), Localization.lang("File locked", new String[0]), 0);
                if (answer != 0) return;
                FileBasedLock.deleteLockFile(file.toPath());
            } else if (!FileBasedLock.waitForFileLock(file.toPath())) {
                JOptionPane.showMessageDialog(null, Localization.lang("Error opening file", new String[0]) + " '" + fileName + "'. " + Localization.lang("File is locked by another JabRef instance.", new String[0]), Localization.lang("Error", new String[0]), 0);
                return;
            }
        }
        if (BackupManager.checkForBackupFile(fileToLoad.toPath())) {
            BackupUIManager.showRestoreBackupDialog(this.frame, fileToLoad.toPath());
        }
        try {
            result = OpenDatabase.loadDatabase(fileToLoad, Globals.prefs.getImportFormatPreferences());
        }
        catch (IOException ex) {
            LOGGER.error("Error loading database " + fileToLoad, ex);
            result = ParserResult.getNullResult();
            JOptionPane.showMessageDialog(null, Localization.lang("Error opening file", new String[0]) + " '" + fileName + "'", Localization.lang("Error", new String[0]), 0);
        }
        if (result.getDatabase().isShared()) {
            try {
                new SharedDatabaseUIManager(this.frame).openSharedDatabaseFromParserResult(result);
            }
            catch (SQLException | DatabaseNotSupportedException | InvalidDBMSConnectionPropertiesException | NotASharedDatabaseException e) {
                result.getDatabaseContext().clearDatabaseFile();
                result.getDatabase().clearSharedDatabaseID();
                LOGGER.error("Connection error", e);
                JOptionPane.showMessageDialog(this.frame, e.getMessage() + "\n\n" + Localization.lang("A local copy will be opened.", new String[0]), Localization.lang("Connection error", new String[0]), 2);
            }
        }
        BasePanel panel = this.addNewDatabase(result, file, raisePanel);
        ParserResult finalReferenceToResult = result;
        SwingUtilities.invokeLater(() -> OpenDatabaseAction.performPostOpenActions(panel, finalReferenceToResult, true));
    }

    public static void performPostOpenActions(BasePanel panel, ParserResult result, boolean mustRaisePanel) {
        for (PostOpenAction action : POST_OPEN_ACTIONS) {
            if (!action.isActionNecessary(result)) continue;
            if (mustRaisePanel) {
                panel.frame().getTabbedPane().setSelectedComponent(panel);
            }
            action.performAction(panel, result);
        }
    }

    private BasePanel addNewDatabase(ParserResult result, File file, boolean raisePanel) {
        BibDatabase database = result.getDatabase();
        if (result.hasWarnings()) {
            JabRefExecutorService.INSTANCE.execute(() -> ParserResultWarningDialog.showParserResultWarningDialog(result, this.frame));
        }
        BasePanel basePanel = new BasePanel(this.frame, result.getDatabaseContext());
        SwingUtilities.invokeLater(() -> this.frame.addTab(basePanel, raisePanel));
        if (Objects.nonNull(file)) {
            this.frame.output(Localization.lang("Opened database", new String[0]) + " '" + file.getPath() + "' " + Localization.lang("with", new String[0]) + " " + database.getEntryCount() + " " + Localization.lang("entries", new String[0]) + ".");
        }
        return basePanel;
    }

    static {
        POST_OPEN_ACTIONS.add(new CheckForNewEntryTypesAction());
        POST_OPEN_ACTIONS.add(new ConvertLegacyExplicitGroups());
        POST_OPEN_ACTIONS.add(new FileLinksUpgradeWarning());
        POST_OPEN_ACTIONS.add(new HandleDuplicateWarnings());
    }
}

