/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.importer.actions.PostOpenAction;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.ExplicitGroup;
import net.sf.jabref.model.groups.GroupTreeNode;

public class ConvertLegacyExplicitGroups
implements PostOpenAction {
    @Override
    public boolean isActionNecessary(ParserResult pr) {
        if (pr.getMetaData().getGroups().isPresent()) {
            return !this.getExplicitGroupsWithLegacyKeys(pr.getMetaData().getGroups().orElse(null)).isEmpty();
        }
        return false;
    }

    @Override
    public void performAction(BasePanel panel, ParserResult pr) {
        Objects.requireNonNull(pr);
        if (!pr.getMetaData().getGroups().isPresent()) {
            return;
        }
        for (ExplicitGroup group : this.getExplicitGroupsWithLegacyKeys(pr.getMetaData().getGroups().get())) {
            for (String entryKey : group.getLegacyEntryKeys()) {
                for (BibEntry entry : pr.getDatabase().getEntriesByKey(entryKey)) {
                    group.add(entry);
                }
            }
            group.clearLegacyEntryKeys();
        }
    }

    private List<ExplicitGroup> getExplicitGroupsWithLegacyKeys(GroupTreeNode node) {
        ExplicitGroup group;
        Objects.requireNonNull(node);
        ArrayList<ExplicitGroup> findings = new ArrayList<ExplicitGroup>();
        if (node.getGroup() instanceof ExplicitGroup && !(group = (ExplicitGroup)node.getGroup()).getLegacyEntryKeys().isEmpty()) {
            findings.add(group);
        }
        node.getChildren().forEach(child -> findings.addAll(this.getExplicitGroupsWithLegacyKeys((GroupTreeNode)child)));
        return findings;
    }
}

