/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.gui.importer.ImportCustomizationDialog;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.logic.importer.fileformat.CustomImporter;
import net.sf.jabref.logic.l10n.Localization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ZipFileChooser
extends JDialog {
    private static final Log LOGGER = LogFactory.getLog(ZipFileChooser.class);

    public ZipFileChooser(ImportCustomizationDialog importCustomizationDialog, ZipFile zipFile) {
        super(importCustomizationDialog, Localization.lang("Select file from ZIP-archive", new String[0]), false);
        ZipFileChooserTableModel tableModel = new ZipFileChooserTableModel(zipFile, ZipFileChooser.getSelectableZipEntries(zipFile));
        JTable table = new JTable(tableModel);
        TableColumnModel cm = table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(200);
        cm.getColumn(1).setPreferredWidth(150);
        cm.getColumn(2).setPreferredWidth(100);
        JScrollPane sp = new JScrollPane(table, 20, 31);
        table.setSelectionMode(0);
        table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        if (table.getRowCount() > 0) {
            table.setRowSelectionInterval(0, 0);
        }
        GUIUtil.correctRowHeight(table);
        JButton cancelButton = new JButton(Localization.lang("Cancel", new String[0]));
        cancelButton.addActionListener(e -> this.dispose());
        JButton okButton = new JButton(Localization.lang("OK", new String[0]));
        okButton.addActionListener(e -> {
            int row = table.getSelectedRow();
            if (row == -1) {
                JOptionPane.showMessageDialog(this, Localization.lang("Please select an importer.", new String[0]));
            } else {
                ZipFileChooserTableModel model = (ZipFileChooserTableModel)table.getModel();
                ZipEntry tempZipEntry = model.getZipEntry(row);
                String className = tempZipEntry.getName().substring(0, tempZipEntry.getName().lastIndexOf(46)).replace("/", ".");
                try {
                    CustomImporter importer = new CustomImporter(model.getZipFile().getName(), className);
                    importCustomizationDialog.addOrReplaceImporter(importer);
                    this.dispose();
                }
                catch (ClassNotFoundException exc) {
                    LOGGER.warn("Could not instantiate importer: " + className, exc);
                    JOptionPane.showMessageDialog(this, Localization.lang("Could not instantiate %0 %1", className + ":\n", exc.getMessage()));
                }
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)sp, "Center");
        JPanel optionsPanel = new JPanel();
        optionsPanel.add(okButton);
        optionsPanel.add(cancelButton);
        optionsPanel.add(Box.createHorizontalStrut(5));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)optionsPanel, "South");
        this.setSize(this.getSize());
        this.pack();
        this.setLocationRelativeTo(importCustomizationDialog);
        table.requestFocus();
    }

    private static List<ZipEntry> getSelectableZipEntries(ZipFile zipFile) {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        for (ZipEntry zipEntry : Collections.list(e)) {
            if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class")) continue;
            entries.add(zipEntry);
        }
        return entries;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(400, 300);
    }

    private static class ZipFileChooserTableModel
    extends AbstractTableModel {
        private final List<String> columnNames = Arrays.asList(Localization.lang("Name", new String[0]), Localization.lang("Last modified", new String[0]), Localization.lang("Size", new String[0]));
        private final List<ZipEntry> rows;
        private final ZipFile zipFile;

        ZipFileChooserTableModel(ZipFile zipFile, List<ZipEntry> rows) {
            this.rows = rows;
            this.zipFile = zipFile;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames.get(col);
        }

        public ZipEntry getZipEntry(int rowIndex) {
            return this.rows.get(rowIndex);
        }

        public ZipFile getZipFile() {
            return this.zipFile;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = null;
            ZipEntry entry = this.getZipEntry(rowIndex);
            if (columnIndex == 0) {
                value = entry.getName();
            } else if (columnIndex == 1) {
                value = ZonedDateTime.ofInstant(new Date(entry.getTime()).toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
            } else if (columnIndex == 2) {
                value = entry.getSize();
            }
            return value;
        }
    }
}

