/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.gui.FindUnlinkedFilesDialog;
import net.sf.jabref.gui.importer.UnlinkedPDFFileFilter;
import net.sf.jabref.model.database.BibDatabaseContext;

public class UnlinkedFilesCrawler {
    private static final FileFilter DIRECTORY_FILTER = pathname -> pathname != null && pathname.isDirectory();
    private final BibDatabaseContext databaseContext;

    public UnlinkedFilesCrawler(BibDatabaseContext databaseContext) {
        this.databaseContext = databaseContext;
    }

    public FindUnlinkedFilesDialog.CheckableTreeNode searchDirectory(File directory, FileFilter filter) {
        UnlinkedPDFFileFilter ff = new UnlinkedPDFFileFilter(filter, this.databaseContext);
        return this.searchDirectory(directory, ff, new AtomicBoolean(true), null);
    }

    public FindUnlinkedFilesDialog.CheckableTreeNode searchDirectory(File directory, UnlinkedPDFFileFilter ff, AtomicBoolean state, ChangeListener changeListener) {
        if (state == null || !state.get()) {
            return null;
        }
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return null;
        }
        File[] filesArray = directory.listFiles(ff);
        List<Object> files = filesArray == null ? Collections.emptyList() : Arrays.asList(filesArray);
        FindUnlinkedFilesDialog.CheckableTreeNode root = new FindUnlinkedFilesDialog.CheckableTreeNode(null);
        int filesCount = 0;
        filesArray = directory.listFiles(DIRECTORY_FILTER);
        List<Object> subDirectories = filesArray == null ? Collections.emptyList() : Arrays.asList(filesArray);
        for (File file : subDirectories) {
            FindUnlinkedFilesDialog.CheckableTreeNode subRoot = this.searchDirectory(file, ff, state, changeListener);
            if (subRoot == null || subRoot.getChildCount() <= 0) continue;
            filesCount += ((FindUnlinkedFilesDialog.FileNodeWrapper)subRoot.getUserObject()).fileCount;
            root.add(subRoot);
        }
        root.setUserObject(new FindUnlinkedFilesDialog.FileNodeWrapper(directory, files.size() + filesCount));
        for (File file : files) {
            root.add(new FindUnlinkedFilesDialog.CheckableTreeNode(new FindUnlinkedFilesDialog.FileNodeWrapper(file)));
            if (changeListener == null) continue;
            changeListener.stateChanged(new ChangeEvent(this));
        }
        return root;
    }
}

