/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import java.awt.Dimension;
import java.util.List;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.l10n.Localization;

public class ParserResultWarningDialog {
    public static void showParserResultWarningDialog(ParserResult parserResult, JabRefFrame jabRefFrame) {
        Objects.requireNonNull(parserResult);
        Objects.requireNonNull(jabRefFrame);
        ParserResultWarningDialog.showParserResultWarningDialog(parserResult, jabRefFrame, -1);
    }

    public static void showParserResultWarningDialog(ParserResult parserResult, JabRefFrame jabRefFrame, int dataBaseNumber) {
        Objects.requireNonNull(parserResult);
        Objects.requireNonNull(jabRefFrame);
        if (!parserResult.hasWarnings()) {
            return;
        }
        if (dataBaseNumber >= 0) {
            jabRefFrame.showBasePanelAt(dataBaseNumber);
        }
        final List<String> warnings = parserResult.warnings();
        StringBuilder dialogContent = new StringBuilder();
        int warningCount = 1;
        for (String warning : warnings) {
            dialogContent.append(String.format("%d. %s%n", warningCount++, warning));
        }
        dialogContent.deleteCharAt(dialogContent.length() - 1);
        String dialogTitle = dataBaseNumber < 0 ? Localization.lang("Warnings", new String[0]) : Localization.lang("Warnings", new String[0]) + " (" + parserResult.getFile().get().getName() + ")";
        JTextArea textArea = new JTextArea(dialogContent.toString());
        JScrollPane scrollPane = new JScrollPane(textArea){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(800, Math.min(Math.max(100, warnings.size() * 15), 400));
            }
        };
        JOptionPane.showMessageDialog(jabRefFrame, scrollPane, dialogTitle, 2);
    }
}

