/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.EntryMarker;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.importer.ImportInspectionDialog;
import net.sf.jabref.gui.importer.ParserResultWarningDialog;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.importer.ImportFormatReader;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.importer.ParserResult;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.UpdateField;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.KeyCollisionException;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.BibtexString;

public class ImportMenuItem
extends JMenuItem
implements ActionListener {
    private final JabRefFrame frame;
    private final boolean openInNew;
    private final Importer importer;
    private IOException importError;

    public ImportMenuItem(JabRefFrame frame, boolean openInNew) {
        this(frame, openInNew, null);
    }

    public ImportMenuItem(JabRefFrame frame, boolean openInNew, Importer importer) {
        super(importer == null ? Localization.lang("Autodetect format", new String[0]) : importer.getName());
        this.importer = importer;
        this.frame = frame;
        this.openInNew = openInNew;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MyWorker worker = new MyWorker();
        worker.init();
        worker.getWorker().run();
        worker.getCallBack().update();
    }

    public void automatedImport(List<String> filenames) {
        MyWorker worker = new MyWorker();
        worker.fileOk = true;
        worker.filenames = filenames;
        worker.getWorker().run();
        worker.getCallBack().update();
    }

    private ParserResult mergeImportResults(List<ImportFormatReader.UnknownFormatImport> imports) {
        BibDatabase database = new BibDatabase();
        ParserResult directParserResult = null;
        boolean anythingUseful = false;
        for (ImportFormatReader.UnknownFormatImport importResult : imports) {
            ParserResult pr;
            if (importResult == null) continue;
            if ("BibTeX".equals(importResult.format)) {
                pr = importResult.parserResult;
                boolean bl = anythingUseful = anythingUseful || pr.getDatabase().hasEntries() || !pr.getDatabase().hasNoStrings();
                if (directParserResult == null) {
                    directParserResult = pr;
                }
                for (BibEntry entry : pr.getDatabase().getEntries()) {
                    database.insertEntry(entry);
                }
                for (BibtexString bs : pr.getDatabase().getStringValues()) {
                    try {
                        database.addString((BibtexString)bs.clone());
                    }
                    catch (KeyCollisionException keyCollisionException) {}
                }
                continue;
            }
            pr = importResult.parserResult;
            List<BibEntry> entries = pr.getDatabase().getEntries();
            anythingUseful |= !entries.isEmpty();
            UpdateField.setAutomaticFields(entries, Globals.prefs.getUpdateFieldPreferences());
            boolean markEntries = !this.openInNew && EntryMarker.shouldMarkEntries();
            for (BibEntry entry : entries) {
                if (markEntries) {
                    EntryMarker.markEntry(entry, 6, false, new NamedCompound(""));
                }
                database.insertEntry(entry);
            }
        }
        if (!anythingUseful) {
            return null;
        }
        if (imports.size() == 1 && directParserResult != null) {
            return directParserResult;
        }
        return new ParserResult(database);
    }

    class MyWorker
    extends AbstractWorker {
        private List<String> filenames;
        private ParserResult bibtexResult;
        private boolean fileOk;

        MyWorker() {
        }

        @Override
        public void init() {
            ImportMenuItem.this.importError = null;
            this.filenames = new FileDialog(ImportMenuItem.this.frame).updateWorkingDirPref().showDialogAndGetMultipleFiles();
            if (!this.filenames.isEmpty()) {
                ImportMenuItem.this.frame.block();
                ImportMenuItem.this.frame.output(Localization.lang("Starting import", new String[0]));
                this.fileOk = true;
                Globals.prefs.put("workingDirectory", Paths.get(this.filenames.get(0), new String[0]).getParent().toString());
            }
        }

        @Override
        public void run() {
            if (!this.fileOk) {
                return;
            }
            ArrayList<ImportFormatReader.UnknownFormatImport> imports = new ArrayList<ImportFormatReader.UnknownFormatImport>();
            for (String filename : this.filenames) {
                Path file = Paths.get(filename, new String[0]);
                try {
                    if (ImportMenuItem.this.importer == null) {
                        ImportMenuItem.this.frame.output(Localization.lang("Importing in unknown format", new String[0]) + "...");
                        imports.add(Globals.IMPORT_FORMAT_READER.importUnknownFormat(filename));
                        continue;
                    }
                    ImportMenuItem.this.frame.output(Localization.lang("Importing in %0 format", ImportMenuItem.this.importer.getName()) + "...");
                    ParserResult pr = ImportMenuItem.this.importer.importDatabase(file, Globals.prefs.getDefaultEncoding());
                    imports.add(new ImportFormatReader.UnknownFormatImport(ImportMenuItem.this.importer.getName(), pr));
                }
                catch (IOException e) {
                    ImportMenuItem.this.importError = e;
                }
            }
            this.bibtexResult = ImportMenuItem.this.mergeImportResults(imports);
            for (ImportFormatReader.UnknownFormatImport p : imports) {
                if (p == null) continue;
                ParserResult pr = p.parserResult;
                ParserResultWarningDialog.showParserResultWarningDialog(pr, ImportMenuItem.this.frame);
            }
        }

        @Override
        public void update() {
            if (!this.fileOk) {
                return;
            }
            if (this.bibtexResult == null) {
                if (ImportMenuItem.this.importer == null) {
                    ImportMenuItem.this.frame.output(Localization.lang("Could not find a suitable import format.", new String[0]));
                } else if (ImportMenuItem.this.importError == null) {
                    JOptionPane.showMessageDialog(ImportMenuItem.this.frame, Localization.lang("No entries found. Please make sure you are using the correct import filter.", new String[0]), Localization.lang("Import failed", new String[0]), 0);
                } else {
                    JOptionPane.showMessageDialog(ImportMenuItem.this.frame, ImportMenuItem.this.importError.getMessage(), Localization.lang("Import failed", new String[0]), 0);
                }
            } else if (ImportMenuItem.this.openInNew) {
                ImportMenuItem.this.frame.addTab(this.bibtexResult.getDatabaseContext(), true);
                ImportMenuItem.this.frame.output(Localization.lang("Imported entries", new String[0]) + ": " + this.bibtexResult.getDatabase().getEntryCount());
            } else {
                BasePanel panel = (BasePanel)ImportMenuItem.this.frame.getTabbedPane().getSelectedComponent();
                ImportInspectionDialog diag = new ImportInspectionDialog(ImportMenuItem.this.frame, panel, Localization.lang("Import", new String[0]), ImportMenuItem.this.openInNew);
                diag.addEntries(this.bibtexResult.getDatabase().getEntries());
                diag.entryListComplete();
                diag.setLocationRelativeTo(ImportMenuItem.this.frame);
                diag.setVisible(true);
                diag.toFront();
            }
            ImportMenuItem.this.frame.unblock();
        }
    }
}

