/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.DuplicateResolverDialog;
import net.sf.jabref.gui.EntryMarker;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.PreviewPanel;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.externalfiles.AutoSetLinks;
import net.sf.jabref.gui.externalfiles.DownloadExternalFile;
import net.sf.jabref.gui.externalfiletype.ExternalFileMenuItem;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListEntryEditor;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.groups.UndoableChangeEntriesOfGroup;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.renderer.GeneralRenderer;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.undo.UndoableInsertEntry;
import net.sf.jabref.gui.undo.UndoableRemoveEntry;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.gui.util.comparator.IconComparator;
import net.sf.jabref.gui.util.component.CheckBoxMessage;
import net.sf.jabref.logic.bibtex.comparator.FieldComparator;
import net.sf.jabref.logic.bibtexkeypattern.BibtexKeyPatternUtil;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.importer.ImportInspector;
import net.sf.jabref.logic.importer.OutputPrinter;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.UpdateField;
import net.sf.jabref.model.Defaults;
import net.sf.jabref.model.DuplicateCheck;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.database.BibDatabaseContext;
import net.sf.jabref.model.database.BibDatabaseMode;
import net.sf.jabref.model.entry.AuthorList;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.FieldProperty;
import net.sf.jabref.model.entry.IdGenerator;
import net.sf.jabref.model.entry.InternalBibtexFields;
import net.sf.jabref.model.groups.AllEntriesGroup;
import net.sf.jabref.model.groups.EntriesGroupChange;
import net.sf.jabref.model.groups.GroupTreeNode;
import net.sf.jabref.model.metadata.MetaData;
import net.sf.jabref.model.strings.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportInspectionDialog
extends JDialog
implements ImportInspector,
OutputPrinter {
    private static final Log LOGGER = LogFactory.getLog(ImportInspectionDialog.class);
    private BasePanel panel;
    private final JabRefFrame frame;
    private final BibDatabaseContext bibDatabaseContext;
    private final JSplitPane contentPane = new JSplitPane(0);
    private final JTable glTable;
    private final TableComparatorChooser<BibEntry> comparatorChooser;
    private final DefaultEventSelectionModel<BibEntry> selectionModel;
    private final JProgressBar progressBar = new JProgressBar(0);
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final JButton generate = new JButton(Localization.lang("Generate now", new String[0]));
    private final EventList<BibEntry> entries = new BasicEventList<BibEntry>();
    private final SortedList<BibEntry> sortedList;
    private final List<BibEntry> entriesToDelete = new ArrayList<BibEntry>();
    private final String undoName;
    private final List<CallBack> callBacks = new ArrayList<CallBack>();
    private final boolean newDatabase;
    private final JPopupMenu popup = new JPopupMenu();
    private final JButton deselectAllDuplicates = new JButton(Localization.lang("Deselect all duplicates", new String[0]));
    private final JButton stop = new JButton(Localization.lang("Stop", new String[0]));
    private final PreviewPanel preview;
    private boolean generatedKeys;
    private boolean defaultSelected = true;
    private final Rectangle toRect = new Rectangle(0, 0, 1, 1);
    private final Map<BibEntry, Set<GroupTreeNode>> groupAdditions = new HashMap<BibEntry, Set<GroupTreeNode>>();
    private final JCheckBox autoGenerate = new JCheckBox(Localization.lang("Generate keys", new String[0]), Globals.prefs.getBoolean("generateKeysAfterInspection"));
    private final JLabel duplLabel = new JLabel(IconTheme.JabRefIcon.DUPLICATE.getSmallIcon());
    private final JLabel fileLabel = new JLabel(IconTheme.JabRefIcon.FILE.getSmallIcon());
    private final JLabel urlLabel = new JLabel(IconTheme.JabRefIcon.WWW.getSmallIcon());
    private static final List<String> INSPECTION_FIELDS = Arrays.asList("author", "title", "year", "bibtexkey");
    private static final int DUPL_COL = 1;
    private static final int FILE_COL = 2;
    private static final int URL_COL = 3;
    private static final int PAD = 4;

    public ImportInspectionDialog(JabRefFrame frame, BasePanel panel, String undoName, boolean newDatabase) {
        super(frame);
        this.frame = frame;
        this.panel = panel;
        this.bibDatabaseContext = panel == null ? null : panel.getBibDatabaseContext();
        this.undoName = undoName;
        this.newDatabase = newDatabase;
        this.setIconImage(new ImageIcon(IconTheme.getIconUrl("jabrefIcon48")).getImage());
        this.preview = new PreviewPanel(panel, this.bibDatabaseContext);
        this.duplLabel.setToolTipText(Localization.lang("Possible duplicate of existing entry. Click to resolve.", new String[0]));
        this.sortedList = new SortedList<BibEntry>(this.entries);
        DefaultEventTableModel tableModelGl = (DefaultEventTableModel)GlazedListsSwing.eventTableModelWithThreadProxyList(this.sortedList, new EntryTableFormat());
        this.glTable = new EntryTable(tableModelGl);
        GeneralRenderer renderer = new GeneralRenderer(Color.white);
        this.glTable.setDefaultRenderer(JLabel.class, renderer);
        this.glTable.setDefaultRenderer(String.class, renderer);
        this.glTable.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.DELETE_ENTRY), "delete");
        DeleteListener deleteListener = new DeleteListener();
        this.glTable.getActionMap().put("delete", deleteListener);
        this.selectionModel = (DefaultEventSelectionModel)GlazedListsSwing.eventSelectionModelWithThreadProxyList(this.sortedList);
        this.glTable.setSelectionModel(this.selectionModel);
        this.selectionModel.getSelected().addListEventListener(new EntrySelectionListener());
        this.comparatorChooser = TableComparatorChooser.install(this.glTable, this.sortedList, AbstractTableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.setupComparatorChooser();
        this.glTable.addMouseListener(new TableClickListener());
        GUIUtil.correctRowHeight(this.glTable);
        this.setWidths();
        this.getContentPane().setLayout(new BorderLayout());
        this.progressBar.setIndeterminate(true);
        JPanel centerPan = new JPanel();
        centerPan.setLayout(new BorderLayout());
        this.contentPane.setTopComponent(new JScrollPane(this.glTable));
        this.contentPane.setBottomComponent(this.preview);
        centerPan.add((Component)this.contentPane, "Center");
        centerPan.add((Component)this.progressBar, "South");
        this.popup.add(deleteListener);
        this.popup.addSeparator();
        if (!newDatabase && this.bibDatabaseContext != null) {
            GroupTreeNode node = this.bibDatabaseContext.getMetaData().getGroups().get();
            JMenu groupsAdd = new JMenu(Localization.lang("Add to group", new String[0]));
            groupsAdd.setEnabled(false);
            this.insertNodes(groupsAdd, node);
            this.popup.add(groupsAdd);
        }
        this.popup.add(new LinkLocalFile());
        this.popup.add(new DownloadFile());
        this.popup.add(new InternalAutoSetLinks());
        this.popup.add(new AttachUrl());
        this.getContentPane().add((Component)centerPan, "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.stop);
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        bb.addButton((JComponent)cancel);
        bb.addRelatedGap();
        JButton help = new HelpAction(HelpFile.IMPORT_INSPECTION).getHelpButton();
        bb.addButton((JComponent)help);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonStackBuilder builder = new ButtonStackBuilder();
        JButton selectAll = new JButton(Localization.lang("Select all", new String[0]));
        builder.addButton((JComponent)selectAll);
        JButton deselectAll = new JButton(Localization.lang("Deselect all", new String[0]));
        builder.addButton((JComponent)deselectAll);
        builder.addButton((JComponent)this.deselectAllDuplicates);
        builder.addRelatedGap();
        JButton delete = new JButton(Localization.lang("Delete", new String[0]));
        builder.addButton((JComponent)delete);
        builder.addRelatedGap();
        builder.addFixed(this.autoGenerate);
        builder.addButton((JComponent)this.generate);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        centerPan.add((Component)builder.getPanel(), "West");
        this.ok.setEnabled(false);
        this.generate.setEnabled(false);
        this.ok.addActionListener(new OkListener());
        cancel.addActionListener(e -> {
            this.signalStopFetching();
            this.dispose();
            frame.output(Localization.lang("Import canceled by user", new String[0]));
        });
        this.generate.addActionListener(e -> {
            this.generate.setEnabled(false);
            this.generatedKeys = true;
            this.generateKeys();
        });
        this.stop.addActionListener(e -> {
            this.signalStopFetching();
            this.entryListComplete();
        });
        selectAll.addActionListener(new SelectionButton(true));
        deselectAll.addActionListener(new SelectionButton(false));
        this.deselectAllDuplicates.addActionListener(e -> {
            for (int i = 0; i < this.glTable.getRowCount(); ++i) {
                if (this.glTable.getValueAt(i, 1) == null) continue;
                this.glTable.setValueAt(false, i, 0);
            }
            this.glTable.repaint();
        });
        this.deselectAllDuplicates.setEnabled(false);
        delete.addActionListener(deleteListener);
        this.getContentPane().add((Component)bb.getPanel(), "South");
        this.setSize(new Dimension(Globals.prefs.getInt("importInspectionDialogWidth"), Globals.prefs.getInt("importInspectionDialogHeight")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ImportInspectionDialog.this.contentPane.setDividerLocation(0.5);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                Globals.prefs.putInt("importInspectionDialogWidth", ImportInspectionDialog.this.getSize().width);
                Globals.prefs.putInt("importInspectionDialogHeight", ImportInspectionDialog.this.getSize().height);
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportInspectionDialog.this.dispose();
            }
        };
        ActionMap am = this.contentPane.getActionMap();
        InputMap im = this.contentPane.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", closeAction);
    }

    @Override
    public void setProgress(int current, int max) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(max);
            this.progressBar.setValue(current);
        });
    }

    @Override
    public void addEntry(BibEntry entry) {
        ArrayList<BibEntry> list = new ArrayList<BibEntry>();
        list.add(entry);
        this.addEntries(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntries(Collection<BibEntry> entriesToAdd) {
        for (BibEntry entry : entriesToAdd) {
            entry.setSearchHit(this.defaultSelected);
            if (this.panel != null && (DuplicateCheck.containsDuplicate(this.panel.getDatabase(), entry, this.panel.getBibDatabaseContext().getMode()).isPresent() || this.internalDuplicate(this.entries, entry).isPresent())) {
                entry.setGroupHit(true);
                SwingUtilities.invokeLater(() -> this.deselectAllDuplicates.setEnabled(true));
            }
            this.entries.getReadWriteLock().writeLock().lock();
            try {
                this.entries.add(entry);
            }
            finally {
                this.entries.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    private Optional<BibEntry> internalDuplicate(Collection<BibEntry> entriesDupe, BibEntry entry) {
        for (BibEntry othEntry : entriesDupe) {
            if (othEntry.equals(entry) || !DuplicateCheck.isDuplicate(entry, othEntry, this.panel.getBibDatabaseContext().getMode())) continue;
            return Optional.of(othEntry);
        }
        return Optional.empty();
    }

    public void entryListComplete() {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setVisible(false);
            this.ok.setEnabled(true);
            if (!this.generatedKeys) {
                this.generate.setEnabled(true);
            }
            this.stop.setEnabled(false);
            this.glTable.repaint();
            if (this.glTable.getSelectedRowCount() == 0 && this.glTable.getRowCount() > 0) {
                this.glTable.setRowSelectionInterval(0, 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateKeyForEntry(BibEntry entry) {
        this.entries.getReadWriteLock().writeLock().lock();
        try {
            MetaData localMetaData;
            BibDatabase database;
            if (this.panel == null) {
                database = new BibDatabase();
                localMetaData = new MetaData();
            } else {
                database = this.panel.getDatabase();
                localMetaData = this.panel.getBibDatabaseContext().getMetaData();
            }
            entry.setId(IdGenerator.next());
            database.insertEntry(entry);
            BibtexKeyPatternUtil.makeLabel(localMetaData.getCiteKeyPattern(Globals.prefs.getBibtexKeyPatternPreferences().getKeyPattern()), database, entry, Globals.prefs.getBibtexKeyPatternPreferences());
            database.removeEntry(entry);
        }
        finally {
            this.entries.getReadWriteLock().writeLock().unlock();
        }
        this.glTable.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateKeys() {
        this.entries.getReadWriteLock().writeLock().lock();
        try {
            MetaData localMetaData;
            BibDatabase database;
            if (this.panel == null) {
                database = new BibDatabase();
                localMetaData = new MetaData();
            } else {
                database = this.panel.getDatabase();
                localMetaData = this.panel.getBibDatabaseContext().getMetaData();
            }
            ArrayList<Optional<String>> keys = new ArrayList<Optional<String>>(this.entries.size());
            for (BibEntry entry : this.entries) {
                entry.setId(IdGenerator.next());
                database.insertEntry(entry);
                BibtexKeyPatternUtil.makeLabel(localMetaData.getCiteKeyPattern(Globals.prefs.getBibtexKeyPatternPreferences().getKeyPattern()), database, entry, Globals.prefs.getBibtexKeyPatternPreferences());
                keys.add(entry.getCiteKeyOptional());
            }
            this.preview.update();
            this.preview.repaint();
            for (BibEntry entry : this.entries) {
                database.removeEntry(entry);
            }
        }
        finally {
            this.entries.getReadWriteLock().writeLock().unlock();
        }
        this.glTable.repaint();
    }

    private void insertNodes(JMenu menu, GroupTreeNode node) {
        AbstractAction action = this.getAction(node);
        if (node.getNumberOfChildren() == 0) {
            menu.add(action);
            if (action.isEnabled()) {
                menu.setEnabled(true);
            }
            return;
        }
        if (node.getGroup() instanceof AllEntriesGroup) {
            for (GroupTreeNode child : node.getChildren()) {
                this.insertNodes(menu, child);
            }
        } else {
            JMenu submenu = new JMenu('[' + node.getName() + ']');
            submenu.setEnabled(action.isEnabled());
            submenu.add(action);
            submenu.add(new JPopupMenu.Separator());
            for (GroupTreeNode child : node.getChildren()) {
                this.insertNodes(submenu, child);
            }
            menu.add(submenu);
            if (submenu.isEnabled()) {
                menu.setEnabled(true);
            }
        }
    }

    private AbstractAction getAction(GroupTreeNode node) {
        AddToGroupAction action = new AddToGroupAction(node);
        action.setEnabled(node.supportsAddingEntries());
        return action;
    }

    public void addCallBack(CallBack cb) {
        this.callBacks.add(cb);
    }

    private void signalStopFetching() {
        this.callBacks.forEach(CallBack::stopFetching);
    }

    private void setWidths() {
        int i;
        TableColumnModel cm = this.glTable.getColumnModel();
        cm.getColumn(0).setPreferredWidth(55);
        cm.getColumn(0).setMinWidth(55);
        cm.getColumn(0).setMaxWidth(55);
        for (i = 1; i < 4; ++i) {
            cm.getColumn(i).setPreferredWidth(26);
            cm.getColumn(i).setMinWidth(26);
            cm.getColumn(i).setMaxWidth(26);
        }
        for (i = 0; i < INSPECTION_FIELDS.size(); ++i) {
            int width = InternalBibtexFields.getFieldLength(INSPECTION_FIELDS.get(i));
            this.glTable.getColumnModel().getColumn(i + 4).setPreferredWidth(width);
        }
    }

    private void setupComparatorChooser() {
        int i;
        List<Comparator> comparators = this.comparatorChooser.getComparatorsForColumn(0);
        comparators.clear();
        comparators = this.comparatorChooser.getComparatorsForColumn(1);
        comparators.clear();
        for (i = 2; i < 4; ++i) {
            comparators = this.comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            if (i == 2) {
                comparators.add(new IconComparator(Collections.singletonList("file")));
                continue;
            }
            if (i != 3) continue;
            comparators.add(new IconComparator(Collections.singletonList("url")));
        }
        for (i = 4; i < 4 + INSPECTION_FIELDS.size(); ++i) {
            comparators = this.comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            comparators.add(new FieldComparator(INSPECTION_FIELDS.get(i - 4)));
        }
        this.sortedList.getReadWriteLock().writeLock().lock();
        try {
            this.comparatorChooser.appendComparator(4, 0, false);
        }
        finally {
            this.sortedList.getReadWriteLock().writeLock().unlock();
        }
    }

    public void setDefaultSelected(boolean defaultSelected) {
        this.defaultSelected = defaultSelected;
    }

    @Override
    public void setStatus(String s) {
        this.frame.setStatus(s);
    }

    @Override
    public void showMessage(String message, String title, int msgType) {
        JOptionPane.showMessageDialog(this, message, title, msgType);
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public void showErrorMessage(String fetcherTitle, String localizedException) {
        this.showMessage(Localization.lang("Error while fetching from %0", fetcherTitle) + "\n" + Localization.lang("Please try again later and/or check your network connection.", new String[0]) + "\n" + localizedException, Localization.lang("Search %0", fetcherTitle), 0);
    }

    public JabRefFrame getFrame() {
        return this.frame;
    }

    private class EntryTableFormat
    implements TableFormat<BibEntry> {
        private EntryTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 4 + INSPECTION_FIELDS.size();
        }

        @Override
        public String getColumnName(int i) {
            if (i == 0) {
                return Localization.lang("Keep", new String[0]);
            }
            if (i >= 4) {
                return StringUtil.capitalizeFirst((String)INSPECTION_FIELDS.get(i - 4));
            }
            return "";
        }

        @Override
        public Object getColumnValue(BibEntry entry, int i) {
            if (i == 0) {
                return entry.isSearchHit() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (i < 4) {
                switch (i) {
                    case 1: {
                        return entry.isGroupHit() ? ImportInspectionDialog.this.duplLabel : null;
                    }
                    case 2: {
                        if (entry.hasField("file")) {
                            FileListTableModel model = new FileListTableModel();
                            entry.getField("file").ifPresent(model::setContent);
                            ImportInspectionDialog.this.fileLabel.setToolTipText(model.getToolTipHTMLRepresentation());
                            if (model.getRowCount() > 0 && model.getEntry((int)0).type.isPresent()) {
                                ImportInspectionDialog.this.fileLabel.setIcon(model.getEntry((int)0).type.get().getIcon());
                            }
                            return ImportInspectionDialog.this.fileLabel;
                        }
                        return null;
                    }
                    case 3: {
                        if (entry.hasField("url")) {
                            ImportInspectionDialog.this.urlLabel.setToolTipText(entry.getField("url").orElse(""));
                            return ImportInspectionDialog.this.urlLabel;
                        }
                        return null;
                    }
                }
                return null;
            }
            String field = (String)INSPECTION_FIELDS.get(i - 4);
            if (InternalBibtexFields.getFieldProperties(field).contains((Object)FieldProperty.PERSON_NAMES)) {
                return entry.getField(field).map(AuthorList::fixAuthorNatbib).orElse("");
            }
            return entry.getField(field).orElse(null);
        }
    }

    class EntryTable
    extends JTable {
        private final GeneralRenderer renderer;

        public EntryTable(TableModel model) {
            super(model);
            this.renderer = new GeneralRenderer(Color.white);
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return column == 0 ? this.getDefaultRenderer(Boolean.class) : this.renderer;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            if (col < 4) {
                return JLabel.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object value, int row, int column) {
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            try {
                BibEntry entry = (BibEntry)ImportInspectionDialog.this.sortedList.get(row);
                entry.setSearchHit((Boolean)value);
            }
            finally {
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    @FunctionalInterface
    public static interface CallBack {
        public void stopFetching();
    }

    private class LinkLocalFile
    extends JMenuItem
    implements ActionListener,
    DownloadExternalFile.DownloadCallback {
        private BibEntry entry;

        public LinkLocalFile() {
            super(Localization.lang("Link local file", new String[0]));
            this.addActionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            this.entry = (BibEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            FileListEntry flEntry = new FileListEntry("", "");
            FileListEntryEditor editor = new FileListEntryEditor(ImportInspectionDialog.this.frame, flEntry, false, true, ImportInspectionDialog.this.bibDatabaseContext);
            editor.setVisible(true, true);
            if (editor.okPressed()) {
                FileListTableModel localModel = new FileListTableModel();
                this.entry.getField("file").ifPresent(localModel::setContent);
                localModel.addEntry(localModel.getRowCount(), flEntry);
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                try {
                    this.entry.setField("file", localModel.getStringRepresentation());
                }
                finally {
                    ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                }
                ImportInspectionDialog.this.glTable.repaint();
            }
        }

        @Override
        public void downloadComplete(FileListEntry file) {
            ImportInspectionDialog.this.toFront();
            FileListTableModel localModel = new FileListTableModel();
            this.entry.getField("file").ifPresent(localModel::setContent);
            localModel.addEntry(localModel.getRowCount(), file);
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            try {
                this.entry.setField("file", localModel.getStringRepresentation());
            }
            finally {
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    private class InternalAutoSetLinks
    extends JMenuItem
    implements ActionListener {
        public InternalAutoSetLinks() {
            super(Localization.lang("Automatically set file links", new String[0]));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            BibEntry entry = (BibEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            if (!entry.hasCiteKey()) {
                int answer = JOptionPane.showConfirmDialog(ImportInspectionDialog.this.frame, Localization.lang("This entry has no BibTeX key. Generate key now?", new String[0]), Localization.lang("Download file", new String[0]), 2, 3);
                if (answer == 0) {
                    ImportInspectionDialog.this.generateKeyForEntry(entry);
                } else {
                    return;
                }
            }
            FileListTableModel localModel = new FileListTableModel();
            entry.getField("file").ifPresent(localModel::setContent);
            JDialog diag = new JDialog((Dialog)ImportInspectionDialog.this, true);
            JabRefExecutorService.INSTANCE.execute(AutoSetLinks.autoSetLinks(entry, localModel, ImportInspectionDialog.this.bibDatabaseContext, e -> {
                if (e.getID() > 0) {
                    ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                    try {
                        entry.setField("file", localModel.getStringRepresentation());
                    }
                    finally {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                    }
                    ImportInspectionDialog.this.glTable.repaint();
                }
            }, diag));
        }
    }

    class DownloadFile
    extends JMenuItem
    implements ActionListener,
    DownloadExternalFile.DownloadCallback {
        private BibEntry entry;

        public DownloadFile() {
            super(Localization.lang("Download file", new String[0]));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int answer;
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            this.entry = (BibEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            if (!this.entry.getCiteKeyOptional().isPresent() && (answer = JOptionPane.showConfirmDialog(ImportInspectionDialog.this.frame, Localization.lang("This entry has no BibTeX key. Generate key now?", new String[0]), Localization.lang("Download file", new String[0]), 2, 3)) == 0) {
                ImportInspectionDialog.this.generateKeyForEntry(this.entry);
            }
            DownloadExternalFile def = new DownloadExternalFile(ImportInspectionDialog.this.frame, ImportInspectionDialog.this.bibDatabaseContext, this.entry);
            try {
                def.download(this);
            }
            catch (IOException ex) {
                LOGGER.warn("Could not download file", ex);
            }
        }

        @Override
        public void downloadComplete(FileListEntry file) {
            ImportInspectionDialog.this.toFront();
            FileListTableModel localModel = new FileListTableModel();
            this.entry.getField("file").ifPresent(localModel::setContent);
            localModel.addEntry(localModel.getRowCount(), file);
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            try {
                this.entry.setField("file", localModel.getStringRepresentation());
            }
            finally {
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    class AttachUrl
    extends JMenuItem
    implements ActionListener {
        public AttachUrl() {
            super(Localization.lang("Attach URL", new String[0]));
            this.addActionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            if (ImportInspectionDialog.this.selectionModel.getSelected().size() != 1) {
                return;
            }
            BibEntry entry = (BibEntry)ImportInspectionDialog.this.selectionModel.getSelected().get(0);
            String result = JOptionPane.showInputDialog(ImportInspectionDialog.this, Localization.lang("Enter URL", new String[0]), entry.getField("url").orElse(""));
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            try {
                if (result != null) {
                    if (result.isEmpty()) {
                        entry.clearField("url");
                    } else {
                        entry.setField("url", result);
                    }
                }
            }
            finally {
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    private class TableClickListener
    implements MouseListener {
        private TableClickListener() {
        }

        private boolean isIconColumn(int col) {
            return col == 2 || col == 3;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int col = ImportInspectionDialog.this.glTable.columnAtPoint(e.getPoint());
            int row = ImportInspectionDialog.this.glTable.rowAtPoint(e.getPoint());
            if (this.isIconColumn(col)) {
                BibEntry entry = (BibEntry)ImportInspectionDialog.this.sortedList.get(row);
                if (col == 2) {
                    if (entry.hasField("file")) {
                        FileListTableModel tableModel = new FileListTableModel();
                        entry.getField("file").ifPresent(tableModel::setContent);
                        if (tableModel.getRowCount() == 0) {
                            return;
                        }
                        FileListEntry fl = tableModel.getEntry(0);
                        new ExternalFileMenuItem(ImportInspectionDialog.this.frame, entry, "", fl.link, null, ImportInspectionDialog.this.panel.getBibDatabaseContext(), fl.type).actionPerformed(null);
                    }
                } else {
                    this.openExternalLink("url", e);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private void showPopup(MouseEvent e) {
            int col = ImportInspectionDialog.this.glTable.columnAtPoint(e.getPoint());
            if (col == 2) {
                this.showFileFieldMenu(e);
            } else {
                this.showOrdinaryRightClickMenu(e);
            }
        }

        private void showOrdinaryRightClickMenu(MouseEvent e) {
            ImportInspectionDialog.this.popup.show(ImportInspectionDialog.this.glTable, e.getX(), e.getY());
        }

        private void showFileFieldMenu(MouseEvent e) {
            int row = ImportInspectionDialog.this.glTable.rowAtPoint(e.getPoint());
            BibEntry entry = (BibEntry)ImportInspectionDialog.this.sortedList.get(row);
            JPopupMenu menu = new JPopupMenu();
            int count = 0;
            FileListTableModel fileList = new FileListTableModel();
            entry.getField("file").ifPresent(fileList::setContent);
            for (int i = 0; i < fileList.getRowCount(); ++i) {
                FileListEntry flEntry = fileList.getEntry(i);
                String description = flEntry.description;
                if (description == null || description.trim().isEmpty()) {
                    description = flEntry.link;
                }
                menu.add(new ExternalFileMenuItem(ImportInspectionDialog.this.panel.frame(), entry, description, flEntry.link, flEntry.type.get().getIcon(), ImportInspectionDialog.this.panel.getBibDatabaseContext(), flEntry.type));
                ++count;
            }
            if (count == 0) {
                this.showOrdinaryRightClickMenu(e);
            } else {
                menu.show(ImportInspectionDialog.this.glTable, e.getX(), e.getY());
            }
        }

        private void openExternalLink(String fieldName, MouseEvent e) {
            int row = ImportInspectionDialog.this.glTable.rowAtPoint(e.getPoint());
            BibEntry entry = (BibEntry)ImportInspectionDialog.this.sortedList.get(row);
            entry.getField(fieldName).ifPresent(link -> {
                try {
                    JabRefDesktop.openExternalViewer(ImportInspectionDialog.this.panel.getBibDatabaseContext(), link, fieldName);
                }
                catch (IOException ex) {
                    LOGGER.warn("Could not open link", ex);
                }
            });
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
                return;
            }
            int col = ImportInspectionDialog.this.glTable.columnAtPoint(e.getPoint());
            int row = ImportInspectionDialog.this.glTable.rowAtPoint(e.getPoint());
            if (col == 1 && ImportInspectionDialog.this.glTable.getValueAt(row, col) != null) {
                DuplicateResolverDialog diag;
                BibEntry first = (BibEntry)ImportInspectionDialog.this.sortedList.get(row);
                Optional other = DuplicateCheck.containsDuplicate(ImportInspectionDialog.this.panel.getDatabase(), first, ImportInspectionDialog.this.panel.getBibDatabaseContext().getMode());
                if (other.isPresent()) {
                    diag = new DuplicateResolverDialog(ImportInspectionDialog.this, other.get(), first, DuplicateResolverDialog.DuplicateResolverType.INSPECTION);
                    diag.setLocationRelativeTo(ImportInspectionDialog.this);
                    diag.setVisible(true);
                    ImportInspectionDialog.this.toFront();
                    if (diag.getSelected() == DuplicateResolverDialog.DuplicateResolverResult.KEEP_LEFT) {
                        ImportInspectionDialog.this.entriesToDelete.add((BibEntry)other.get());
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        try {
                            first.setGroupHit(false);
                        }
                        finally {
                            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                        }
                    }
                    if (diag.getSelected() == DuplicateResolverDialog.DuplicateResolverResult.KEEP_RIGHT) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        try {
                            ImportInspectionDialog.this.entries.remove(first);
                        }
                        finally {
                            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                        }
                    }
                    if (diag.getSelected() == DuplicateResolverDialog.DuplicateResolverResult.KEEP_BOTH) {
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        try {
                            first.setGroupHit(false);
                        }
                        finally {
                            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                        }
                    }
                    if (diag.getSelected() == DuplicateResolverDialog.DuplicateResolverResult.KEEP_MERGE) {
                        ImportInspectionDialog.this.entriesToDelete.add((BibEntry)other.get());
                        ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
                        try {
                            diag.getMergedEntry().setGroupHit(false);
                            diag.getMergedEntry().setSearchHit(true);
                            ImportInspectionDialog.this.entries.add(diag.getMergedEntry());
                            ImportInspectionDialog.this.entries.remove(first);
                            first = new BibEntry();
                        }
                        finally {
                            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
                        }
                    }
                }
                if ((other = ImportInspectionDialog.this.internalDuplicate(ImportInspectionDialog.this.entries, first)).isPresent()) {
                    diag = new DuplicateResolverDialog(ImportInspectionDialog.this, first, (BibEntry)other.get(), DuplicateResolverDialog.DuplicateResolverType.DUPLICATE_SEARCH);
                    diag.setLocationRelativeTo(ImportInspectionDialog.this);
                    diag.setVisible(true);
                    ImportInspectionDialog.this.toFront();
                    DuplicateResolverDialog.DuplicateResolverResult answer = diag.getSelected();
                    if (answer == DuplicateResolverDialog.DuplicateResolverResult.KEEP_LEFT) {
                        ImportInspectionDialog.this.entries.remove(other.get());
                        first.setGroupHit(false);
                    } else if (answer == DuplicateResolverDialog.DuplicateResolverResult.KEEP_RIGHT) {
                        ImportInspectionDialog.this.entries.remove(first);
                    } else if (answer == DuplicateResolverDialog.DuplicateResolverResult.KEEP_BOTH) {
                        first.setGroupHit(false);
                    } else if (answer == DuplicateResolverDialog.DuplicateResolverResult.KEEP_MERGE) {
                        diag.getMergedEntry().setGroupHit(false);
                        diag.getMergedEntry().setSearchHit(true);
                        ImportInspectionDialog.this.entries.add(diag.getMergedEntry());
                        ImportInspectionDialog.this.entries.remove(first);
                        ImportInspectionDialog.this.entries.remove(other.get());
                    }
                }
            }
        }
    }

    private class EntrySelectionListener
    implements ListEventListener<BibEntry> {
        private EntrySelectionListener() {
        }

        @Override
        public void listChanged(ListEvent<BibEntry> listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                ImportInspectionDialog.this.preview.setEntry((BibEntry)listEvent.getSourceList().get(0));
                ImportInspectionDialog.this.contentPane.setDividerLocation(0.5);
                SwingUtilities.invokeLater(() -> ImportInspectionDialog.this.preview.scrollRectToVisible(ImportInspectionDialog.this.toRect));
            }
        }
    }

    private class SelectionButton
    implements ActionListener {
        private final Boolean enable;

        public SelectionButton(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            for (int i = 0; i < ImportInspectionDialog.this.glTable.getRowCount(); ++i) {
                ImportInspectionDialog.this.glTable.setValueAt(this.enable, i, 0);
            }
            ImportInspectionDialog.this.glTable.repaint();
        }
    }

    private class DeleteListener
    extends AbstractAction {
        public DeleteListener() {
            super(Localization.lang("Delete", new String[0]), IconTheme.JabRefIcon.DELETE_ENTRY.getSmallIcon());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.removeSelectedEntries();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeSelectedEntries() {
            int row = ImportInspectionDialog.this.glTable.getSelectedRow();
            ArrayList toRemove = new ArrayList();
            toRemove.addAll(ImportInspectionDialog.this.selectionModel.getSelected());
            ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().lock();
            try {
                for (BibEntry entry : toRemove) {
                    ImportInspectionDialog.this.entries.remove(entry);
                }
            }
            finally {
                ImportInspectionDialog.this.entries.getReadWriteLock().writeLock().unlock();
            }
            ImportInspectionDialog.this.glTable.clearSelection();
            if (row >= 0 && !ImportInspectionDialog.this.entries.isEmpty()) {
                row = Math.min(ImportInspectionDialog.this.entries.size() - 1, row);
                ImportInspectionDialog.this.glTable.addRowSelectionInterval(row, row);
            }
        }
    }

    private class OkListener
    implements ActionListener {
        private OkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Globals.prefs.getBoolean("warnAboutDuplicatesInInspection")) {
                for (BibEntry entry : ImportInspectionDialog.this.entries) {
                    if (!entry.isSearchHit() || !entry.isGroupHit()) continue;
                    CheckBoxMessage cbm = new CheckBoxMessage(Localization.lang("There are possible duplicates (marked with an icon) that haven't been resolved. Continue?", new String[0]), Localization.lang("Disable this confirmation dialog", new String[0]), false);
                    int answer = JOptionPane.showConfirmDialog(ImportInspectionDialog.this, cbm, Localization.lang("Duplicates found", new String[0]), 0);
                    if (cbm.isSelected()) {
                        Globals.prefs.putBoolean("warnAboutDuplicatesInInspection", false);
                    }
                    if (answer != 1) break;
                    return;
                }
            }
            NamedCompound ce = new NamedCompound(ImportInspectionDialog.this.undoName);
            if (!ImportInspectionDialog.this.entriesToDelete.isEmpty()) {
                this.removeEntriesToDelete(ce);
            }
            if (ImportInspectionDialog.this.autoGenerate.isSelected() && !ImportInspectionDialog.this.generatedKeys) {
                ImportInspectionDialog.this.generateKeys();
            }
            Globals.prefs.putBoolean("generateKeysAfterInspection", ImportInspectionDialog.this.autoGenerate.isSelected());
            List<BibEntry> selected = this.getSelectedEntries();
            if (!selected.isEmpty()) {
                this.addSelectedEntries(ce, selected);
            }
            ImportInspectionDialog.this.dispose();
            SwingUtilities.invokeLater(() -> this.updateGUI(selected.size()));
        }

        private void updateGUI(int entryCount) {
            if (ImportInspectionDialog.this.newDatabase) {
                ImportInspectionDialog.this.frame.addTab(ImportInspectionDialog.this.panel, true);
            }
            ImportInspectionDialog.this.panel.markBaseChanged();
            if (entryCount == 0) {
                ImportInspectionDialog.this.frame.output(Localization.lang("No entries imported.", new String[0]));
            } else {
                ImportInspectionDialog.this.frame.output(Localization.lang("Number of entries successfully imported", new String[0]) + ": " + entryCount);
            }
        }

        private void removeEntriesToDelete(NamedCompound ce) {
            for (BibEntry entry : ImportInspectionDialog.this.entriesToDelete) {
                ce.addEdit(new UndoableRemoveEntry(ImportInspectionDialog.this.panel.getDatabase(), entry, ImportInspectionDialog.this.panel));
                ImportInspectionDialog.this.panel.getDatabase().removeEntry(entry);
            }
        }

        private void addSelectedEntries(NamedCompound ce, List<BibEntry> selected) {
            if (ImportInspectionDialog.this.newDatabase) {
                Defaults defaults = new Defaults(BibDatabaseMode.fromPreference(Globals.prefs.getBoolean("biblatexMode")));
                ImportInspectionDialog.this.panel = new BasePanel(ImportInspectionDialog.this.frame, new BibDatabaseContext(defaults));
            }
            boolean groupingCanceled = false;
            UpdateField.setAutomaticFields(selected, Globals.prefs.getUpdateFieldPreferences());
            if (EntryMarker.shouldMarkEntries()) {
                for (BibEntry entry : selected) {
                    EntryMarker.markEntry(entry, 6, false, new NamedCompound(""));
                }
            }
            if (Globals.prefs.getBoolean("unmarkAllEntriesBeforeImporting")) {
                for (BibEntry entry : ImportInspectionDialog.this.panel.getDatabase().getEntries()) {
                    EntryMarker.unmarkEntry(entry, true, ImportInspectionDialog.this.panel.getDatabase(), ce);
                }
            }
            for (BibEntry entry : selected) {
                entry.setSearchHit(false);
                entry.setGroupHit(false);
                Set groups = (Set)ImportInspectionDialog.this.groupAdditions.get(entry);
                if (!groupingCanceled && groups != null) {
                    groupingCanceled = this.addToGroups(ce, entry, groups);
                }
                entry.setId(IdGenerator.next());
                ImportInspectionDialog.this.panel.getDatabase().insertEntry(entry);
                ce.addEdit(new UndoableInsertEntry(ImportInspectionDialog.this.panel.getDatabase(), entry, ImportInspectionDialog.this.panel));
            }
            ce.end();
            ImportInspectionDialog.this.panel.getUndoManager().addEdit(ce);
        }

        private boolean addToGroups(NamedCompound ce, BibEntry entry, Set<GroupTreeNode> groups) {
            boolean groupingCanceled = false;
            if (!entry.hasCiteKey()) {
                int answer = JOptionPane.showConfirmDialog(ImportInspectionDialog.this, Localization.lang("Cannot add entries to group without generating keys. Generate keys now?", new String[0]), Localization.lang("Add to group", new String[0]), 0);
                if (answer == 0) {
                    ImportInspectionDialog.this.generateKeys();
                } else {
                    groupingCanceled = true;
                }
            }
            if (entry.hasCiteKey()) {
                for (GroupTreeNode node : groups) {
                    Optional<EntriesGroupChange> undo;
                    if (!node.supportsAddingEntries() || !(undo = node.getGroup().add(Collections.singletonList(entry))).isPresent()) continue;
                    ce.addEdit(UndoableChangeEntriesOfGroup.getUndoableEdit(new GroupTreeNodeViewModel(node), undo.get()));
                }
            }
            return groupingCanceled;
        }

        private List<BibEntry> getSelectedEntries() {
            ArrayList<BibEntry> selected = new ArrayList<BibEntry>();
            for (BibEntry entry : ImportInspectionDialog.this.entries) {
                if (!entry.isSearchHit()) continue;
                selected.add(entry);
            }
            return selected;
        }
    }

    class AddToGroupAction
    extends AbstractAction {
        private final GroupTreeNode node;

        public AddToGroupAction(GroupTreeNode node) {
            super(node.getName());
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            ImportInspectionDialog.this.selectionModel.getSelected().getReadWriteLock().writeLock().lock();
            try {
                for (BibEntry entry : ImportInspectionDialog.this.selectionModel.getSelected()) {
                    HashSet<GroupTreeNode> groups = (HashSet<GroupTreeNode>)ImportInspectionDialog.this.groupAdditions.get(entry);
                    if (groups == null) {
                        groups = new HashSet<GroupTreeNode>();
                        ImportInspectionDialog.this.groupAdditions.put(entry, groups);
                    }
                    groups.add(this.node);
                }
            }
            finally {
                ImportInspectionDialog.this.selectionModel.getSelected().getReadWriteLock().writeLock().unlock();
            }
        }
    }
}

