/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.gui.importer.ImportFileFilter;
import net.sf.jabref.gui.importer.ImportMenuItem;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.FileExtensions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportFormats {
    private static final Log LOGGER = LogFactory.getLog(ImportFormats.class);

    public static AbstractAction getImportAction(JabRefFrame frame, boolean openInNew) {
        class ImportAction
        extends MnemonicAwareAction {
            private final JabRefFrame frame;
            private final boolean newDatabase;

            public ImportAction(JabRefFrame frame, boolean newDatabase) {
                this.frame = frame;
                this.newDatabase = newDatabase;
                if (newDatabase) {
                    this.putValue("Name", Localization.menuTitle("Import into new database", new String[0]));
                    this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.IMPORT_INTO_NEW_DATABASE));
                } else {
                    this.putValue("Name", Localization.menuTitle("Import into current database", new String[0]));
                    this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.IMPORT_INTO_CURRENT_DATABASE));
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SortedSet<Importer> importers = Globals.IMPORT_FORMAT_READER.getImportFormats();
                List<FileExtensions> extensions = importers.stream().map(p -> p.getExtensions()).collect(Collectors.toList());
                FileDialog dialog = new FileDialog(this.frame, Globals.prefs.get("importWorkingDirectory"));
                ImportFileFilter allImports = new ImportFileFilter(Localization.lang("Available import formats", new String[0]), importers);
                dialog.setFileFilter(allImports);
                dialog.withExtensions(extensions);
                Optional<Path> selectedFile = dialog.showDialogAndGetSelectedFile();
                selectedFile.ifPresent(sel -> {
                    try {
                        File file = sel.toFile();
                        if (!file.exists()) {
                            JOptionPane.showMessageDialog(this.frame, Localization.lang("File not found", new String[0]) + ": '" + file.getName() + "'.", Localization.lang("Import", new String[0]), 0);
                            return;
                        }
                        Optional<Importer> format = importers.stream().filter(i -> Objects.equals(i.getExtensions().getDescription(), dialog.getFileFilter().getDescription())).findFirst();
                        ImportMenuItem importMenu = new ImportMenuItem(this.frame, this.newDatabase, format.orElse(null));
                        importMenu.automatedImport(Collections.singletonList(file.getAbsolutePath()));
                        Globals.prefs.put("importWorkingDirectory", file.getParent());
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Cannot import file", ex);
                    }
                });
            }
        }
        return new ImportAction(frame, openInNew);
    }
}

