/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.jabref.logic.importer.Importer;
import net.sf.jabref.logic.util.FileExtensions;

class ImportFileFilter
extends FileFilter
implements Comparable<ImportFileFilter> {
    private final String description;
    private final FileNameExtensionFilter fileFilter;

    public ImportFileFilter(Importer format) {
        FileExtensions extensions = format.getExtensions();
        this.description = extensions.getDescription();
        this.fileFilter = new FileNameExtensionFilter(extensions.getDescription(), extensions.getExtensions());
    }

    public ImportFileFilter(String description, Collection<Importer> formats) {
        this.description = description;
        List extensions = formats.stream().map(p -> p.getExtensions()).collect(Collectors.toList());
        List<String> flatExtensions = extensions.stream().flatMap(extList -> Stream.of(extList.getExtensions())).collect(Collectors.toList());
        this.fileFilter = new FileNameExtensionFilter(description, flatExtensions.toArray(new String[flatExtensions.size()]));
    }

    @Override
    public boolean accept(File file) {
        return file != null && (file.isDirectory() || this.fileFilter.accept(file));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int compareTo(ImportFileFilter o) {
        return this.description.compareTo(o.description);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ImportFileFilter) {
            return this.description.equals(((ImportFileFilter)o).description);
        }
        return false;
    }

    public int hashCode() {
        return this.description.hashCode();
    }
}

