/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.importer.OutputPrinter;
import net.sf.jabref.logic.l10n.Localization;

public class FetcherPreviewDialog
extends JDialog
implements OutputPrinter {
    private final EventList<TableEntry> entries = new BasicEventList<TableEntry>();
    private final JTable glTable;
    private boolean okPressed;
    private final JabRefFrame frame;
    private final int warningLimit;

    public FetcherPreviewDialog(JabRefFrame frame, int warningLimit, int tableRowHeight) {
        super(frame, Localization.lang("Title", new String[0]), true);
        this.frame = frame;
        this.warningLimit = warningLimit;
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        ok.addActionListener(e -> {
            if (this.verifySelection()) {
                this.okPressed = true;
                this.dispose();
            }
        });
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        cancel.addActionListener(e -> {
            this.okPressed = false;
            this.dispose();
        });
        JButton selectAll = new JButton(Localization.lang("Select all", new String[0]));
        selectAll.addActionListener(e -> this.setSelectionAll(true));
        JButton deselectAll = new JButton(Localization.lang("Deselect all", new String[0]));
        deselectAll.addActionListener(e -> this.setSelectionAll(false));
        DefaultEventTableModel tableModelGl = (DefaultEventTableModel)GlazedListsSwing.eventTableModelWithThreadProxyList(this.entries, new EntryTableFormat());
        this.glTable = new EntryTable(tableModelGl);
        this.glTable.setRowHeight(tableRowHeight);
        this.glTable.getColumnModel().getColumn(0).setMaxWidth(45);
        this.glTable.setPreferredScrollableViewportSize(new Dimension(1100, 600));
        DefaultEventSelectionModel selectionModel = (DefaultEventSelectionModel)GlazedListsSwing.eventSelectionModelWithThreadProxyList(this.entries);
        this.glTable.setSelectionModel(selectionModel);
        ButtonStackBuilder builder = new ButtonStackBuilder();
        builder.addButton((JComponent)selectAll);
        builder.addButton((JComponent)deselectAll);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel centerPan = new JPanel();
        centerPan.setLayout(new BorderLayout());
        centerPan.add((Component)new JScrollPane(this.glTable), "Center");
        centerPan.add((Component)builder.getPanel(), "West");
        this.getContentPane().add((Component)centerPan, "Center");
        this.getContentPane().add((Component)bb.getPanel(), "South");
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FetcherPreviewDialog.this.dispose();
            }
        };
        ActionMap am = centerPan.getActionMap();
        InputMap im = centerPan.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", closeAction);
        this.pack();
    }

    private boolean verifySelection() {
        int selected = 0;
        for (TableEntry entry : this.entries) {
            if (!entry.isWanted()) continue;
            ++selected;
        }
        if (selected > this.warningLimit) {
            int result = JOptionPane.showConfirmDialog(this, Localization.lang("You have selected more than %0 entries for download. Some web sites might block you if you make too many rapid downloads. Do you want to continue?", String.valueOf(this.warningLimit)), Localization.lang("Confirm selection", new String[0]), 0, 2);
            return result == 0;
        }
        return true;
    }

    public Map<String, Boolean> getSelection() {
        LinkedHashMap<String, Boolean> selection = new LinkedHashMap<String, Boolean>();
        for (TableEntry e : this.entries) {
            selection.put(e.id, e.isWanted());
        }
        return selection;
    }

    public void addEntry(String entryId, JLabel preview) {
        TableEntry entry = new TableEntry(entryId, preview);
        this.entries.getReadWriteLock().writeLock().lock();
        this.entries.add(entry);
        this.entries.getReadWriteLock().writeLock().unlock();
        this.glTable.repaint();
    }

    private void setSelectionAll(boolean select) {
        for (int i = 0; i < this.glTable.getRowCount(); ++i) {
            this.glTable.setValueAt(select, i, 0);
        }
        this.glTable.repaint();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    @Override
    public void setStatus(String s) {
        this.frame.setStatus(s);
    }

    @Override
    public void showMessage(String message, String title, int msgType) {
        JOptionPane.showMessageDialog(this, message, title, msgType);
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public void showErrorMessage(String fetcherTitle, String localizedMessage) {
        this.showMessage(Localization.lang("Error while fetching from %0", fetcherTitle) + "\n" + Localization.lang("Please try again later and/or check your network connection.", new String[0]) + "\n" + localizedMessage, Localization.lang("Search %0", fetcherTitle), 0);
    }

    private static class EntryTableFormat
    implements TableFormat<TableEntry> {
        private EntryTableFormat() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int i) {
            if (i == 0) {
                return Localization.lang("Keep", new String[0]);
            }
            return Localization.lang("Preview", new String[0]);
        }

        @Override
        public Object getColumnValue(TableEntry entry, int i) {
            if (i == 0) {
                return entry.isWanted() ? Boolean.TRUE : Boolean.FALSE;
            }
            return entry.getPreview();
        }
    }

    class EntryTable
    extends JTable {
        private final PreviewRenderer renderer;

        public EntryTable(TableModel model) {
            super(model);
            this.renderer = new PreviewRenderer();
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return column == 0 ? this.getDefaultRenderer(Boolean.class) : this.renderer;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return JLabel.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            FetcherPreviewDialog.this.entries.getReadWriteLock().writeLock().lock();
            TableEntry entry = (TableEntry)FetcherPreviewDialog.this.entries.get(row);
            entry.setWanted((Boolean)value);
            FetcherPreviewDialog.this.entries.getReadWriteLock().writeLock().unlock();
        }
    }

    static class PreviewRenderer
    implements TableCellRenderer {
        private final JLabel label = new JLabel();

        PreviewRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel valueLabel = (JLabel)value;
            this.label.setText(valueLabel.getText());
            return this.label;
        }
    }

    static class TableEntry {
        private final String id;
        private final JLabel preview;
        private boolean wanted;

        public TableEntry(String id, JLabel preview) {
            this.id = id;
            this.preview = preview;
        }

        public boolean isWanted() {
            return this.wanted;
        }

        public void setWanted(boolean wanted) {
            this.wanted = wanted;
        }

        public JLabel getPreview() {
            return this.preview;
        }
    }
}

