/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.importer.EntryFromFileCreator;
import net.sf.jabref.logic.xmp.XMPUtil;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.pdfimport.PdfImporter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;

public class EntryFromPDFCreator
extends EntryFromFileCreator {
    public EntryFromPDFCreator() {
        super(EntryFromPDFCreator.getPDFExternalFileType());
    }

    private static ExternalFileType getPDFExternalFileType() {
        Optional<ExternalFileType> pdfFileType = ExternalFileTypes.getInstance().getExternalFileTypeByExt("pdf");
        if (!pdfFileType.isPresent()) {
            return new ExternalFileType("PDF", "pdf", "application/pdf", "evince", "pdfSmall", IconTheme.JabRefIcon.PDF_FILE.getSmallIcon());
        }
        return pdfFileType.get();
    }

    @Override
    public boolean accept(File f) {
        return f != null && f.getName().toUpperCase().endsWith(".PDF");
    }

    @Override
    protected Optional<BibEntry> createBibtexEntry(File pdfFile) {
        if (!this.accept(pdfFile)) {
            return Optional.empty();
        }
        PdfImporter pi = new PdfImporter(JabRefGUI.getMainFrame(), JabRefGUI.getMainFrame().getCurrentBasePanel(), JabRefGUI.getMainFrame().getCurrentBasePanel().getMainTable(), -1);
        PdfImporter.ImportPdfFilesResult res = pi.importPdfFiles(Collections.singletonList(pdfFile.toString()));
        if (res.getEntries().size() == 1) {
            return Optional.of(res.getEntries().get(0));
        }
        return Optional.empty();
    }

    private void addEntryDataFromPDDocumentInformation(File pdfFile, BibEntry entry) {
        try (PDDocument document = PDDocument.load(pdfFile.getAbsoluteFile());){
            Optional<BibEntry> entryDI;
            PDDocumentInformation pdfDocInfo = document.getDocumentInformation();
            if (pdfDocInfo != null && (entryDI = XMPUtil.getBibtexEntryFromDocumentInformation(document.getDocumentInformation())).isPresent()) {
                this.addEntryDataToEntry(entry, entryDI.get());
                Calendar creationDate = pdfDocInfo.getCreationDate();
                if (creationDate != null) {
                    String date = LocalDate.of(1, 3, 5).format(DateTimeFormatter.ISO_LOCAL_DATE);
                    this.appendToField(entry, Globals.prefs.get("timeStampField"), date);
                }
                if (pdfDocInfo.getCustomMetadataValue("bibtex/bibtexkey") != null) {
                    entry.setId(pdfDocInfo.getCustomMetadataValue("bibtex/bibtexkey"));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addEntryDataFromXMP(File aFile, BibEntry entry) {
        try {
            List<BibEntry> entrys = XMPUtil.readXMP(aFile.getAbsoluteFile(), Globals.prefs.getXMPPreferences());
            this.addEntrysToEntry(entry, entrys);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getFormatName() {
        return "PDF";
    }
}

