/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.importer.EntryFromExternalFileCreator;
import net.sf.jabref.gui.importer.EntryFromFileCreator;
import net.sf.jabref.gui.importer.EntryFromPDFCreator;
import net.sf.jabref.gui.undo.UndoableInsertEntry;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.database.BibDatabase;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.entry.EntryType;
import net.sf.jabref.model.entry.IdGenerator;

public final class EntryFromFileCreatorManager {
    private final List<EntryFromFileCreator> entryCreators = new ArrayList<EntryFromFileCreator>(10);

    public EntryFromFileCreatorManager() {
        this.entryCreators.add(new EntryFromPDFCreator());
        Set<ExternalFileType> fileTypes = ExternalFileTypes.getInstance().getExternalFileTypeSelection();
        for (ExternalFileType exFileType : fileTypes) {
            if (this.hasSpecialisedCreatorForExternalFileType(exFileType)) continue;
            this.entryCreators.add(new EntryFromExternalFileCreator(exFileType));
        }
    }

    private boolean hasSpecialisedCreatorForExternalFileType(ExternalFileType externalFileType) {
        for (EntryFromFileCreator entryCreator : this.entryCreators) {
            if (entryCreator.getExternalFileType() == null || entryCreator.getExternalFileType().getExtension().isEmpty() || !entryCreator.getExternalFileType().getExtension().equals(externalFileType.getExtension())) continue;
            return true;
        }
        return false;
    }

    public EntryFromFileCreator getEntryCreator(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        for (EntryFromFileCreator creator : this.entryCreators) {
            if (!creator.accept(file)) continue;
            return creator;
        }
        return null;
    }

    public List<String> addEntrysFromFiles(List<File> files, BibDatabase database, EntryType entryType, boolean generateKeywordsFromPathToFile) {
        LinkedList<String> importGUIMessages = new LinkedList<String>();
        this.addEntriesFromFiles(files, database, null, entryType, generateKeywordsFromPathToFile, null, importGUIMessages);
        return importGUIMessages;
    }

    public int addEntriesFromFiles(List<File> files, BibDatabase database, BasePanel panel, EntryType entryType, boolean generateKeywordsFromPathToFile, ChangeListener changeListener, List<String> importGUIMessages) {
        int count = 0;
        CompoundEdit ce = new CompoundEdit();
        for (File f : files) {
            EntryFromFileCreator creator = this.getEntryCreator(f);
            if (creator == null) {
                importGUIMessages.add("Problem importing " + f.getPath() + ": Unknown filetype.");
            } else {
                Optional<BibEntry> entry = creator.createEntry(f, generateKeywordsFromPathToFile);
                if (!entry.isPresent()) {
                    importGUIMessages.add("Problem importing " + f.getPath() + ": Entry could not be created.");
                    continue;
                }
                if (entryType != null) {
                    entry.get().setType(entryType);
                }
                if (entry.get().getId() == null) {
                    entry.get().setId(IdGenerator.next());
                }
                if (!database.containsEntryWithId(entry.get().getId())) {
                    if (database.insertEntry(entry.get())) {
                        importGUIMessages.add("Problem importing " + f.getPath() + ": Insert into BibDatabase failed.");
                    } else {
                        ++count;
                        if (panel != null) {
                            ce.addEdit(new UndoableInsertEntry(database, entry.get(), panel));
                        }
                    }
                }
            }
            if (changeListener == null) continue;
            changeListener.stateChanged(new ChangeEvent(this));
        }
        if (count > 0 && panel != null) {
            ce.end();
            panel.getUndoManager().addEdit(ce);
        }
        return count;
    }

    private FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                for (EntryFromFileCreator creator : EntryFromFileCreatorManager.this.entryCreators) {
                    if (!creator.accept(file)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return Localization.lang("All external files", new String[0]);
            }
        };
    }

    public List<FileFilter> getFileFilterList() {
        ArrayList<FileFilter> filters = new ArrayList<FileFilter>();
        filters.add(this.getFileFilter());
        for (FileFilter fileFilter : this.entryCreators) {
            filters.add(fileFilter);
        }
        return filters;
    }
}

