/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.importer;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.entry.BibEntry;

public abstract class EntryFromFileCreator
implements FileFilter {
    protected final ExternalFileType externalFileType;
    private static final int MIN_PATH_TOKEN_LENGTH = 4;

    EntryFromFileCreator(ExternalFileType externalFileType) {
        this.externalFileType = externalFileType;
    }

    protected abstract Optional<BibEntry> createBibtexEntry(File var1);

    @Override
    public abstract boolean accept(File var1);

    public abstract String getFormatName();

    public Optional<BibEntry> createEntry(File f, boolean addPathTokensAsKeywords) {
        if (f == null || !f.exists()) {
            return Optional.empty();
        }
        Optional<BibEntry> newEntry = this.createBibtexEntry(f);
        if (!newEntry.isPresent()) {
            return newEntry;
        }
        if (addPathTokensAsKeywords) {
            this.appendToField(newEntry.get(), "keywords", EntryFromFileCreator.extractPathesToKeyWordsfield(f.getAbsolutePath()));
        }
        if (!newEntry.get().hasField("title")) {
            newEntry.get().setField("title", f.getName());
        }
        this.addFileInfo(newEntry.get(), f);
        return newEntry;
    }

    public ExternalFileType getExternalFileType() {
        return this.externalFileType;
    }

    private static String extractPathesToKeyWordsfield(String absolutePath) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(absolutePath, String.valueOf(File.separatorChar));
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!st.hasMoreTokens()) break;
            if (token.length() < 4) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(token);
        }
        return sb.toString();
    }

    private void addFileInfo(BibEntry entry, File file) {
        Optional<ExternalFileType> fileType = ExternalFileTypes.getInstance().getExternalFileTypeByExt(this.externalFileType.getFieldName());
        List<String> possibleFilePaths = JabRefGUI.getMainFrame().getCurrentBasePanel().getBibDatabaseContext().getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
        File shortenedFileName = FileUtil.shortenFileName(file, possibleFilePaths);
        FileListEntry fileListEntry = new FileListEntry("", shortenedFileName.getPath(), fileType);
        FileListTableModel model = new FileListTableModel();
        model.addEntry(0, fileListEntry);
        entry.setField("file", model.getStringRepresentation());
    }

    protected void appendToField(BibEntry entry, String field, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        Optional<String> oVal = entry.getField(field);
        if (oVal.isPresent()) {
            if (!oVal.get().contains(value)) {
                entry.setField(field, oVal.get() + "," + value);
            }
        } else {
            entry.setField(field, value);
        }
    }

    protected void addEntrysToEntry(BibEntry entry, List<BibEntry> entrys) {
        if (entrys != null) {
            for (BibEntry e : entrys) {
                this.addEntryDataToEntry(entry, e);
            }
        }
    }

    protected void addEntryDataToEntry(BibEntry entry, BibEntry e) {
        for (String field : e.getFieldNames()) {
            e.getField(field).ifPresent(fieldContent -> this.appendToField(entry, field, (String)fieldContent));
        }
    }

    public String toString() {
        if (this.externalFileType == null) {
            return "(undefined)";
        }
        return this.externalFileType.getName() + " (." + this.externalFileType.getExtension() + ")";
    }
}

