/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.help;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.actions.MnemonicAwareAction;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;

public class HelpAction
extends MnemonicAwareAction {
    private static final Set<String> avaiableLangFiles = Stream.of("en", "de", "fr", "in", "ja").collect(Collectors.toCollection(HashSet::new));
    private HelpFile helpPage;

    public HelpAction(String title, String tooltip, HelpFile helpPage, KeyStroke key) {
        this(title, tooltip, helpPage, IconTheme.JabRefIcon.HELP.getSmallIcon());
        this.putValue("AcceleratorKey", key);
    }

    private HelpAction(String title, String tooltip, HelpFile helpPage, Icon icon) {
        super(icon);
        this.helpPage = helpPage;
        this.putValue("Name", title);
        this.putValue("ShortDescription", tooltip);
    }

    public HelpAction(String tooltip, HelpFile helpPage) {
        this(Localization.lang("Help", new String[0]), tooltip, helpPage, IconTheme.JabRefIcon.HELP.getSmallIcon());
    }

    public HelpAction(HelpFile helpPage, Icon icon) {
        this(Localization.lang("Help", new String[0]), Localization.lang("Help", new String[0]), helpPage, icon);
    }

    public HelpAction(HelpFile helpPage) {
        this(Localization.lang("Help", new String[0]), Localization.lang("Help", new String[0]), helpPage, IconTheme.JabRefIcon.HELP.getSmallIcon());
    }

    public JButton getHelpButton() {
        JButton button = new JButton(this);
        button.setText(null);
        button.setPreferredSize(new Dimension(24, 24));
        button.setToolTipText(this.getValue("ShortDescription").toString());
        return button;
    }

    public JLabel getHelpLabel(String labelText) {
        JLabel helpLabel = new JLabel("<html><u>" + labelText + "</u></html>");
        helpLabel.setForeground(Color.BLUE);
        helpLabel.setCursor(new Cursor(12));
        helpLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HelpAction.this.openHelpPage();
            }
        });
        return helpLabel;
    }

    public void setHelpFile(HelpFile urlPart) {
        this.helpPage = urlPart;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openHelpPage();
    }

    private void openHelpPage() {
        String lang = Globals.prefs.get("language");
        StringBuilder sb = new StringBuilder("https://help.jabref.org/");
        if (avaiableLangFiles.contains(lang)) {
            sb.append(lang);
            sb.append("/");
        } else {
            sb.append("en/");
        }
        sb.append(this.helpPage.getPageName());
        JabRefDesktop.openBrowserShowPopup(sb.toString());
    }
}

