/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.InternalBibtexFields;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.KeywordGroup;

public class WarnAssignmentSideEffects {
    public static boolean warnAssignmentSideEffects(List<AbstractGroup> groups, Component parent) {
        ArrayList<String> affectedFields = new ArrayList<String>();
        block0: for (AbstractGroup abstractGroup : groups) {
            KeywordGroup keywordGroup;
            String field;
            if (!(abstractGroup instanceof KeywordGroup) || "keywords".equals(field = (keywordGroup = (KeywordGroup)abstractGroup).getSearchField().toLowerCase()) || "groups".equals(field)) continue;
            for (String fieldName : InternalBibtexFields.getAllPublicFieldNames()) {
                if (!field.equals(fieldName)) continue;
                affectedFields.add(field);
                continue block0;
            }
        }
        if (affectedFields.isEmpty()) {
            return true;
        }
        StringBuilder message = new StringBuilder(Localization.lang("This action will modify the following field(s) in at least one entry each:", new String[0])).append('\n');
        for (String affectedField : affectedFields) {
            message.append(affectedField).append('\n');
        }
        message.append(Localization.lang("This could cause undesired changes to your entries.", new String[0])).append('\n').append("It is recommended that you change the grouping field in your group definition to \"keywords\" or a non-standard name.").append("\n\n").append(Localization.lang("Do you still want to continue?", new String[0]));
        int n = JOptionPane.showConfirmDialog(parent, message, Localization.lang("Warning", new String[0]), 0, 2);
        return n != 1;
    }

    public static boolean warnAssignmentSideEffects(AbstractGroup group, Component parent) {
        return WarnAssignmentSideEffects.warnAssignmentSideEffects(Collections.singletonList(group), parent);
    }
}

