/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.util.List;
import java.util.Objects;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.groups.GroupTreeNode;
import net.sf.jabref.model.groups.MoveGroupChange;

class UndoableMoveGroup
extends AbstractUndoableJabRefEdit {
    private final GroupTreeNodeViewModel root;
    private final List<Integer> pathToNewParent;
    private final int newChildIndex;
    private final List<Integer> pathToOldParent;
    private final int oldChildIndex;

    public UndoableMoveGroup(GroupTreeNodeViewModel root, MoveGroupChange moveChange) {
        this.root = Objects.requireNonNull(root);
        Objects.requireNonNull(moveChange);
        this.pathToOldParent = moveChange.getOldParent().getIndexedPathFromRoot();
        this.pathToNewParent = moveChange.getNewParent().getIndexedPathFromRoot();
        this.oldChildIndex = moveChange.getOldChildIndex();
        this.newChildIndex = moveChange.getNewChildIndex();
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("move group", new String[0]);
    }

    @Override
    public void undo() {
        super.undo();
        GroupTreeNode newParent = (GroupTreeNode)this.root.getNode().getDescendant(this.pathToNewParent).get();
        GroupTreeNode node = (GroupTreeNode)newParent.getChildAt(this.newChildIndex).get();
        node.moveTo((GroupTreeNode)this.root.getNode().getDescendant(this.pathToOldParent).get(), this.oldChildIndex);
    }

    @Override
    public void redo() {
        super.redo();
        GroupTreeNode oldParent = (GroupTreeNode)this.root.getNode().getDescendant(this.pathToOldParent).get();
        GroupTreeNode node = (GroupTreeNode)oldParent.getChildAt(this.oldChildIndex).get();
        node.moveTo((GroupTreeNode)this.root.getNode().getDescendant(this.pathToNewParent).get(), this.newChildIndex);
    }
}

