/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.util.List;
import java.util.Vector;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.model.groups.GroupTreeNode;

public class UndoableModifySubtree
extends AbstractUndoableJabRefEdit {
    private final GroupTreeNode m_groupRoot;
    private final GroupTreeNode m_subtreeBackup;
    private final List<Integer> m_subtreeRootPath;
    private final List<GroupTreeNode> m_modifiedSubtree = new Vector<GroupTreeNode>();
    private final String m_name;

    public UndoableModifySubtree(GroupTreeNodeViewModel groupRoot, GroupTreeNodeViewModel subtree, String name) {
        this.m_subtreeBackup = (GroupTreeNode)subtree.getNode().copySubtree();
        this.m_groupRoot = groupRoot.getNode();
        this.m_subtreeRootPath = subtree.getNode().getIndexedPathFromRoot();
        this.m_name = name;
    }

    @Override
    public String getPresentationName() {
        return this.m_name;
    }

    @Override
    public void undo() {
        super.undo();
        this.m_modifiedSubtree.clear();
        GroupTreeNode subtreeRoot = (GroupTreeNode)this.m_groupRoot.getDescendant(this.m_subtreeRootPath).get();
        for (GroupTreeNode child : subtreeRoot.getChildren()) {
            this.m_modifiedSubtree.add(child);
        }
        subtreeRoot.removeAllChildren();
        for (GroupTreeNode child : this.m_subtreeBackup.getChildren()) {
            ((GroupTreeNode)child.copySubtree()).moveTo(subtreeRoot);
        }
    }

    @Override
    public void redo() {
        super.redo();
        GroupTreeNode subtreeRoot = (GroupTreeNode)this.m_groupRoot.getDescendant(this.m_subtreeRootPath).get();
        subtreeRoot.removeAllChildren();
        for (GroupTreeNode modifiedNode : this.m_modifiedSubtree) {
            modifiedNode.moveTo(subtreeRoot);
        }
    }
}

