/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.util.List;
import net.sf.jabref.gui.groups.GroupSelector;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.GroupTreeNode;

class UndoableModifyGroup
extends AbstractUndoableJabRefEdit {
    private final GroupSelector groupSelector;
    private final AbstractGroup m_oldGroupBackup;
    private final AbstractGroup m_newGroupBackup;
    private final GroupTreeNode m_groupsRootHandle;
    private final List<Integer> m_pathToNode;

    public UndoableModifyGroup(GroupSelector gs, GroupTreeNodeViewModel groupsRoot, GroupTreeNodeViewModel node, AbstractGroup newGroup) {
        this.groupSelector = gs;
        this.m_oldGroupBackup = node.getNode().getGroup().deepCopy();
        this.m_newGroupBackup = newGroup.deepCopy();
        this.m_pathToNode = node.getNode().getIndexedPathFromRoot();
        this.m_groupsRootHandle = groupsRoot.getNode();
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("modify group", new String[0]);
    }

    @Override
    public void undo() {
        super.undo();
        ((GroupTreeNode)this.m_groupsRootHandle.getDescendant(this.m_pathToNode).get()).setGroup(this.m_oldGroupBackup.deepCopy());
        this.groupSelector.revalidateGroups();
    }

    @Override
    public void redo() {
        super.redo();
        ((GroupTreeNode)this.m_groupsRootHandle.getDescendant(this.m_pathToNode).get()).setGroup(this.m_newGroupBackup.deepCopy());
        this.groupSelector.revalidateGroups();
    }
}

