/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.undo.AbstractUndoableJabRefEdit;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.GroupTreeNode;

public class UndoableChangeAssignment
extends AbstractUndoableJabRefEdit {
    private final List<BibEntry> previousAssignments;
    private final List<BibEntry> newAssignments;
    private final List<Integer> pathToNode;
    private final GroupTreeNode root;

    public UndoableChangeAssignment(GroupTreeNodeViewModel node, Set<BibEntry> previousAssignments, Set<BibEntry> newAssignments) {
        this.previousAssignments = new ArrayList<BibEntry>(previousAssignments);
        this.newAssignments = new ArrayList<BibEntry>(newAssignments);
        this.root = (GroupTreeNode)node.getNode().getRoot();
        this.pathToNode = node.getNode().getIndexedPathFromRoot();
    }

    @Override
    public String getPresentationName() {
        return Localization.lang("change assignment of entries", new String[0]);
    }

    @Override
    public void undo() {
        super.undo();
        Optional node = this.root.getDescendant(this.pathToNode);
        if (node.isPresent()) {
            ((GroupTreeNode)node.get()).getGroup().add(this.previousAssignments);
        }
    }

    @Override
    public void redo() {
        super.redo();
        Optional node = this.root.getDescendant(this.pathToNode);
        if (node.isPresent()) {
            ((GroupTreeNode)node.get()).getGroup().add(this.newAssignments);
        }
    }
}

