/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.AbstractAction;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.groups.UndoableChangeEntriesOfGroup;
import net.sf.jabref.gui.groups.WarnAssignmentSideEffects;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.groups.EntriesGroupChange;

public class RemoveFromGroupAction
extends AbstractAction {
    private GroupTreeNodeViewModel mNode;
    private BasePanel mPanel;

    public RemoveFromGroupAction(GroupTreeNodeViewModel node, BasePanel panel) {
        super(node.getNode().getGroup().getName());
        this.mNode = node;
        this.mPanel = panel;
    }

    public RemoveFromGroupAction() {
        super(Localization.lang("Remove entry selection from this group", new String[0]));
    }

    public void setNode(GroupTreeNodeViewModel node) {
        this.mNode = node;
    }

    public void setBasePanel(BasePanel panel) {
        this.mPanel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!WarnAssignmentSideEffects.warnAssignmentSideEffects(this.mNode.getNode().getGroup(), (Component)this.mPanel.frame())) {
            return;
        }
        Optional<EntriesGroupChange> undo = this.mNode.removeEntriesFromGroup(this.mPanel.getSelectedEntries());
        if (!undo.isPresent()) {
            return;
        }
        this.mPanel.getUndoManager().addEdit(UndoableChangeEntriesOfGroup.getUndoableEdit(this.mNode, undo.get()));
        this.mPanel.markBaseChanged();
        this.mPanel.updateEntryEditorIfShowing();
        this.mPanel.getGroupSelector().valueChanged(null);
    }
}

