/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;
import net.sf.jabref.gui.groups.GroupSelector;
import net.sf.jabref.gui.groups.GroupTreeCellRenderer;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.groups.TransferableEntrySelection;
import net.sf.jabref.gui.groups.UndoableChangeEntriesOfGroup;
import net.sf.jabref.gui.groups.WarnAssignmentSideEffects;
import net.sf.jabref.gui.util.GUIUtil;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.EntriesGroupChange;
import net.sf.jabref.model.groups.GroupTreeNode;
import net.sf.jabref.model.groups.MoveGroupChange;

public class GroupsTree
extends JTree
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private static final int DRAG_SCROLL_ACTIVATION_MARGIN = 10;
    private static final int DRAG_SCROLL_DISTANCE = 5;
    private static long lastDragAutoscroll;
    private static final long MIN_AUTOSCROLL_INTERVAL = 50L;
    private Point idlePoint;
    private long idleStartTime;
    private static final int IDLE_MARGIN = 1;
    private static final long IDLE_TIME_TO_EXPAND_NODE = 1000L;
    private final GroupSelector groupSelector;
    private GroupTreeNodeViewModel dragNode;
    private final GroupTreeCellRenderer localCellRenderer = new GroupTreeCellRenderer();

    public GroupsTree(GroupSelector groupSelector) {
        GUIUtil.correctRowHeight(this);
        this.groupSelector = groupSelector;
        DragGestureRecognizer dgr = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 2, this);
        if (dgr != null) {
            dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
        }
        new DropTarget(this, this);
        this.setCellRenderer(this.localCellRenderer);
        this.setFocusable(false);
        this.setToggleClickCount(0);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(4);
        this.setFocusable(true);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        Point p = dsde.getLocation();
        if (p != null) {
            SwingUtilities.convertPointFromScreen(p, this);
            TreePath path = this.getPathForLocation(p.x, p.y);
            if (path == null) {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                return;
            }
            GroupTreeNodeViewModel target = (GroupTreeNodeViewModel)path.getLastPathComponent();
            if (target == null || this.dragNode.getNode().isNodeDescendant(target.getNode()) || this.dragNode.equals(target)) {
                dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                return;
            }
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dragNode = null;
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        boolean scrollRight;
        TreePath path;
        Point cursor = dtde.getLocation();
        long currentTime = System.currentTimeMillis();
        if (this.idlePoint == null) {
            this.idlePoint = cursor;
        }
        GroupTreeNodeViewModel target = (path = this.getPathForLocation(cursor.x, cursor.y)) == null ? null : (GroupTreeNodeViewModel)path.getLastPathComponent();
        this.setHighlight1Cell(target);
        if (dtde.isDataFlavorSupported(GroupTreeNodeViewModel.FLAVOR)) {
            dtde.acceptDrag(2);
        } else if (dtde.isDataFlavorSupported(TransferableEntrySelection.FLAVOR_INTERNAL)) {
            if (target == null) {
                dtde.rejectDrag();
            } else if (target.getNode().supportsAddingEntries()) {
                dtde.acceptDrag(0x40000000);
            } else {
                dtde.rejectDrag();
            }
        } else {
            dtde.rejectDrag();
        }
        if (Math.abs(cursor.x - this.idlePoint.x) < 1 && Math.abs(cursor.y - this.idlePoint.y) < 1) {
            if (currentTime - this.idleStartTime >= 1000L && path != null) {
                this.expandPath(path);
            }
        } else {
            this.idlePoint = cursor;
            this.idleStartTime = currentTime;
        }
        if (currentTime - lastDragAutoscroll < 50L) {
            return;
        }
        Rectangle r = this.getVisibleRect();
        boolean scrollUp = cursor.y - r.y < 10;
        boolean scrollDown = r.y + r.height - cursor.y < 10;
        boolean scrollLeft = cursor.x - r.x < 10;
        boolean bl = scrollRight = r.x + r.width - cursor.x < 10;
        if (scrollUp) {
            r.translate(0, -5);
        } else if (scrollDown) {
            r.translate(0, 5);
        }
        if (scrollLeft) {
            r.translate(-5, 0);
        } else if (scrollRight) {
            r.translate(5, 0);
        }
        this.scrollRectToVisible(r);
        lastDragAutoscroll = currentTime;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.setHighlight1Cell(null);
        try {
            Point p = dtde.getLocation();
            TreePath path = this.getPathForLocation(p.x, p.y);
            if (path == null) {
                dtde.rejectDrop();
                return;
            }
            GroupTreeNodeViewModel target = (GroupTreeNodeViewModel)path.getLastPathComponent();
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(GroupTreeNodeViewModel.FLAVOR)) {
                GroupTreeNodeViewModel source = (GroupTreeNodeViewModel)transferable.getTransferData(GroupTreeNodeViewModel.FLAVOR);
                if (source.equals(target)) {
                    dtde.rejectDrop();
                    return;
                }
                if (source.getNode().isNodeDescendant(target.getNode())) {
                    dtde.rejectDrop();
                    return;
                }
                Enumeration<TreePath> expandedPaths = this.groupSelector.getExpandedPaths();
                MoveGroupChange undo = new MoveGroupChange(((GroupTreeNodeViewModel)source.getParent()).getNode(), source.getNode().getPositionInParent(), target.getNode(), target.getChildCount());
                source.getNode().moveTo(target.getNode());
                dtde.getDropTargetContext().dropComplete(true);
                this.groupSelector.revalidateGroups(new TreePath[]{source.getTreePath()}, this.refreshPaths(expandedPaths));
                this.groupSelector.concludeMoveGroup(undo, source);
            } else if (transferable.isDataFlavorSupported(TransferableEntrySelection.FLAVOR_INTERNAL)) {
                AbstractGroup group = target.getNode().getGroup();
                if (!target.getNode().supportsAddingEntries()) {
                    dtde.rejectDrop();
                    return;
                }
                TransferableEntrySelection selection = (TransferableEntrySelection)transferable.getTransferData(TransferableEntrySelection.FLAVOR_INTERNAL);
                List<BibEntry> entries = selection.getSelection();
                int assignedEntries = 0;
                for (BibEntry entry : entries) {
                    if (target.getNode().getGroup().contains(entry)) continue;
                    ++assignedEntries;
                }
                if (!WarnAssignmentSideEffects.warnAssignmentSideEffects(group, (Component)this.groupSelector.frame)) {
                    return;
                }
                this.groupSelector.getActiveBasePanel().storeCurrentEdit();
                Optional<EntriesGroupChange> undo = target.addEntriesToGroup(selection.getSelection());
                if (undo.isPresent()) {
                    dtde.getDropTargetContext().dropComplete(true);
                    this.groupSelector.concludeAssignment(UndoableChangeEntriesOfGroup.getUndoableEdit(target, undo.get()), target.getNode(), assignedEntries);
                }
            } else {
                dtde.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.setHighlight1Cell(null);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        GroupTreeNodeViewModel selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        Cursor cursor = DragSource.DefaultMoveDrop;
        this.dragNode = selectedNode;
        dge.getDragSource().startDrag(dge, cursor, selectedNode, this);
    }

    private GroupTreeNodeViewModel getSelectedNode() {
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath == null ? null : (GroupTreeNodeViewModel)selectionPath.getLastPathComponent();
    }

    public Enumeration<TreePath> refreshPaths(Enumeration<TreePath> paths) {
        if (paths == null) {
            return new Vector().elements();
        }
        Vector<TreePath> freshPaths = new Vector<TreePath>();
        while (paths.hasMoreElements()) {
            freshPaths.add(((GroupTreeNodeViewModel)paths.nextElement().getLastPathComponent()).getTreePath());
        }
        return freshPaths.elements();
    }

    public TreePath[] refreshPaths(TreePath[] paths) {
        TreePath[] freshPaths = new TreePath[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            freshPaths[i] = ((GroupTreeNodeViewModel)paths[i].getLastPathComponent()).getTreePath();
        }
        return freshPaths;
    }

    private void setHighlight1Cell(Object cell) {
        this.localCellRenderer.setHighlight1Cell(cell);
        this.repaint();
    }

    public void setOverlappingGroups(List<GroupTreeNode> nodes) {
        Objects.requireNonNull(nodes);
        this.localCellRenderer.setOverlappingGroups(nodes);
        this.repaint();
    }

    public void setMatchingGroups(List<GroupTreeNode> nodes) {
        Objects.requireNonNull(nodes);
        this.localCellRenderer.setMatchingGroups(nodes);
        this.repaint();
    }

    public void setHighlightBorderCell(GroupTreeNodeViewModel node) {
        this.localCellRenderer.setHighlightBorderCell(node);
        this.repaint();
    }

    public void sort(GroupTreeNodeViewModel node, boolean recursive) {
        node.sortChildrenByName(recursive);
    }

    public boolean hasExpandedDescendant(TreePath path) {
        GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)path.getLastPathComponent();
        for (GroupTreeNodeViewModel child : node.getChildren()) {
            TreePath pathToChild;
            if (child.isLeaf() || !this.isExpanded(pathToChild = path.pathByAddingChild(child)) && !this.hasExpandedDescendant(pathToChild)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCollapsedDescendant(TreePath path) {
        GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)path.getLastPathComponent();
        for (GroupTreeNodeViewModel child : node.getChildren()) {
            TreePath pathToChild;
            if (child.isLeaf() || !this.isCollapsed(pathToChild = path.pathByAddingChild(child)) && !this.hasCollapsedDescendant(pathToChild)) continue;
            return true;
        }
        return false;
    }
}

