/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefGUI;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.groups.UndoableAddOrRemoveGroup;
import net.sf.jabref.gui.groups.UndoableChangeEntriesOfGroup;
import net.sf.jabref.gui.undo.CountingUndoManager;
import net.sf.jabref.logic.groups.GroupDescriptions;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.AllEntriesGroup;
import net.sf.jabref.model.groups.EntriesGroupChange;
import net.sf.jabref.model.groups.ExplicitGroup;
import net.sf.jabref.model.groups.GroupTreeNode;
import net.sf.jabref.model.groups.KeywordGroup;
import net.sf.jabref.model.groups.MoveGroupChange;
import net.sf.jabref.model.groups.SearchGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupTreeNodeViewModel
implements Transferable,
TreeNode {
    private static final Log LOGGER = LogFactory.getLog(GroupTreeNodeViewModel.class);
    private static final Icon GROUP_REFINING_ICON = IconTheme.JabRefIcon.GROUP_REFINING.getSmallIcon();
    private static final Icon GROUP_INCLUDING_ICON = IconTheme.JabRefIcon.GROUP_INCLUDING.getSmallIcon();
    private static final Icon GROUP_REGULAR_ICON = null;
    public static final DataFlavor FLAVOR;
    private static final DataFlavor[] FLAVORS;
    private final GroupTreeNode node;

    public String toString() {
        StringBuilder sb = new StringBuilder("GroupTreeNodeViewModel{");
        sb.append("node=").append(this.node);
        sb.append('}');
        return sb.toString();
    }

    public GroupTreeNodeViewModel(GroupTreeNode node) {
        this.node = node;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor someFlavor) {
        return someFlavor.equals(FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor someFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(someFlavor)) {
            throw new UnsupportedFlavorException(someFlavor);
        }
        return this;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.node.getChildAt(childIndex).map(GroupTreeNodeViewModel::new).orElse(null);
    }

    @Override
    public int getChildCount() {
        return this.node.getNumberOfChildren();
    }

    @Override
    public TreeNode getParent() {
        return this.node.getParent().map(GroupTreeNodeViewModel::new).orElse(null);
    }

    @Override
    public int getIndex(TreeNode child) {
        if (!(child instanceof GroupTreeNodeViewModel)) {
            return -1;
        }
        GroupTreeNodeViewModel childViewModel = (GroupTreeNodeViewModel)child;
        return this.node.getIndexOfChild(childViewModel.getNode()).orElse(-1);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.node.isLeaf();
    }

    public Enumeration children() {
        final List children = this.node.getChildren();
        return new Enumeration<GroupTreeNodeViewModel>(){

            @Override
            public boolean hasMoreElements() {
                return children.iterator().hasNext();
            }

            @Override
            public GroupTreeNodeViewModel nextElement() {
                return new GroupTreeNodeViewModel((GroupTreeNode)children.iterator().next());
            }
        };
    }

    public GroupTreeNode getNode() {
        return this.node;
    }

    public void collapseSubtree(JTree tree) {
        tree.collapsePath(this.getTreePath());
        for (GroupTreeNodeViewModel child : this.getChildren()) {
            child.collapseSubtree(tree);
        }
    }

    public void expandSubtree(JTree tree) {
        tree.expandPath(this.getTreePath());
        for (GroupTreeNodeViewModel child : this.getChildren()) {
            child.expandSubtree(tree);
        }
    }

    public List<GroupTreeNodeViewModel> getChildren() {
        ArrayList<GroupTreeNodeViewModel> children = new ArrayList<GroupTreeNodeViewModel>();
        for (GroupTreeNode child : this.node.getChildren()) {
            children.add(new GroupTreeNodeViewModel(child));
        }
        return children;
    }

    protected boolean printInItalics() {
        return Globals.prefs.getBoolean("groupShowDynamic") && this.node.getGroup().isDynamic();
    }

    public String getText() {
        BasePanel currentBasePanel;
        AbstractGroup group = this.node.getGroup();
        StringBuilder sb = new StringBuilder(60);
        sb.append(group.getName());
        if (Globals.prefs.getBoolean("groupShowNumberOfElements") && JabRefGUI.getMainFrame() != null && (currentBasePanel = JabRefGUI.getMainFrame().getCurrentBasePanel()) != null) {
            sb.append(" [").append(this.node.numberOfHits(currentBasePanel.getDatabase().getEntries())).append(']');
        }
        return sb.toString();
    }

    public String getDescription() {
        AbstractGroup group = this.node.getGroup();
        String shortDescription = "";
        boolean showDynamic = Globals.prefs.getBoolean("groupShowDynamic");
        shortDescription = group instanceof ExplicitGroup ? GroupDescriptions.getShortDescriptionExplicitGroup((ExplicitGroup)group) : (group instanceof KeywordGroup ? GroupDescriptions.getShortDescriptionKeywordGroup((KeywordGroup)group, showDynamic) : (group instanceof SearchGroup ? GroupDescriptions.getShortDescription((SearchGroup)group, showDynamic) : GroupDescriptions.getShortDescriptionAllEntriesGroup()));
        return "<html>" + shortDescription + "</html>";
    }

    public Icon getIcon() {
        if (Globals.prefs.getBoolean("groupShowIcons")) {
            switch (this.node.getGroup().getHierarchicalContext()) {
                case REFINING: {
                    return GROUP_REFINING_ICON;
                }
                case INCLUDING: {
                    return GROUP_INCLUDING_ICON;
                }
            }
            return GROUP_REGULAR_ICON;
        }
        return null;
    }

    public TreePath getTreePath() {
        List pathToNode = this.node.getPathFromRoot();
        return new TreePath(pathToNode.stream().map(GroupTreeNodeViewModel::new).toArray());
    }

    public boolean canAddEntries(List<BibEntry> entries) {
        return this.getNode().getGroup().supportsAdd() && !this.getNode().getGroup().containsAll(entries);
    }

    public boolean canRemoveEntries(List<BibEntry> entries) {
        return this.getNode().getGroup().supportsRemove() && this.getNode().getGroup().containsAny(entries);
    }

    public void sortChildrenByName(boolean recursive) {
        this.getNode().sortChildren((node1, node2) -> node1.getGroup().getName().compareToIgnoreCase(node2.getGroup().getName()), recursive);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupTreeNodeViewModel viewModel = (GroupTreeNodeViewModel)o;
        return this.node.equals(viewModel.node);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String getName() {
        return this.getNode().getGroup().getName();
    }

    public boolean canBeEdited() {
        return this.getNode().getGroup() instanceof AllEntriesGroup;
    }

    public boolean canMoveUp() {
        return this.getNode().getPreviousSibling() != null && !(this.getNode().getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveDown() {
        return this.getNode().getNextSibling() != null && !(this.getNode().getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveLeft() {
        return !(this.getNode().getGroup() instanceof AllEntriesGroup) && !(((GroupTreeNode)this.getNode().getParent().get()).getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveRight() {
        return this.getNode().getPreviousSibling() != null && !(this.getNode().getGroup() instanceof AllEntriesGroup);
    }

    public void changeEntriesTo(List<BibEntry> entries, UndoManager undoManager) {
        AbstractGroup group = this.node.getGroup();
        Optional<Object> changesRemove = Optional.empty();
        Optional<Object> changesAdd = Optional.empty();
        ArrayList<BibEntry> toRemove = new ArrayList<BibEntry>(entries.size());
        ArrayList<BibEntry> toAdd = new ArrayList<BibEntry>(entries.size());
        for (BibEntry entry : entries) {
            if (group.contains(entry)) {
                toRemove.add(entry);
                continue;
            }
            toAdd.add(entry);
        }
        if (!toRemove.isEmpty()) {
            changesRemove = this.removeEntriesFromGroup(toRemove);
        }
        if (!toAdd.isEmpty()) {
            changesAdd = this.addEntriesToGroup(toAdd);
        }
        if (changesRemove.isPresent()) {
            AbstractUndoableEdit undoRemove = UndoableChangeEntriesOfGroup.getUndoableEdit(this, (EntriesGroupChange)changesRemove.get());
            if (changesAdd.isPresent() && undoRemove != null) {
                undoRemove.addEdit(UndoableChangeEntriesOfGroup.getUndoableEdit(this, (EntriesGroupChange)changesAdd.get()));
            }
            undoManager.addEdit(undoRemove);
        } else if (changesAdd.isPresent()) {
            undoManager.addEdit(UndoableChangeEntriesOfGroup.getUndoableEdit(this, (EntriesGroupChange)changesAdd.get()));
        }
    }

    public boolean isAllEntriesGroup() {
        return this.getNode().getGroup() instanceof AllEntriesGroup;
    }

    public void addNewGroup(AbstractGroup newGroup, CountingUndoManager undoManager) {
        GroupTreeNode newNode = GroupTreeNode.fromGroup(newGroup);
        this.getNode().addChild(newNode);
        UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(this, new GroupTreeNodeViewModel(newNode), 0);
        undoManager.addEdit(undo);
    }

    public Optional<MoveGroupChange> moveUp() {
        GroupTreeNode parent = (GroupTreeNode)this.node.getParent().get();
        int index = parent.getIndexOfChild(this.getNode()).get();
        if (index > 0) {
            this.getNode().moveTo(parent, index - 1);
            return Optional.of(new MoveGroupChange(parent, index, parent, index - 1));
        }
        return Optional.empty();
    }

    public Optional<MoveGroupChange> moveDown() {
        GroupTreeNode parent = (GroupTreeNode)this.node.getParent().get();
        int index = parent.getIndexOfChild(this.node).get();
        if (index < parent.getNumberOfChildren() - 1) {
            this.node.moveTo(parent, index + 1);
            return Optional.of(new MoveGroupChange(parent, index, parent, index + 1));
        }
        return Optional.empty();
    }

    public Optional<MoveGroupChange> moveLeft() {
        GroupTreeNode parent = (GroupTreeNode)this.node.getParent().get();
        Optional grandParent = parent.getParent();
        int index = this.node.getPositionInParent();
        if (!grandParent.isPresent()) {
            return Optional.empty();
        }
        int indexOfParent = ((GroupTreeNode)grandParent.get()).getIndexOfChild(parent).get();
        this.node.moveTo((GroupTreeNode)grandParent.get(), indexOfParent + 1);
        return Optional.of(new MoveGroupChange(parent, index, (GroupTreeNode)grandParent.get(), indexOfParent + 1));
    }

    public Optional<MoveGroupChange> moveRight() {
        GroupTreeNode previousSibling = (GroupTreeNode)this.node.getPreviousSibling().get();
        GroupTreeNode parent = (GroupTreeNode)this.node.getParent().get();
        int index = this.node.getPositionInParent();
        if (previousSibling == null) {
            return Optional.empty();
        }
        this.node.moveTo(previousSibling);
        return Optional.of(new MoveGroupChange(parent, index, previousSibling, previousSibling.getNumberOfChildren()));
    }

    public Optional<EntriesGroupChange> addEntriesToGroup(List<BibEntry> entries) {
        if (this.node.getGroup().supportsAdd()) {
            return this.node.getGroup().add(entries);
        }
        return Optional.empty();
    }

    public Optional<EntriesGroupChange> removeEntriesFromGroup(List<BibEntry> entries) {
        if (this.node.getGroup().supportsRemove()) {
            return this.node.getGroup().remove(entries);
        }
        return Optional.empty();
    }

    public void subscribeToDescendantChanged(Consumer<GroupTreeNodeViewModel> subscriber) {
        this.getNode().subscribeToDescendantChanged((T node) -> subscriber.accept(new GroupTreeNodeViewModel((GroupTreeNode)node)));
    }

    static {
        DataFlavor df = null;
        try {
            df = new DataFlavor("application/x-java-jvm-local-objectref;class=" + GroupTreeNode.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Creating DataFlavor failed. This should not happen.", e);
        }
        FLAVOR = df;
        FLAVORS = new DataFlavor[]{FLAVOR};
    }
}

