/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.IconTheme;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.SidePaneComponent;
import net.sf.jabref.gui.SidePaneManager;
import net.sf.jabref.gui.groups.AddToGroupAction;
import net.sf.jabref.gui.groups.AutoGroupDialog;
import net.sf.jabref.gui.groups.GroupDialog;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.groups.GroupsTree;
import net.sf.jabref.gui.groups.RemoveFromGroupAction;
import net.sf.jabref.gui.groups.UndoableAddOrRemoveGroup;
import net.sf.jabref.gui.groups.UndoableChangeEntriesOfGroup;
import net.sf.jabref.gui.groups.UndoableModifyGroup;
import net.sf.jabref.gui.groups.UndoableModifySubtree;
import net.sf.jabref.gui.groups.UndoableMoveGroup;
import net.sf.jabref.gui.groups.WarnAssignmentSideEffects;
import net.sf.jabref.gui.help.HelpAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.maintable.MainTableDataModel;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.gui.worker.AbstractWorker;
import net.sf.jabref.logic.help.HelpFile;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.AllEntriesGroup;
import net.sf.jabref.model.groups.EntriesGroupChange;
import net.sf.jabref.model.groups.GroupTreeNode;
import net.sf.jabref.model.groups.MoveGroupChange;
import net.sf.jabref.model.groups.event.GroupUpdatedEvent;
import net.sf.jabref.model.metadata.MetaData;
import net.sf.jabref.model.search.SearchMatcher;
import net.sf.jabref.model.search.matchers.MatcherSet;
import net.sf.jabref.model.search.matchers.MatcherSets;
import net.sf.jabref.model.search.matchers.NotMatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupSelector
extends SidePaneComponent
implements TreeSelectionListener {
    private static final Log LOGGER = LogFactory.getLog(GroupSelector.class);
    private final GroupsTree groupsTree;
    private DefaultTreeModel groupsTreeModel;
    private GroupTreeNodeViewModel groupsRoot;
    protected final JabRefFrame frame;
    private final JPopupMenu groupsContextMenu = new JPopupMenu();
    private final JPopupMenu settings = new JPopupMenu();
    private final JRadioButtonMenuItem hideNonHits;
    private final JRadioButtonMenuItem grayOut;
    private final JRadioButtonMenuItem andCb = new JRadioButtonMenuItem(Localization.lang("Intersection", new String[0]), true);
    private final JRadioButtonMenuItem floatCb = new JRadioButtonMenuItem(Localization.lang("Float", new String[0]), true);
    private final JCheckBoxMenuItem invCb = new JCheckBoxMenuItem(Localization.lang("Inverted", new String[0]), false);
    private final JCheckBoxMenuItem showOverlappingGroups = new JCheckBoxMenuItem(Localization.lang("Highlight overlapping groups", new String[0]));
    private final JCheckBoxMenuItem showNumberOfElements = new JCheckBoxMenuItem(Localization.lang("Show number of elements contained in each group", new String[0]));
    private final JCheckBoxMenuItem autoAssignGroup = new JCheckBoxMenuItem(Localization.lang("Automatically assign new entry to selected groups", new String[0]));
    private final JCheckBoxMenuItem editModeCb = new JCheckBoxMenuItem(Localization.lang("Edit group membership", new String[0]), false);
    private boolean editModeIndicator;
    private static final String MOVE_ONE_GROUP = Localization.lang("Please select exactly one group to move.", new String[0]);
    private final JMenu moveSubmenu = new JMenu(Localization.lang("Move", new String[0]));
    private final JMenu sortSubmenu = new JMenu(Localization.lang("Sort alphabetically", new String[0]));
    private final AbstractAction editGroupAction = new EditGroupAction();
    private final NodeAction editGroupPopupAction = new EditGroupAction();
    private final NodeAction addGroupPopupAction = new AddGroupAction();
    private final NodeAction addSubgroupPopupAction = new AddSubgroupAction();
    private final NodeAction removeGroupAndSubgroupsPopupAction = new RemoveGroupAndSubgroupsAction();
    private final NodeAction removeSubgroupsPopupAction = new RemoveSubgroupsAction();
    private final NodeAction removeGroupKeepSubgroupsPopupAction = new RemoveGroupKeepSubgroupsAction();
    private final NodeAction moveNodeUpPopupAction = new MoveNodeUpAction();
    private final NodeAction moveNodeDownPopupAction = new MoveNodeDownAction();
    private final NodeAction moveNodeLeftPopupAction = new MoveNodeLeftAction();
    private final NodeAction moveNodeRightPopupAction = new MoveNodeRightAction();
    private final NodeAction expandSubtreePopupAction = new ExpandSubtreeAction();
    private final NodeAction collapseSubtreePopupAction = new CollapseSubtreeAction();
    private final NodeAction sortDirectSubgroupsPopupAction = new SortDirectSubgroupsAction();
    private final NodeAction sortAllSubgroupsPopupAction = new SortAllSubgroupsAction();
    private final AddToGroupAction addToGroup = new AddToGroupAction(false);
    private final AddToGroupAction moveToGroup = new AddToGroupAction(true);
    private final RemoveFromGroupAction removeFromGroup = new RemoveFromGroupAction();
    private SidePaneComponent.ToggleAction toggleAction = (SidePaneComponent)this.new SidePaneComponent.ToggleAction(Localization.menuTitle("Toggle groups interface", new String[0]), Localization.lang("Toggle groups interface", new String[0]), Globals.getKeyPrefs().getKey(KeyBinding.TOGGLE_GROUPS_INTERFACE), IconTheme.JabRefIcon.TOGGLE_GROUPS);

    public GroupSelector(JabRefFrame frame, SidePaneManager manager) {
        super(manager, IconTheme.JabRefIcon.TOGGLE_GROUPS.getIcon(), Localization.lang("Groups", new String[0]));
        this.frame = frame;
        this.hideNonHits = new JRadioButtonMenuItem(Localization.lang("Hide non-hits", new String[0]), !Globals.prefs.getBoolean("grayOutNonHits"));
        this.grayOut = new JRadioButtonMenuItem(Localization.lang("Gray out non-hits", new String[0]), Globals.prefs.getBoolean("grayOutNonHits"));
        ButtonGroup nonHits = new ButtonGroup();
        nonHits.add(this.hideNonHits);
        nonHits.add(this.grayOut);
        this.floatCb.addChangeListener(event -> Globals.prefs.putBoolean("groupFloatSelections", this.floatCb.isSelected()));
        this.andCb.addChangeListener(event -> Globals.prefs.putBoolean("groupIntersectSelections", this.andCb.isSelected()));
        this.invCb.addChangeListener(event -> Globals.prefs.putBoolean("groupInvertSelections", this.invCb.isSelected()));
        this.showOverlappingGroups.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                Globals.prefs.putBoolean("groupShowOverlapping", GroupSelector.this.showOverlappingGroups.isSelected());
                if (!GroupSelector.this.showOverlappingGroups.isSelected()) {
                    GroupSelector.this.groupsTree.setOverlappingGroups(Collections.emptyList());
                }
            }
        });
        this.grayOut.addChangeListener(event -> Globals.prefs.putBoolean("grayOutNonHits", this.grayOut.isSelected()));
        JRadioButtonMenuItem highlCb = new JRadioButtonMenuItem(Localization.lang("Highlight", new String[0]), false);
        if (Globals.prefs.getBoolean("groupFloatSelections")) {
            this.floatCb.setSelected(true);
            highlCb.setSelected(false);
        } else {
            highlCb.setSelected(true);
            this.floatCb.setSelected(false);
        }
        JRadioButtonMenuItem orCb = new JRadioButtonMenuItem(Localization.lang("Union", new String[0]), false);
        if (Globals.prefs.getBoolean("groupIntersectSelections")) {
            this.andCb.setSelected(true);
            orCb.setSelected(false);
        } else {
            orCb.setSelected(true);
            this.andCb.setSelected(false);
        }
        this.showNumberOfElements.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Globals.prefs.putBoolean("groupShowNumberOfElements", GroupSelector.this.showNumberOfElements.isSelected());
                if (GroupSelector.this.groupsTree != null) {
                    GroupSelector.this.groupsTree.invalidate();
                    GroupSelector.this.groupsTree.repaint();
                }
            }
        });
        this.autoAssignGroup.addChangeListener(event -> Globals.prefs.putBoolean("autoAssignGroup", this.autoAssignGroup.isSelected()));
        this.invCb.setSelected(Globals.prefs.getBoolean("groupInvertSelections"));
        this.showOverlappingGroups.setSelected(Globals.prefs.getBoolean("groupShowOverlapping"));
        this.editModeIndicator = Globals.prefs.getBoolean("groupEditGroupMembershipMode");
        this.editModeCb.setSelected(this.editModeIndicator);
        this.showNumberOfElements.setSelected(Globals.prefs.getBoolean("groupShowNumberOfElements"));
        this.autoAssignGroup.setSelected(Globals.prefs.getBoolean("autoAssignGroup"));
        JButton openSettings = new JButton(IconTheme.JabRefIcon.PREFERENCES.getSmallIcon());
        this.settings.add(this.andCb);
        this.settings.add(orCb);
        this.settings.addSeparator();
        this.settings.add(this.invCb);
        this.settings.addSeparator();
        this.settings.add(this.editModeCb);
        this.settings.addSeparator();
        this.settings.add(this.grayOut);
        this.settings.add(this.hideNonHits);
        this.settings.addSeparator();
        this.settings.add(this.showOverlappingGroups);
        this.settings.addSeparator();
        this.settings.add(this.showNumberOfElements);
        this.settings.add(this.autoAssignGroup);
        openSettings.addActionListener(e -> {
            if (!this.settings.isVisible()) {
                JButton src = (JButton)e.getSource();
                this.showNumberOfElements.setSelected(Globals.prefs.getBoolean("groupShowNumberOfElements"));
                this.autoAssignGroup.setSelected(Globals.prefs.getBoolean("autoAssignGroup"));
                this.settings.show(src, 0, openSettings.getHeight());
            }
        });
        this.editModeCb.addActionListener(e -> this.setEditMode(this.editModeCb.getState()));
        JButton newButton = new JButton(IconTheme.JabRefIcon.ADD_NOBOX.getSmallIcon());
        int butSize = newButton.getIcon().getIconHeight() + 5;
        Dimension butDim = new Dimension(butSize, butSize);
        newButton.setPreferredSize(butDim);
        newButton.setMinimumSize(butDim);
        JButton helpButton = new HelpAction(Localization.lang("Help on groups", new String[0]), HelpFile.GROUP).getHelpButton();
        helpButton.setPreferredSize(butDim);
        helpButton.setMinimumSize(butDim);
        JButton autoGroup = new JButton(IconTheme.JabRefIcon.AUTO_GROUP.getSmallIcon());
        autoGroup.setPreferredSize(butDim);
        autoGroup.setMinimumSize(butDim);
        openSettings.setPreferredSize(butDim);
        openSettings.setMinimumSize(butDim);
        Insets butIns = new Insets(0, 0, 0, 0);
        helpButton.setMargin(butIns);
        openSettings.setMargin(butIns);
        newButton.addActionListener(e -> {
            GroupDialog gd = new GroupDialog(frame, null);
            gd.setVisible(true);
            if (gd.okPressed()) {
                AbstractGroup newGroup = gd.getResultingGroup();
                this.groupsRoot.addNewGroup(newGroup, this.panel.getUndoManager());
                this.panel.markBaseChanged();
                frame.output(Localization.lang("Created group \"%0\".", newGroup.getName()));
            }
        });
        this.andCb.addActionListener(e -> this.valueChanged(null));
        orCb.addActionListener(e -> this.valueChanged(null));
        this.invCb.addActionListener(e -> this.valueChanged(null));
        this.showOverlappingGroups.addActionListener(e -> this.valueChanged(null));
        autoGroup.addActionListener(e -> {
            AutoGroupDialog gd = new AutoGroupDialog(frame, this.panel, this.groupsRoot, Globals.prefs.get("groupsDefaultField"), " .,", Globals.prefs.get("groupKeywordSeparator"));
            gd.setVisible(true);
        });
        this.floatCb.addActionListener(e -> this.valueChanged(null));
        highlCb.addActionListener(e -> this.valueChanged(null));
        this.hideNonHits.addActionListener(e -> this.valueChanged(null));
        this.grayOut.addActionListener(e -> this.valueChanged(null));
        newButton.setToolTipText(Localization.lang("New group", new String[0]));
        this.andCb.setToolTipText(Localization.lang("Display only entries belonging to all selected groups.", new String[0]));
        orCb.setToolTipText(Localization.lang("Display all entries belonging to one or more of the selected groups.", new String[0]));
        autoGroup.setToolTipText(Localization.lang("Automatically create groups for database.", new String[0]));
        openSettings.setToolTipText(Localization.lang("Settings", new String[0]));
        this.invCb.setToolTipText("<html>" + Localization.lang("Show entries <b>not</b> in group selection", new String[0]) + "</html>");
        this.showOverlappingGroups.setToolTipText(Localization.lang("Highlight groups that contain entries contained in any currently selected group", new String[0]));
        this.floatCb.setToolTipText(Localization.lang("Move entries in group selection to the top", new String[0]));
        highlCb.setToolTipText(Localization.lang("Gray out entries not in group selection", new String[0]));
        this.editModeCb.setToolTipText(Localization.lang("Click group to toggle membership of selected entries", new String[0]));
        ButtonGroup bgr = new ButtonGroup();
        bgr.add(this.andCb);
        bgr.add(orCb);
        ButtonGroup visMode = new ButtonGroup();
        visMode.add(this.floatCb);
        visMode.add(highlCb);
        JPanel rootPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        rootPanel.setLayout(gbl);
        GridBagConstraints con = new GridBagConstraints();
        con.fill = 1;
        con.weightx = 1.0;
        con.gridwidth = 1;
        con.gridy = 0;
        con.gridx = 0;
        gbl.setConstraints(newButton, con);
        rootPanel.add(newButton);
        con.gridx = 1;
        gbl.setConstraints(autoGroup, con);
        rootPanel.add(autoGroup);
        con.gridx = 2;
        gbl.setConstraints(openSettings, con);
        rootPanel.add(openSettings);
        con.gridx = 3;
        con.gridwidth = 0;
        gbl.setConstraints(helpButton, con);
        rootPanel.add(helpButton);
        this.groupsTree = new GroupsTree(this);
        this.groupsTree.addTreeSelectionListener(this);
        JScrollPane groupsTreePane = new JScrollPane(this.groupsTree, 20, 30);
        groupsTreePane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        con.gridwidth = 0;
        con.weighty = 1.0;
        con.gridx = 0;
        con.gridwidth = 4;
        con.gridy = 1;
        gbl.setConstraints(groupsTreePane, con);
        rootPanel.add(groupsTreePane);
        this.add((Component)rootPanel, "Center");
        this.setEditMode(this.editModeIndicator);
        this.definePopup();
        MoveNodeUpAction moveNodeUpAction = new MoveNodeUpAction();
        moveNodeUpAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 2));
        MoveNodeDownAction moveNodeDownAction = new MoveNodeDownAction();
        moveNodeDownAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 2));
        MoveNodeLeftAction moveNodeLeftAction = new MoveNodeLeftAction();
        moveNodeLeftAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 2));
        MoveNodeRightAction moveNodeRightAction = new MoveNodeRightAction();
        moveNodeRightAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 2));
        this.setGroups(GroupTreeNode.fromGroup(new AllEntriesGroup(Localization.lang("All entries", new String[0]))));
    }

    private void definePopup() {
        this.groupsContextMenu.add(this.editGroupPopupAction);
        this.groupsContextMenu.add(this.addGroupPopupAction);
        this.groupsContextMenu.add(this.addSubgroupPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.removeGroupAndSubgroupsPopupAction);
        this.groupsContextMenu.add(this.removeGroupKeepSubgroupsPopupAction);
        this.groupsContextMenu.add(this.removeSubgroupsPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.expandSubtreePopupAction);
        this.groupsContextMenu.add(this.collapseSubtreePopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.moveSubmenu);
        this.sortSubmenu.add(this.sortDirectSubgroupsPopupAction);
        this.sortSubmenu.add(this.sortAllSubgroupsPopupAction);
        this.groupsContextMenu.add(this.sortSubmenu);
        this.moveSubmenu.add(this.moveNodeUpPopupAction);
        this.moveSubmenu.add(this.moveNodeDownPopupAction);
        this.moveSubmenu.add(this.moveNodeLeftPopupAction);
        this.moveSubmenu.add(this.moveNodeRightPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.addToGroup);
        this.groupsContextMenu.add(this.moveToGroup);
        this.groupsContextMenu.add(this.removeFromGroup);
        this.groupsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GroupSelector.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    GroupSelector.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = GroupSelector.this.groupsTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
                if (path == null) {
                    return;
                }
                GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)path.getLastPathComponent();
                if (node.getNode().isRoot()) {
                    return;
                }
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    GroupSelector.this.editGroupAction.actionPerformed(null);
                } else if (e.getClickCount() == 1 && e.getButton() == 1) {
                    GroupSelector.this.annotationEvent(node);
                }
            }
        });
        this.groupsContextMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GroupSelector.this.groupsTree.setHighlightBorderCell(null);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                GroupSelector.this.groupsTree.setHighlightBorderCell(null);
            }
        });
    }

    private void showPopup(MouseEvent e) {
        TreePath path = this.groupsTree.getPathForLocation(e.getPoint().x, e.getPoint().y);
        this.addGroupPopupAction.setEnabled(true);
        this.addSubgroupPopupAction.setEnabled(path != null);
        this.editGroupPopupAction.setEnabled(path != null);
        this.removeGroupAndSubgroupsPopupAction.setEnabled(path != null);
        this.removeGroupKeepSubgroupsPopupAction.setEnabled(path != null);
        this.moveSubmenu.setEnabled(path != null);
        this.expandSubtreePopupAction.setEnabled(path != null);
        this.collapseSubtreePopupAction.setEnabled(path != null);
        this.removeSubgroupsPopupAction.setEnabled(path != null);
        this.sortSubmenu.setEnabled(path != null);
        this.addToGroup.setEnabled(false);
        this.moveToGroup.setEnabled(false);
        this.removeFromGroup.setEnabled(false);
        if (path != null) {
            GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)path.getLastPathComponent();
            this.editGroupPopupAction.setNode(node);
            this.addSubgroupPopupAction.setNode(node);
            this.removeGroupAndSubgroupsPopupAction.setNode(node);
            this.removeSubgroupsPopupAction.setNode(node);
            this.removeGroupKeepSubgroupsPopupAction.setNode(node);
            this.expandSubtreePopupAction.setNode(node);
            this.collapseSubtreePopupAction.setNode(node);
            this.sortDirectSubgroupsPopupAction.setNode(node);
            this.sortAllSubgroupsPopupAction.setNode(node);
            this.groupsTree.setHighlightBorderCell(node);
            if (node.canBeEdited()) {
                this.editGroupPopupAction.setEnabled(false);
                this.addGroupPopupAction.setEnabled(false);
                this.removeGroupAndSubgroupsPopupAction.setEnabled(false);
                this.removeGroupKeepSubgroupsPopupAction.setEnabled(false);
            } else {
                this.editGroupPopupAction.setEnabled(true);
                this.addGroupPopupAction.setEnabled(true);
                this.addGroupPopupAction.setNode(node);
                this.removeGroupAndSubgroupsPopupAction.setEnabled(true);
                this.removeGroupKeepSubgroupsPopupAction.setEnabled(true);
            }
            this.expandSubtreePopupAction.setEnabled(this.groupsTree.isCollapsed(path) || this.groupsTree.hasCollapsedDescendant(path));
            this.collapseSubtreePopupAction.setEnabled(this.groupsTree.isExpanded(path) || this.groupsTree.hasExpandedDescendant(path));
            this.sortSubmenu.setEnabled(!node.isLeaf());
            this.removeSubgroupsPopupAction.setEnabled(!node.isLeaf());
            this.moveNodeUpPopupAction.setEnabled(node.canMoveUp());
            this.moveNodeDownPopupAction.setEnabled(node.canMoveDown());
            this.moveNodeLeftPopupAction.setEnabled(node.canMoveLeft());
            this.moveNodeRightPopupAction.setEnabled(node.canMoveRight());
            this.moveSubmenu.setEnabled(this.moveNodeUpPopupAction.isEnabled() || this.moveNodeDownPopupAction.isEnabled() || this.moveNodeLeftPopupAction.isEnabled() || this.moveNodeRightPopupAction.isEnabled());
            this.moveNodeUpPopupAction.setNode(node);
            this.moveNodeDownPopupAction.setNode(node);
            this.moveNodeLeftPopupAction.setNode(node);
            this.moveNodeRightPopupAction.setNode(node);
            List<BibEntry> selection = this.frame.getCurrentBasePanel().getSelectedEntries();
            if (!selection.isEmpty()) {
                if (node.canAddEntries(selection)) {
                    this.addToGroup.setNode(node);
                    this.addToGroup.setBasePanel(this.panel);
                    this.addToGroup.setEnabled(true);
                    this.moveToGroup.setNode(node);
                    this.moveToGroup.setBasePanel(this.panel);
                    this.moveToGroup.setEnabled(true);
                }
                if (node.canRemoveEntries(selection)) {
                    this.removeFromGroup.setNode(node);
                    this.removeFromGroup.setBasePanel(this.panel);
                    this.removeFromGroup.setEnabled(true);
                }
            }
        } else {
            this.editGroupPopupAction.setNode(null);
            this.addGroupPopupAction.setNode(null);
            this.addSubgroupPopupAction.setNode(null);
            this.removeGroupAndSubgroupsPopupAction.setNode(null);
            this.removeSubgroupsPopupAction.setNode(null);
            this.removeGroupKeepSubgroupsPopupAction.setNode(null);
            this.moveNodeUpPopupAction.setNode(null);
            this.moveNodeDownPopupAction.setNode(null);
            this.moveNodeLeftPopupAction.setNode(null);
            this.moveNodeRightPopupAction.setNode(null);
            this.expandSubtreePopupAction.setNode(null);
            this.collapseSubtreePopupAction.setNode(null);
            this.sortDirectSubgroupsPopupAction.setNode(null);
            this.sortAllSubgroupsPopupAction.setNode(null);
        }
        this.groupsContextMenu.show(this.groupsTree, e.getPoint().x, e.getPoint().y);
    }

    private void setEditMode(boolean editMode) {
        Globals.prefs.putBoolean("groupEditGroupMembershipMode", this.editModeIndicator);
        this.editModeIndicator = editMode;
        if (editMode) {
            this.groupsTree.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.RED), "Edit mode", 3, 2, Font.getFont("Default"), Color.RED));
            this.setTitle("<html><font color='red'>Groups Edit mode</font></html>");
        } else {
            this.groupsTree.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 0));
            this.setTitle(Localization.lang("Groups", new String[0]));
        }
        this.groupsTree.revalidate();
        this.groupsTree.repaint();
    }

    private void annotationEvent(GroupTreeNodeViewModel node) {
        if (this.editModeIndicator) {
            LOGGER.info("Performing annotation " + node.getName());
            List<BibEntry> entries = this.panel.getSelectedEntries();
            node.changeEntriesTo(entries, this.panel.getUndoManager());
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
            this.updateShownEntriesAccordingToSelectedGroups();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.panel == null) {
            return;
        }
        if (this.getLeafsOfSelection().stream().allMatch(GroupTreeNodeViewModel::isAllEntriesGroup)) {
            this.panel.getMainTable().getTableModel().updateGroupingState(MainTableDataModel.DisplayOption.DISABLED);
            if (this.showOverlappingGroups.isSelected()) {
                this.groupsTree.setOverlappingGroups(Collections.emptyList());
            }
            this.frame.output(Localization.lang("Displaying no groups", new String[0]) + ".");
            return;
        }
        if (!this.editModeIndicator) {
            this.updateShownEntriesAccordingToSelectedGroups();
        }
    }

    private void updateShownEntriesAccordingToSelectedGroups() {
        MatcherSet searchRules = MatcherSets.build(this.andCb.isSelected() ? MatcherSets.MatcherType.AND : MatcherSets.MatcherType.OR);
        for (GroupTreeNodeViewModel node : this.getLeafsOfSelection()) {
            SearchMatcher searchRule = node.getNode().getSearchRule();
            searchRules.addRule(searchRule);
        }
        SearchMatcher searchRule = this.invCb.isSelected() ? new NotMatcher(searchRules) : searchRules;
        GroupingWorker worker = new GroupingWorker(searchRule);
        worker.getWorker().run();
        worker.getCallBack().update();
    }

    private List<GroupTreeNodeViewModel> getLeafsOfSelection() {
        TreePath[] selection = this.groupsTree.getSelectionPaths();
        if (selection == null || selection.length == 0) {
            return new ArrayList<GroupTreeNodeViewModel>();
        }
        ArrayList<GroupTreeNodeViewModel> selectedLeafs = new ArrayList<GroupTreeNodeViewModel>(selection.length);
        for (TreePath path : selection) {
            selectedLeafs.add((GroupTreeNodeViewModel)path.getLastPathComponent());
        }
        return selectedLeafs;
    }

    private GroupTreeNodeViewModel getFirstSelectedNode() {
        TreePath path = this.groupsTree.getSelectionPath();
        if (path != null) {
            return (GroupTreeNodeViewModel)path.getLastPathComponent();
        }
        return null;
    }

    public void revalidateGroups() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.revalidateGroups(null);
        } else {
            SwingUtilities.invokeLater(() -> this.revalidateGroups(null));
        }
    }

    private void revalidateGroups(GroupTreeNodeViewModel node) {
        this.revalidateGroups(this.groupsTree.getSelectionPaths(), this.getExpandedPaths(), node);
    }

    public void revalidateGroups(TreePath[] selectionPaths, Enumeration<TreePath> expandedNodes) {
        this.revalidateGroups(selectionPaths, expandedNodes, null);
    }

    private void revalidateGroups(TreePath[] selectionPaths, Enumeration<TreePath> expandedNodes, GroupTreeNodeViewModel node) {
        this.groupsTree.clearSelection();
        if (selectionPaths != null) {
            this.groupsTree.setSelectionPaths(selectionPaths);
        }
        if (expandedNodes != null) {
            while (expandedNodes.hasMoreElements()) {
                this.groupsTree.expandPath(expandedNodes.nextElement());
            }
        }
        this.groupsTree.revalidate();
        if (node != null) {
            this.groupsTree.scrollPathToVisible(node.getTreePath());
        }
    }

    @Override
    public void componentOpening() {
        this.valueChanged(null);
        Globals.prefs.putBoolean("groupSidepaneVisible", Boolean.TRUE);
    }

    @Override
    public int getRescalingWeight() {
        return 1;
    }

    @Override
    public void componentClosing() {
        if (this.panel != null) {
            this.panel.getMainTable().getTableModel().updateGroupingState(MainTableDataModel.DisplayOption.DISABLED);
        }
        this.getToggleAction().setSelected(false);
        Globals.prefs.putBoolean("groupSidepaneVisible", Boolean.FALSE);
    }

    private void setGroups(GroupTreeNode groupsRoot) {
        this.groupsRoot = new GroupTreeNodeViewModel(groupsRoot);
        this.groupsTreeModel = new DefaultTreeModel(this.groupsRoot);
        this.groupsRoot.subscribeToDescendantChanged(this.groupsTreeModel::nodeStructureChanged);
        this.groupsTree.setModel(this.groupsTreeModel);
        if (Globals.prefs.getBoolean("groupExpandTree")) {
            this.groupsRoot.expandSubtree(this.groupsTree);
        }
    }

    public void addGroups(GroupTreeNode newGroups, CompoundEdit ce) {
        if (newGroups.getGroup() instanceof AllEntriesGroup) {
            return;
        }
        newGroups.moveTo(this.groupsRoot.getNode());
        UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(this.groupsRoot, new GroupTreeNodeViewModel(newGroups), 0);
        ce.addEdit(undo);
    }

    public TreePath getSelectionPath() {
        return this.groupsTree.getSelectionPath();
    }

    public boolean moveNodeUp(GroupTreeNodeViewModel node, boolean checkSingleSelection) {
        Optional<MoveGroupChange> moveChange;
        if (checkSingleSelection && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(MOVE_ONE_GROUP);
            return false;
        }
        if (!node.canMoveUp() || !(moveChange = node.moveUp()).isPresent()) {
            this.frame.output(Localization.lang("Cannot move group \"%0\" up.", node.getNode().getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(moveChange.get(), node);
        return true;
    }

    public boolean moveNodeDown(GroupTreeNodeViewModel node, boolean checkSingleSelection) {
        Optional<MoveGroupChange> moveChange;
        if (checkSingleSelection && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(MOVE_ONE_GROUP);
            return false;
        }
        if (!node.canMoveDown() || !(moveChange = node.moveDown()).isPresent()) {
            this.frame.output(Localization.lang("Cannot move group \"%0\" down.", node.getNode().getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(moveChange.get(), node);
        return true;
    }

    public boolean moveNodeLeft(GroupTreeNodeViewModel node, boolean checkSingleSelection) {
        Optional<MoveGroupChange> moveChange;
        if (checkSingleSelection && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(MOVE_ONE_GROUP);
            return false;
        }
        if (!node.canMoveLeft() || !(moveChange = node.moveLeft()).isPresent()) {
            this.frame.output(Localization.lang("Cannot move group \"%0\" left.", node.getNode().getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(moveChange.get(), node);
        return true;
    }

    public boolean moveNodeRight(GroupTreeNodeViewModel node, boolean checkSingleSelection) {
        Optional<MoveGroupChange> moveChange;
        if (checkSingleSelection && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(MOVE_ONE_GROUP);
            return false;
        }
        if (!node.canMoveRight() || !(moveChange = node.moveRight()).isPresent()) {
            this.frame.output(Localization.lang("Cannot move group \"%0\" right.", node.getNode().getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(moveChange.get(), node);
        return true;
    }

    public void concludeMoveGroup(MoveGroupChange moveChange, GroupTreeNodeViewModel node) {
        this.panel.getUndoManager().addEdit(new UndoableMoveGroup(this.groupsRoot, moveChange));
        this.panel.markBaseChanged();
        this.frame.output(Localization.lang("Moved group \"%0\".", node.getNode().getGroup().getName()));
    }

    public void concludeAssignment(AbstractUndoableEdit undo, GroupTreeNode node, int assignedEntries) {
        if (undo == null) {
            this.frame.output(Localization.lang("The group \"%0\" already contains the selection.", node.getGroup().getName()));
            return;
        }
        this.panel.getUndoManager().addEdit(undo);
        this.panel.markBaseChanged();
        this.panel.updateEntryEditorIfShowing();
        String groupName = node.getGroup().getName();
        if (assignedEntries == 1) {
            this.frame.output(Localization.lang("Assigned 1 entry to group \"%0\".", groupName));
        } else {
            this.frame.output(Localization.lang("Assigned %0 entries to group \"%1\".", String.valueOf(assignedEntries), groupName));
        }
    }

    public GroupTreeNodeViewModel getGroupTreeRoot() {
        return this.groupsRoot;
    }

    public Enumeration<TreePath> getExpandedPaths() {
        return this.groupsTree.getExpandedDescendants(this.groupsRoot.getTreePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveBasePanel(BasePanel panel) {
        super.setActiveBasePanel(panel);
        if (panel == null) {
            this.frame.getSidePaneManager().hide(GroupSelector.class);
            return;
        }
        MetaData metaData = panel.getBibDatabaseContext().getMetaData();
        if (metaData.getGroups().isPresent()) {
            this.setGroups(metaData.getGroups().get());
        } else {
            GroupTreeNode newGroupsRoot = GroupTreeNode.fromGroup(new AllEntriesGroup(Localization.lang("All entries", new String[0])));
            metaData.setGroups(newGroupsRoot);
            this.setGroups(newGroupsRoot);
        }
        metaData.registerListener(this);
        Object object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
    }

    public void showMatchingGroups(List<BibEntry> list, boolean requireAll) {
        if (list == null || list.isEmpty()) {
            this.groupsTree.setMatchingGroups(Collections.emptyList());
            this.groupsTree.revalidate();
            return;
        }
        List<GroupTreeNode> nodeList = this.groupsRoot.getNode().getContainingGroups(list, requireAll);
        this.groupsTree.setMatchingGroups(nodeList);
        for (GroupTreeNode node : nodeList) {
            node.getParent().ifPresent(parentNode -> this.groupsTree.expandPath(new GroupTreeNodeViewModel((GroupTreeNode)parentNode).getTreePath()));
        }
        this.groupsTree.revalidate();
    }

    private void showOverlappingGroups(List<BibEntry> matches) {
        List<GroupTreeNode> nodes = this.groupsRoot.getNode().getMatchingGroups(matches);
        this.groupsTree.setOverlappingGroups(nodes);
    }

    public GroupsTree getGroupsTree() {
        return this.groupsTree;
    }

    @Subscribe
    public void listen(GroupUpdatedEvent updateEvent) {
        this.setGroups(updateEvent.getMetaData().getGroups().orElse(null));
    }

    @Override
    public void grabFocus() {
        this.groupsTree.grabFocus();
    }

    @Override
    public SidePaneComponent.ToggleAction getToggleAction() {
        return this.toggleAction;
    }

    private class MoveNodeRightAction
    extends NodeAction {
        public MoveNodeRightAction() {
            super(Localization.lang("Right", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            GroupSelector.this.moveNodeRight(node, false);
        }
    }

    private class MoveNodeLeftAction
    extends NodeAction {
        public MoveNodeLeftAction() {
            super(Localization.lang("Left", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            GroupSelector.this.moveNodeLeft(node, false);
        }
    }

    private class MoveNodeDownAction
    extends NodeAction {
        public MoveNodeDownAction() {
            super(Localization.lang("Down", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            GroupSelector.this.moveNodeDown(node, false);
        }
    }

    private class MoveNodeUpAction
    extends NodeAction {
        public MoveNodeUpAction() {
            super(Localization.lang("Up", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            GroupSelector.this.moveNodeUp(node, false);
        }
    }

    private class CollapseSubtreeAction
    extends NodeAction {
        public CollapseSubtreeAction() {
            super(Localization.lang("Collapse subtree", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.getNodeToUse().collapseSubtree(GroupSelector.this.groupsTree);
            GroupSelector.this.revalidateGroups();
        }
    }

    private class ExpandSubtreeAction
    extends NodeAction {
        public ExpandSubtreeAction() {
            super(Localization.lang("Expand subtree", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.getNodeToUse().expandSubtree(GroupSelector.this.groupsTree);
            GroupSelector.this.revalidateGroups();
        }
    }

    private class SortAllSubgroupsAction
    extends NodeAction {
        public SortAllSubgroupsAction() {
            super(Localization.lang("All subgroups (recursively)", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            UndoableModifySubtree undo = new UndoableModifySubtree(GroupSelector.this.getGroupTreeRoot(), node, Localization.lang("sort subgroups", new String[0]));
            GroupSelector.this.groupsTree.sort(node, true);
            GroupSelector.this.panel.getUndoManager().addEdit(undo);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Localization.lang("Sorted all subgroups recursively.", new String[0]));
        }
    }

    private class SortDirectSubgroupsAction
    extends NodeAction {
        public SortDirectSubgroupsAction() {
            super(Localization.lang("Immediate subgroups", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            UndoableModifySubtree undo = new UndoableModifySubtree(GroupSelector.this.getGroupTreeRoot(), node, Localization.lang("sort subgroups", new String[0]));
            GroupSelector.this.groupsTree.sort(node, false);
            GroupSelector.this.panel.getUndoManager().addEdit(undo);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Localization.lang("Sorted immediate subgroups.", new String[0]));
        }
    }

    private class RemoveGroupKeepSubgroupsAction
    extends NodeAction {
        public RemoveGroupKeepSubgroupsAction() {
            super(Localization.lang("Remove group, keep subgroups", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            AbstractGroup group = node.getNode().getGroup();
            int conf = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Localization.lang("Remove group \"%0\"?", group.getName()), Localization.lang("Remove group", new String[0]), 0);
            if (conf == 0) {
                UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(GroupSelector.this.groupsRoot, node, 1);
                GroupTreeNodeViewModel parent = (GroupTreeNodeViewModel)node.getParent();
                node.getNode().removeFromParent();
                node.getNode().moveAllChildrenTo(parent.getNode(), parent.getIndex(node));
                GroupSelector.this.panel.getUndoManager().addEdit(undo);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Localization.lang("Removed group \"%0\".", group.getName()));
            }
        }
    }

    private class RemoveSubgroupsAction
    extends NodeAction {
        public RemoveSubgroupsAction() {
            super(Localization.lang("Remove subgroups", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            int conf = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Localization.lang("Remove all subgroups of \"%0\"?", node.getName()), Localization.lang("Remove subgroups", new String[0]), 0);
            if (conf == 0) {
                UndoableModifySubtree undo = new UndoableModifySubtree(GroupSelector.this.getGroupTreeRoot(), node, "Remove subgroups");
                node.getNode().removeAllChildren();
                GroupSelector.this.panel.getUndoManager().addEdit(undo);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Localization.lang("Removed all subgroups of group \"%0\".", node.getName()));
            }
        }
    }

    private class RemoveGroupAndSubgroupsAction
    extends NodeAction {
        public RemoveGroupAndSubgroupsAction() {
            super(Localization.lang("Remove group and subgroups", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            AbstractGroup group = node.getNode().getGroup();
            int conf = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Localization.lang("Remove group \"%0\" and its subgroups?", group.getName()), Localization.lang("Remove group and subgroups", new String[0]), 0);
            if (conf == 0) {
                UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(GroupSelector.this.groupsRoot, node, 2);
                node.getNode().removeFromParent();
                GroupSelector.this.panel.getUndoManager().addEdit(undo);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Localization.lang("Removed group \"%0\" and its subgroups.", group.getName()));
            }
        }
    }

    private class AddSubgroupAction
    extends NodeAction {
        public AddSubgroupAction() {
            super(Localization.lang("Add subgroup", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupDialog gd = new GroupDialog(GroupSelector.this.frame, null);
            gd.setVisible(true);
            if (!gd.okPressed()) {
                return;
            }
            AbstractGroup newGroup = gd.getResultingGroup();
            GroupTreeNode newNode = GroupTreeNode.fromGroup(newGroup);
            GroupTreeNodeViewModel node = this.getNodeToUse();
            node.getNode().addChild(newNode);
            UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(GroupSelector.this.groupsRoot, new GroupTreeNodeViewModel(newNode), 0);
            GroupSelector.this.groupsTree.expandPath(node.getTreePath());
            GroupSelector.this.panel.getUndoManager().addEdit(undo);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Localization.lang("Added group \"%0\".", newGroup.getName()));
        }
    }

    private class AddGroupAction
    extends NodeAction {
        public AddGroupAction() {
            super(Localization.lang("Add group", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupDialog gd = new GroupDialog(GroupSelector.this.frame, null);
            gd.setVisible(true);
            if (!gd.okPressed()) {
                return;
            }
            AbstractGroup newGroup = gd.getResultingGroup();
            GroupTreeNode newNode = GroupTreeNode.fromGroup(newGroup);
            GroupTreeNodeViewModel node = this.getNodeToUse();
            if (node == null) {
                GroupSelector.this.groupsRoot.getNode().addChild(newNode);
            } else {
                ((GroupTreeNodeViewModel)node.getParent()).getNode().addChild(newNode, node.getNode().getPositionInParent() + 1);
            }
            UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(GroupSelector.this.groupsRoot, new GroupTreeNodeViewModel(newNode), 0);
            GroupSelector.this.groupsTree.expandPath((node == null ? GroupSelector.this.groupsRoot : node).getTreePath());
            GroupSelector.this.panel.getUndoManager().addEdit(undo);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Localization.lang("Added group \"%0\".", newGroup.getName()));
        }
    }

    private class EditGroupAction
    extends NodeAction {
        public EditGroupAction() {
            super(Localization.lang("Edit group", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GroupTreeNodeViewModel node = this.getNodeToUse();
            AbstractGroup oldGroup = node.getNode().getGroup();
            GroupDialog gd = new GroupDialog(GroupSelector.this.frame, oldGroup);
            gd.setVisible(true);
            if (gd.okPressed()) {
                AbstractGroup newGroup = gd.getResultingGroup();
                int i = JOptionPane.showConfirmDialog(GroupSelector.this.panel.frame(), Localization.lang("Assign the original group's entries to this group?", new String[0]), Localization.lang("Change of Grouping Method", new String[0]), 0, 3);
                boolean keepPreviousAssignments = i == 0 && WarnAssignmentSideEffects.warnAssignmentSideEffects(newGroup, (Component)GroupSelector.this.panel.frame());
                AbstractUndoableEdit undoAddPreviousEntries = null;
                UndoableModifyGroup undo = new UndoableModifyGroup(GroupSelector.this, GroupSelector.this.groupsRoot, node, newGroup);
                Optional<EntriesGroupChange> addChange = node.getNode().setGroup(newGroup, keepPreviousAssignments, GroupSelector.this.panel.getDatabase().getEntries());
                if (addChange.isPresent()) {
                    undoAddPreviousEntries = UndoableChangeEntriesOfGroup.getUndoableEdit(null, addChange.get());
                }
                GroupSelector.this.groupsTreeModel.reload();
                GroupSelector.this.revalidateGroups(node);
                if (undoAddPreviousEntries == null) {
                    GroupSelector.this.panel.getUndoManager().addEdit(undo);
                } else {
                    NamedCompound nc = new NamedCompound("Modify Group");
                    nc.addEdit(undo);
                    nc.addEdit(undoAddPreviousEntries);
                    nc.end();
                    GroupSelector.this.panel.getUndoManager().addEdit(nc);
                }
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Localization.lang("Modified group \"%0\".", newGroup.getName()));
            }
        }
    }

    private abstract class NodeAction
    extends AbstractAction {
        private GroupTreeNodeViewModel node;

        public NodeAction(String s) {
            super(s);
        }

        public void setNode(GroupTreeNodeViewModel node) {
            this.node = node;
        }

        public GroupTreeNodeViewModel getNodeToUse() {
            if (this.node != null) {
                return this.node;
            }
            return GroupSelector.this.getFirstSelectedNode();
        }
    }

    class GroupingWorker
    extends AbstractWorker {
        private final SearchMatcher matcher;
        private final List<BibEntry> matches = new ArrayList<BibEntry>();
        private final boolean showOverlappingGroupsP;

        public GroupingWorker(SearchMatcher matcher) {
            this.matcher = matcher;
            this.showOverlappingGroupsP = GroupSelector.this.showOverlappingGroups.isSelected();
        }

        @Override
        public void run() {
            for (BibEntry entry : GroupSelector.this.panel.getDatabase().getEntries()) {
                boolean hit = this.matcher.isMatch(entry);
                entry.setGroupHit(hit);
                if (!hit || !this.showOverlappingGroupsP) continue;
                this.matches.add(entry);
            }
        }

        @Override
        public void update() {
            if (GroupSelector.this.hideNonHits.isSelected()) {
                GroupSelector.this.panel.getMainTable().getTableModel().updateGroupingState(MainTableDataModel.DisplayOption.FILTER);
            } else if (GroupSelector.this.grayOut.isSelected()) {
                GroupSelector.this.panel.getMainTable().getTableModel().updateGroupingState(MainTableDataModel.DisplayOption.FLOAT);
            }
            GroupSelector.this.panel.getMainTable().getTableModel().updateSortOrder();
            GroupSelector.this.panel.getMainTable().getTableModel().updateGroupFilter();
            GroupSelector.this.panel.getMainTable().scrollTo(0);
            if (this.showOverlappingGroupsP) {
                GroupSelector.this.showOverlappingGroups(this.matches);
            }
            GroupSelector.this.frame.output(Localization.lang("Updated group selection", new String[0]) + ".");
        }
    }
}

