/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.fieldeditors.TextField;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.groups.GroupDescriptions;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.search.SearchQuery;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.ExplicitGroup;
import net.sf.jabref.model.groups.GroupHierarchyType;
import net.sf.jabref.model.groups.KeywordGroup;
import net.sf.jabref.model.groups.SearchGroup;
import net.sf.jabref.model.strings.StringUtil;

class GroupDialog
extends JDialog {
    private static final int INDEX_EXPLICIT_GROUP = 0;
    private static final int INDEX_KEYWORD_GROUP = 1;
    private static final int INDEX_SEARCH_GROUP = 2;
    private static final int TEXTFIELD_LENGTH = 30;
    private final JTextField nameField = new JTextField(30);
    private final JRadioButton explicitRadioButton = new JRadioButton(Localization.lang("Statically group entries by manual assignment", new String[0]));
    private final JRadioButton keywordsRadioButton = new JRadioButton(Localization.lang("Dynamically group entries by searching a field for a keyword", new String[0]));
    private final JRadioButton searchRadioButton = new JRadioButton(Localization.lang("Dynamically group entries by a free-form search expression", new String[0]));
    private final JRadioButton independentButton = new JRadioButton(Localization.lang("Independent group: When selected, view only this group's entries", new String[0]));
    private final JRadioButton intersectionButton = new JRadioButton(Localization.lang("Refine supergroup: When selected, view entries contained in both this group and its supergroup", new String[0]));
    private final JRadioButton unionButton = new JRadioButton(Localization.lang("Include subgroups: When selected, view entries contained in this group or its subgroups", new String[0]));
    private final JTextField keywordGroupSearchField = new JTextField(30);
    private final TextField keywordGroupSearchTerm = new TextField("keywords", "", false);
    private final JCheckBox keywordGroupCaseSensitive = new JCheckBox(Localization.lang("Case sensitive", new String[0]));
    private final JCheckBox keywordGroupRegExp = new JCheckBox(Localization.lang("regular expression", new String[0]));
    private final JTextField searchGroupSearchExpression = new JTextField(30);
    private final JCheckBox searchGroupCaseSensitive = new JCheckBox(Localization.lang("Case sensitive", new String[0]));
    private final JCheckBox searchGroupRegExp = new JCheckBox(Localization.lang("regular expression", new String[0]));
    private final JButton okButton = new JButton(Localization.lang("OK", new String[0]));
    private final JPanel optionsPanel = new JPanel();
    private final JLabel descriptionLabel = new JLabel(){

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = 1;
            return d;
        }
    };
    private boolean isOkPressed;
    private AbstractGroup resultingGroup;
    private final CardLayout optionsLayout = new CardLayout();

    public GroupDialog(JabRefFrame jabrefFrame, AbstractGroup editedGroup) {
        super(jabrefFrame, Localization.lang("Edit group", new String[0]), true);
        this.keywordGroupSearchField.setText(jabrefFrame.prefs().get("groupsDefaultField"));
        ButtonGroup groupType = new ButtonGroup();
        groupType.add(this.explicitRadioButton);
        groupType.add(this.keywordsRadioButton);
        groupType.add(this.searchRadioButton);
        ButtonGroup groupHierarchy = new ButtonGroup();
        groupHierarchy.add(this.independentButton);
        groupHierarchy.add(this.intersectionButton);
        groupHierarchy.add(this.unionButton);
        this.descriptionLabel.setVerticalAlignment(1);
        this.getRootPane().setDefaultButton(this.okButton);
        this.optionsPanel.setLayout(this.optionsLayout);
        this.optionsPanel.add((Component)new JPanel(), String.valueOf(0));
        FormLayout layoutKG = new FormLayout("right:pref, 4dlu, fill:1dlu:grow, 2dlu, left:pref");
        DefaultFormBuilder builderKG = new DefaultFormBuilder(layoutKG);
        builderKG.append(Localization.lang("Field", new String[0]));
        builderKG.append((Component)this.keywordGroupSearchField, 3);
        builderKG.nextLine();
        builderKG.append(Localization.lang("Keyword", new String[0]));
        builderKG.append(this.keywordGroupSearchTerm);
        builderKG.nextLine();
        builderKG.append((Component)this.keywordGroupCaseSensitive, 3);
        builderKG.nextLine();
        builderKG.append((Component)this.keywordGroupRegExp, 3);
        this.optionsPanel.add((Component)builderKG.getPanel(), String.valueOf(1));
        FormLayout layoutSG = new FormLayout("right:pref, 4dlu, fill:1dlu:grow");
        DefaultFormBuilder builderSG = new DefaultFormBuilder(layoutSG);
        builderSG.append(Localization.lang("Search expression", new String[0]));
        builderSG.append(this.searchGroupSearchExpression);
        builderSG.nextLine();
        builderSG.append((Component)this.searchGroupCaseSensitive, 3);
        builderSG.nextLine();
        builderSG.append((Component)this.searchGroupRegExp, 3);
        this.optionsPanel.add((Component)builderSG.getPanel(), String.valueOf(2));
        FormLayout layoutBP = new FormLayout("pref, 4dlu, pref", "p");
        layoutBP.setColumnGroups(new int[][]{{1, 3}});
        ButtonBarBuilder builderBP = new ButtonBarBuilder();
        builderBP.addGlue();
        builderBP.addButton((JComponent)this.okButton);
        JButton mCancel = new JButton(Localization.lang("Cancel", new String[0]));
        builderBP.addButton((JComponent)mCancel);
        builderBP.addGlue();
        builderBP.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        FormLayout layoutAll = new FormLayout("right:pref, 4dlu, fill:600px, 4dlu, fill:pref", "p, 3dlu, p, 3dlu, p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 0dlu, p, 0dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, top:80dlu, 9dlu, p, 9dlu, p");
        DefaultFormBuilder builderAll = new DefaultFormBuilder(layoutAll);
        builderAll.appendSeparator(Localization.lang("General", new String[0]));
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append(Localization.lang("Name", new String[0]));
        builderAll.append(this.nameField);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.explicitRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.keywordsRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.searchRadioButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator(Localization.lang("Hierarchical context", new String[0]));
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.independentButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.intersectionButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.unionButton, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator(Localization.lang("Options", new String[0]));
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.append((Component)this.optionsPanel, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator(Localization.lang("Description", new String[0]));
        builderAll.nextLine();
        builderAll.nextLine();
        JScrollPane sp = new JScrollPane(this.descriptionLabel, 20, 30){

            @Override
            public Dimension getPreferredSize() {
                return this.getMaximumSize();
            }
        };
        builderAll.append((Component)sp, 5);
        builderAll.nextLine();
        builderAll.nextLine();
        builderAll.appendSeparator();
        builderAll.nextLine();
        builderAll.nextLine();
        Container cp = this.getContentPane();
        cp.add((Component)builderAll.getPanel(), "Center");
        cp.add((Component)builderBP.getPanel(), "South");
        this.pack();
        this.setResizable(false);
        this.updateComponents();
        this.setLayoutForSelectedGroup();
        this.setLocationRelativeTo(jabrefFrame);
        ItemListener radioButtonItemListener = e -> {
            this.setLayoutForSelectedGroup();
            this.updateComponents();
        };
        this.explicitRadioButton.addItemListener(radioButtonItemListener);
        this.keywordsRadioButton.addItemListener(radioButtonItemListener);
        this.searchRadioButton.addItemListener(radioButtonItemListener);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupDialog.this.dispose();
            }
        };
        mCancel.addActionListener(cancelAction);
        builderAll.getPanel().getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        builderAll.getPanel().getActionMap().put("close", cancelAction);
        this.okButton.addActionListener(e -> {
            this.isOkPressed = true;
            try {
                if (this.explicitRadioButton.isSelected()) {
                    this.resultingGroup = new ExplicitGroup(this.nameField.getText().trim(), this.getContext(), Globals.prefs.getKeywordDelimiter());
                } else if (this.keywordsRadioButton.isSelected()) {
                    this.resultingGroup = new KeywordGroup(this.nameField.getText().trim(), this.keywordGroupSearchField.getText().trim(), this.keywordGroupSearchTerm.getText().trim(), this.keywordGroupCaseSensitive.isSelected(), this.keywordGroupRegExp.isSelected(), this.getContext(), Globals.prefs.getKeywordDelimiter());
                } else if (this.searchRadioButton.isSelected()) {
                    try {
                        this.resultingGroup = new SearchGroup(this.nameField.getText().trim(), this.searchGroupSearchExpression.getText().trim(), this.isCaseSensitive(), this.isRegex(), this.getContext());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.dispose();
            }
            catch (IllegalArgumentException exception) {
                jabrefFrame.showMessage(exception.getLocalizedMessage());
            }
        });
        CaretListener caretListener = e -> this.updateComponents();
        ItemListener itemListener = e -> this.updateComponents();
        this.nameField.addCaretListener(caretListener);
        this.keywordGroupSearchField.addCaretListener(caretListener);
        this.keywordGroupSearchTerm.addCaretListener(caretListener);
        this.keywordGroupCaseSensitive.addItemListener(itemListener);
        this.keywordGroupRegExp.addItemListener(itemListener);
        this.searchGroupSearchExpression.addCaretListener(caretListener);
        this.searchGroupRegExp.addItemListener(itemListener);
        this.searchGroupCaseSensitive.addItemListener(itemListener);
        if (editedGroup != null && editedGroup.getClass() == KeywordGroup.class) {
            KeywordGroup group = (KeywordGroup)editedGroup;
            this.nameField.setText(group.getName());
            this.keywordGroupSearchField.setText(group.getSearchField());
            this.keywordGroupSearchTerm.setText(group.getSearchExpression());
            this.keywordGroupCaseSensitive.setSelected(group.isCaseSensitive());
            this.keywordGroupRegExp.setSelected(group.isRegExp());
            this.keywordsRadioButton.setSelected(true);
            this.setContext(editedGroup.getHierarchicalContext());
        } else if (editedGroup != null && editedGroup.getClass() == SearchGroup.class) {
            SearchGroup group = (SearchGroup)editedGroup;
            this.nameField.setText(group.getName());
            this.searchGroupSearchExpression.setText(group.getSearchExpression());
            this.searchGroupCaseSensitive.setSelected(group.isCaseSensitive());
            this.searchGroupRegExp.setSelected(group.isRegExp());
            this.searchRadioButton.setSelected(true);
            this.setContext(editedGroup.getHierarchicalContext());
        } else if (editedGroup != null && editedGroup.getClass() == ExplicitGroup.class) {
            this.nameField.setText(editedGroup.getName());
            this.explicitRadioButton.setSelected(true);
            this.setContext(editedGroup.getHierarchicalContext());
        } else {
            this.explicitRadioButton.setSelected(true);
            this.setContext(GroupHierarchyType.INDEPENDENT);
        }
    }

    public boolean okPressed() {
        return this.isOkPressed;
    }

    public AbstractGroup getResultingGroup() {
        return this.resultingGroup;
    }

    private void setLayoutForSelectedGroup() {
        if (this.explicitRadioButton.isSelected()) {
            this.optionsLayout.show(this.optionsPanel, String.valueOf(0));
        } else if (this.keywordsRadioButton.isSelected()) {
            this.optionsLayout.show(this.optionsPanel, String.valueOf(1));
        } else if (this.searchRadioButton.isSelected()) {
            this.optionsLayout.show(this.optionsPanel, String.valueOf(2));
        }
    }

    private void updateComponents() {
        boolean okEnabled;
        boolean bl = okEnabled = !this.nameField.getText().trim().isEmpty();
        if (!okEnabled) {
            this.setDescription(Localization.lang("Please enter a name for the group.", new String[0]));
            this.okButton.setEnabled(false);
            return;
        }
        if (this.keywordsRadioButton.isSelected()) {
            String s1 = this.keywordGroupSearchField.getText().trim();
            okEnabled = okEnabled && s1.matches("\\w+");
            String s2 = this.keywordGroupSearchTerm.getText().trim();
            boolean bl2 = okEnabled = okEnabled && !s2.isEmpty();
            if (okEnabled) {
                if (this.keywordGroupRegExp.isSelected()) {
                    try {
                        Pattern.compile(s2);
                        this.setDescription(GroupDescriptions.getDescriptionForPreview(s1, s2, this.keywordGroupCaseSensitive.isSelected(), this.keywordGroupRegExp.isSelected()));
                    }
                    catch (PatternSyntaxException e) {
                        okEnabled = false;
                        this.setDescription(GroupDialog.formatRegExException(s2, e));
                    }
                } else {
                    this.setDescription(GroupDescriptions.getDescriptionForPreview(s1, s2, this.keywordGroupCaseSensitive.isSelected(), this.keywordGroupRegExp.isSelected()));
                }
            } else {
                this.setDescription(Localization.lang("Please enter the field to search (e.g. <b>keywords</b>) and the keyword to search it for (e.g. <b>electrical</b>).", new String[0]));
            }
            this.setNameFontItalic(true);
        } else if (this.searchRadioButton.isSelected()) {
            String s1 = this.searchGroupSearchExpression.getText().trim();
            if (okEnabled &= !s1.isEmpty()) {
                this.setDescription(new SearchQuery(s1, this.isCaseSensitive(), this.isRegex()).getDescription());
                if (this.isRegex()) {
                    try {
                        Pattern.compile(s1);
                    }
                    catch (PatternSyntaxException e) {
                        okEnabled = false;
                        this.setDescription(GroupDialog.formatRegExException(s1, e));
                    }
                }
            } else {
                this.setDescription(Localization.lang("Please enter a search term. For example, to search all fields for <b>Smith</b>, enter:<p><tt>smith</tt><p>To search the field <b>Author</b> for <b>Smith</b> and the field <b>Title</b> for <b>electrical</b>, enter:<p><tt>author=smith and title=electrical</tt>", new String[0]));
            }
            this.setNameFontItalic(true);
        } else if (this.explicitRadioButton.isSelected()) {
            this.setDescription(GroupDescriptions.getDescriptionForPreview());
            this.setNameFontItalic(false);
        }
        this.okButton.setEnabled(okEnabled);
    }

    private boolean isRegex() {
        return this.searchGroupRegExp.isSelected();
    }

    private boolean isCaseSensitive() {
        return this.searchGroupCaseSensitive.isSelected();
    }

    private void setDescription(String description) {
        this.descriptionLabel.setText("<html>" + description + "</html>");
    }

    private static String formatRegExException(String regExp, Exception e) {
        String[] sa = e.getMessage().split("\\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sa.length; ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append(StringUtil.quoteForHTML(sa[i]));
        }
        String s = Localization.lang("The regular expression <b>%0</b> is invalid:", StringUtil.quoteForHTML(regExp)) + "<p><tt>" + sb + "</tt>";
        if (!(e instanceof PatternSyntaxException)) {
            return s;
        }
        int lastNewline = s.lastIndexOf("<br>");
        int hat = s.lastIndexOf(94);
        if (lastNewline >= 0 && hat >= 0 && hat > lastNewline) {
            return s.substring(0, lastNewline + 4) + s.substring(lastNewline + 4).replace(" ", "&nbsp;");
        }
        return s;
    }

    private void setNameFontItalic(boolean italic) {
        Font f = this.nameField.getFont();
        if (f.isItalic() != italic) {
            f = f.deriveFont(italic ? 2 : 0);
            this.nameField.setFont(f);
        }
    }

    private GroupHierarchyType getContext() {
        if (this.independentButton.isSelected()) {
            return GroupHierarchyType.INDEPENDENT;
        }
        if (this.intersectionButton.isSelected()) {
            return GroupHierarchyType.REFINING;
        }
        if (this.unionButton.isSelected()) {
            return GroupHierarchyType.INCLUDING;
        }
        return GroupHierarchyType.INDEPENDENT;
    }

    private void setContext(GroupHierarchyType context) {
        if (context == GroupHierarchyType.REFINING) {
            this.intersectionButton.setSelected(true);
        } else if (context == GroupHierarchyType.INCLUDING) {
            this.unionButton.setSelected(true);
        } else {
            this.independentButton.setSelected(true);
        }
    }
}

