/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.actions.BaseAction;
import net.sf.jabref.gui.groups.AddToGroupAction;
import net.sf.jabref.gui.groups.GroupTreeCellRenderer;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.groups.RemoveFromGroupAction;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.GroupTreeNode;

public class GroupAddRemoveDialog
implements BaseAction {
    private final BasePanel panel;
    private final boolean add;
    private final boolean move;
    private List<BibEntry> selection;
    private JTree tree;

    public GroupAddRemoveDialog(BasePanel panel, boolean add, boolean move) {
        this.panel = panel;
        this.add = add;
        this.move = move;
    }

    @Override
    public void action() throws Throwable {
        Optional<GroupTreeNode> groups = this.panel.getBibDatabaseContext().getMetaData().getGroups();
        if (!groups.isPresent()) {
            return;
        }
        this.selection = this.panel.getSelectedEntries();
        final JDialog diag = new JDialog(this.panel.frame(), this.add ? (this.move ? Localization.lang("Move to group", new String[0]) : Localization.lang("Add to group", new String[0])) : Localization.lang("Remove from group", new String[0]), true);
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        this.tree = new JTree(new GroupTreeNodeViewModel(groups.get()));
        this.tree.setCellRenderer(new AddRemoveGroupTreeCellRenderer());
        this.tree.setVisibleRowCount(22);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(e -> {
            GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)e.getNewLeadSelectionPath().getLastPathComponent();
            ok.setEnabled(this.checkGroupEnable(node));
        });
        JButton jbExpandAll = new JButton("Expand All");
        jbExpandAll.addActionListener(e -> this.expandAll(this.tree, true));
        JButton jbCollapseAll = new JButton("Collapse All");
        jbCollapseAll.addActionListener(e -> this.expandAll(this.tree, false));
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addButton((JComponent)jbExpandAll);
        bb.addButton((JComponent)jbCollapseAll);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ok.addActionListener(actionEvent -> {
            if (this.doAddOrRemove()) {
                diag.dispose();
            }
        });
        cancel.addActionListener(actionEvent -> diag.dispose());
        ok.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.tree);
        ActionMap am = sp.getActionMap();
        InputMap im = sp.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                diag.dispose();
            }
        });
        diag.getContentPane().add((Component)sp, "Center");
        diag.getContentPane().add((Component)bb.getPanel(), "South");
        diag.pack();
        diag.setLocationRelativeTo(this.panel.frame());
        diag.setVisible(true);
    }

    private void expandAll(JTree tree, boolean expand) {
        SwingUtilities.invokeLater(() -> {
            TreeNode root = (TreeNode)tree.getModel().getRoot();
            this.expandAll(tree, new TreePath(((DefaultTreeModel)tree.getModel()).getPathToRoot(root)), expand);
            tree.requestFocusInWindow();
        });
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private boolean doAddOrRemove() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return false;
        }
        GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)path.getLastPathComponent();
        if (this.checkGroupEnable(node)) {
            if (this.add) {
                AddToGroupAction action = new AddToGroupAction(node, this.move, this.panel);
                action.actionPerformed(new ActionEvent(node, 0, "add"));
            } else {
                RemoveFromGroupAction action = new RemoveFromGroupAction(node, this.panel);
                action.actionPerformed(new ActionEvent(node, 0, "remove"));
            }
            return true;
        }
        return false;
    }

    private boolean checkGroupEnable(GroupTreeNodeViewModel node) {
        return this.add ? node.canAddEntries(this.selection) : node.canRemoveEntries(this.selection);
    }

    class AddRemoveGroupTreeCellRenderer
    extends GroupTreeCellRenderer {
        AddRemoveGroupTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            GroupTreeNodeViewModel node = (GroupTreeNodeViewModel)value;
            if (GroupAddRemoveDialog.this.checkGroupEnable(node)) {
                c.setForeground(Color.black);
            } else {
                c.setForeground(Color.gray);
            }
            return c;
        }
    }
}

