/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.externalfiles.DroppedFileHandler;
import net.sf.jabref.gui.externalfiles.TransferableFileLinkSelection;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.groups.TransferableEntrySelection;
import net.sf.jabref.gui.importer.ImportMenuItem;
import net.sf.jabref.gui.importer.actions.OpenDatabaseAction;
import net.sf.jabref.gui.maintable.MainTable;
import net.sf.jabref.gui.net.MonitoredURLDownload;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.pdfimport.PdfImporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntryTableTransferHandler
extends TransferHandler {
    private final MainTable entryTable;
    private final JabRefFrame frame;
    private final BasePanel panel;
    private DataFlavor urlFlavor;
    private final DataFlavor stringFlavor;
    private static final boolean DROP_ALLOWED = true;
    private static final Log LOGGER = LogFactory.getLog(EntryTableTransferHandler.class);
    private boolean draggingFile;

    public EntryTableTransferHandler(MainTable entryTable, JabRefFrame frame, BasePanel panel) {
        this.entryTable = entryTable;
        this.frame = frame;
        this.panel = panel;
        this.stringFlavor = DataFlavor.stringFlavor;
        try {
            this.urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Unable to configure drag and drop for main table", e);
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000000;
    }

    @Override
    public Transferable createTransferable(JComponent c) {
        if (this.draggingFile) {
            this.draggingFile = false;
            return new TransferableFileLinkSelection(this.panel, this.entryTable.getSelectedEntries());
        }
        return new TransferableEntrySelection(this.entryTable.getSelectedEntries());
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        DataFlavor[] inflavs;
        int dropRow = -1;
        if (comp instanceof JTable) {
            dropRow = ((JTable)comp).getSelectedRow();
        }
        try {
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List l = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                return this.handleDraggedFiles(l, dropRow);
            }
            if (t.isDataFlavorSupported(this.urlFlavor)) {
                URL dropLink = (URL)t.getTransferData(this.urlFlavor);
                return this.handleDropTransfer(dropLink);
            }
            if (t.isDataFlavorSupported(this.stringFlavor)) {
                String dropStr = (String)t.getTransferData(this.stringFlavor);
                LOGGER.debug("Received stringFlavor: " + dropStr);
                return this.handleDropTransfer(dropStr, dropRow);
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Failed to read dropped data", ioe);
        }
        catch (UnsupportedFlavorException | ClassCastException ufe) {
            LOGGER.error("Drop type error", ufe);
        }
        LOGGER.info("Can't transfer input: ");
        for (DataFlavor inflav : inflavs = t.getTransferDataFlavors()) {
            LOGGER.info("  " + inflav);
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        for (DataFlavor inflav : transferFlavors) {
            if (!inflav.match(this.urlFlavor) && !inflav.match(this.stringFlavor) && !inflav.match(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        if (e instanceof MouseEvent) {
            int columnIndex = this.entryTable.columnAtPoint(((MouseEvent)e).getPoint());
            int modelIndex = this.entryTable.getColumnModel().getColumn(columnIndex).getModelIndex();
            if (this.entryTable.isFileColumn(modelIndex)) {
                LOGGER.info("Dragging file");
                this.draggingFile = true;
            }
        }
        super.exportAsDrag(comp, e, 0x40000000);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        super.exportDone(source, data, action);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        super.exportToClipboard(comp, clip, action);
    }

    private boolean handleDropTransfer(String dropStr, int dropRow) throws IOException {
        if (dropStr.startsWith("file:")) {
            if (this.handleDraggedFilenames(dropStr, dropRow)) {
                return true;
            }
        } else if (dropStr.startsWith("http:")) {
            URL url = new URL(dropStr);
            return this.handleDropTransfer(url);
        }
        File tmpfile = File.createTempFile("jabrefimport", "");
        tmpfile.deleteOnExit();
        try (FileWriter fw = new FileWriter(tmpfile);){
            fw.write(dropStr);
        }
        ImportMenuItem importer = new ImportMenuItem(this.frame, false);
        importer.automatedImport(Collections.singletonList(tmpfile.getAbsolutePath()));
        return true;
    }

    public static List<File> getFilesFromDraggedFilesString(String s) {
        String[] lines = s.replace("\r", "").split("\n");
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = lines;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            File f;
            String line1;
            String line = line1 = stringArray[i];
            File fl = null;
            try {
                URL url = new URL(line);
                fl = new File(url.toURI());
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOGGER.warn("Could not get file", e);
            }
            if (fl != null) {
                line = fl.getPath();
            } else {
                if (!line.startsWith("file:")) continue;
                line = line.substring(5);
            }
            if (line.startsWith("//")) {
                line = line.substring(2);
            }
            if (!(f = new File(line)).exists()) continue;
            files.add(f);
        }
        return files;
    }

    private boolean handleDraggedFilenames(String s, int dropRow) {
        return this.handleDraggedFiles(EntryTableTransferHandler.getFilesFromDraggedFilesString(s), dropRow);
    }

    private boolean handleDraggedFiles(List<File> files, int dropRow) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : files) {
            fileNames.add(file.getAbsolutePath());
        }
        JabRefExecutorService.INSTANCE.execute(() -> {
            PdfImporter.ImportPdfFilesResult importRes = new PdfImporter(this.frame, this.panel, this.entryTable, dropRow).importPdfFiles(fileNames);
            if (!importRes.getNoPdfFiles().isEmpty()) {
                this.loadOrImportFiles(importRes.getNoPdfFiles(), dropRow);
            }
        });
        return true;
    }

    private void loadOrImportFiles(List<String> fileNames, int dropRow) {
        OpenDatabaseAction openAction = new OpenDatabaseAction(this.frame, false);
        ArrayList<String> notBibFiles = new ArrayList<String>();
        ArrayList<String> bibFiles = new ArrayList<String>();
        for (String fileName : fileNames) {
            Optional<String> extension = FileUtil.getFileExtension(fileName);
            if (extension.isPresent() && "bib".equals(extension.get())) {
                bibFiles.add(fileName);
                continue;
            }
            Optional<ExternalFileType> fileType = ExternalFileTypes.getInstance().getExternalFileTypeByExt(extension.orElse(""));
            if (fileType.isPresent() && dropRow >= 0) {
                DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
                dfh.handleDroppedfile(fileName, fileType.get(), this.entryTable, dropRow);
                continue;
            }
            notBibFiles.add(fileName);
        }
        openAction.openFilesAsStringList(bibFiles, true);
        if (!notBibFiles.isEmpty()) {
            ImportMenuItem importer = new ImportMenuItem(this.frame, this.entryTable == null);
            importer.automatedImport(notBibFiles);
        }
    }

    private boolean handleDropTransfer(URL dropLink) throws IOException {
        File tmpfile = File.createTempFile("jabrefimport", "");
        tmpfile.deleteOnExit();
        MonitoredURLDownload.buildMonitoredDownload(this.entryTable, dropLink).downloadToFile(tmpfile);
        ImportMenuItem importer = new ImportMenuItem(this.frame, this.entryTable == null);
        importer.automatedImport(Collections.singletonList(tmpfile.getAbsolutePath()));
        return true;
    }
}

