/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.groups.UndoableAddOrRemoveGroup;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.layout.format.LatexToUnicodeFormatter;
import net.sf.jabref.model.groups.ExplicitGroup;
import net.sf.jabref.model.groups.GroupHierarchyType;
import net.sf.jabref.model.groups.GroupTreeNode;
import net.sf.jabref.model.groups.GroupsUtil;
import net.sf.jabref.model.groups.KeywordGroup;

class AutoGroupDialog
extends JDialog
implements CaretListener {
    private final JTextField remove = new JTextField(60);
    private final JTextField field = new JTextField(60);
    private final JTextField deliminator = new JTextField(60);
    private final JRadioButton keywords = new JRadioButton(Localization.lang("Generate groups from keywords in a BibTeX field", new String[0]));
    private final JRadioButton authors = new JRadioButton(Localization.lang("Generate groups for author last names", new String[0]));
    private final JRadioButton editors = new JRadioButton(Localization.lang("Generate groups for editor last names", new String[0]));
    private final JCheckBox useCustomDelimiter = new JCheckBox(Localization.lang("Use the following delimiter character(s):", new String[0]));
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final GroupTreeNodeViewModel m_groupsRoot;
    private final JabRefFrame frame;
    private final BasePanel panel;

    public AutoGroupDialog(JabRefFrame jabrefFrame, BasePanel basePanel, GroupTreeNodeViewModel groupsRoot, String defaultField, String defaultRemove, String defaultDeliminator) {
        super(jabrefFrame, Localization.lang("Automatically create groups", new String[0]), true);
        this.frame = jabrefFrame;
        this.panel = basePanel;
        this.m_groupsRoot = groupsRoot;
        this.field.setText(defaultField);
        this.remove.setText(defaultRemove);
        this.deliminator.setText(defaultDeliminator);
        this.useCustomDelimiter.setSelected(true);
        ActionListener okListener = e -> {
            this.dispose();
            try {
                ArrayList<String> fields;
                Set<String> keywords;
                GroupTreeNode autoGroupsRoot = GroupTreeNode.fromGroup(new ExplicitGroup(Localization.lang("Automatically created groups", new String[0]), GroupHierarchyType.INCLUDING, Globals.prefs.getKeywordDelimiter()));
                String fieldText = this.field.getText().toLowerCase().trim();
                if (this.keywords.isSelected()) {
                    keywords = this.useCustomDelimiter.isSelected() ? GroupsUtil.findDeliminatedWordsInField(this.panel.getDatabase(), fieldText, this.deliminator.getText()) : GroupsUtil.findAllWordsInField(this.panel.getDatabase(), fieldText, this.remove.getText());
                } else if (this.authors.isSelected()) {
                    fields = new ArrayList<String>(2);
                    fields.add("author");
                    keywords = GroupsUtil.findAuthorLastNames(this.panel.getDatabase(), fields);
                    fieldText = "author";
                } else {
                    fields = new ArrayList(2);
                    fields.add("editor");
                    keywords = GroupsUtil.findAuthorLastNames(this.panel.getDatabase(), fields);
                    fieldText = "editor";
                }
                LatexToUnicodeFormatter formatter = new LatexToUnicodeFormatter();
                for (String keyword : keywords) {
                    KeywordGroup group = new KeywordGroup(formatter.format(keyword), fieldText, keyword, false, false, GroupHierarchyType.INDEPENDENT, Globals.prefs.getKeywordDelimiter());
                    autoGroupsRoot.addChild(GroupTreeNode.fromGroup(group));
                }
                autoGroupsRoot.moveTo(this.m_groupsRoot.getNode());
                NamedCompound ce = new NamedCompound(Localization.lang("Automatically create groups", new String[0]));
                UndoableAddOrRemoveGroup undo = new UndoableAddOrRemoveGroup(this.m_groupsRoot, new GroupTreeNodeViewModel(autoGroupsRoot), 0);
                ce.addEdit(undo);
                this.panel.markBaseChanged();
                this.frame.output(Localization.lang("Created groups.", new String[0]));
                ce.end();
                this.panel.getUndoManager().addEdit(ce);
            }
            catch (IllegalArgumentException exception) {
                this.frame.showMessage(exception.getLocalizedMessage());
            }
        };
        this.remove.addActionListener(okListener);
        this.field.addActionListener(okListener);
        this.field.addCaretListener(this);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoGroupDialog.this.dispose();
            }
        };
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        cancel.addActionListener(cancelAction);
        this.ok.addActionListener(okListener);
        JPanel main = new JPanel();
        ActionMap am = main.getActionMap();
        InputMap im = main.getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.keywords);
        bg.add(this.authors);
        bg.add(this.editors);
        this.keywords.setSelected(true);
        FormBuilder b = FormBuilder.create();
        b.layout(new FormLayout("left:20dlu, 4dlu, left:pref, 4dlu, fill:60dlu", "p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p, 2dlu, p"));
        b.add(this.keywords).xyw(1, 1, 5);
        b.add(Localization.lang("Field to group by", new String[0]) + ":", new Object[0]).xy(3, 3);
        b.add(this.field).xy(5, 3);
        b.add(Localization.lang("Characters to ignore", new String[0]) + ":", new Object[0]).xy(3, 5);
        b.add(this.remove).xy(5, 5);
        b.add(this.useCustomDelimiter).xy(3, 7);
        b.add(this.deliminator).xy(5, 7);
        b.add(this.authors).xyw(1, 9, 5);
        b.add(this.editors).xyw(1, 11, 5);
        b.build();
        b.border(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel opt = new JPanel();
        ButtonBarBuilder bb = new ButtonBarBuilder(opt);
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        opt.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)main, "Center");
        this.getContentPane().add((Component)b.getPanel(), "Center");
        this.getContentPane().add((Component)opt, "South");
        this.updateComponents();
        this.pack();
        this.setLocationRelativeTo(this.frame);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.updateComponents();
    }

    private void updateComponents() {
        String groupField = this.field.getText().trim();
        this.ok.setEnabled(groupField.matches("\\w+"));
    }
}

