/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.groups;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.groups.GroupTreeNodeViewModel;
import net.sf.jabref.gui.groups.UndoableChangeEntriesOfGroup;
import net.sf.jabref.gui.groups.WarnAssignmentSideEffects;
import net.sf.jabref.gui.undo.NamedCompound;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;
import net.sf.jabref.model.groups.AbstractGroup;
import net.sf.jabref.model.groups.EntriesGroupChange;
import net.sf.jabref.model.groups.GroupTreeNode;

public class AddToGroupAction
extends AbstractAction {
    private final boolean move;
    private GroupTreeNodeViewModel node;
    private BasePanel panel;

    public AddToGroupAction(GroupTreeNodeViewModel node, boolean move, BasePanel panel) {
        super(node.getNode().getGroup().getName());
        this.node = node;
        this.move = move;
        this.panel = panel;
    }

    public AddToGroupAction(boolean move) {
        super(move ? Localization.lang("Assign entry selection exclusively to this group", new String[0]) : Localization.lang("Add entry selection to this group", new String[0]));
        this.move = move;
    }

    public void setBasePanel(BasePanel panel) {
        this.panel = panel;
    }

    public void setNode(GroupTreeNodeViewModel node) {
        this.node = node;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        List<BibEntry> entries = this.panel.getSelectedEntries();
        this.panel.storeCurrentEdit();
        NamedCompound undoAll = new NamedCompound(Localization.lang("change assignment of entries", new String[0]));
        if (this.move) {
            this.moveToGroup(entries, undoAll);
        } else {
            this.addToGroup(entries, undoAll);
        }
        undoAll.end();
        this.panel.getUndoManager().addEdit(undoAll);
        this.panel.markBaseChanged();
        this.panel.updateEntryEditorIfShowing();
        this.panel.getGroupSelector().valueChanged(null);
    }

    public void moveToGroup(List<BibEntry> entries, NamedCompound undoAll) {
        List groupsContainingEntries = ((GroupTreeNode)this.node.getNode().getRoot()).getContainingGroups(entries, false).stream().filter(node -> node.getGroup().supportsRemove()).collect(Collectors.toList());
        List<AbstractGroup> affectedGroups = groupsContainingEntries.stream().map(GroupTreeNode::getGroup).collect(Collectors.toList());
        affectedGroups.add(this.node.getNode().getGroup());
        if (!WarnAssignmentSideEffects.warnAssignmentSideEffects(affectedGroups, (Component)this.panel.frame())) {
            return;
        }
        for (GroupTreeNode group : groupsContainingEntries) {
            Optional<EntriesGroupChange> undoRemove = group.getGroup().remove(entries);
            if (!undoRemove.isPresent()) continue;
            undoAll.addEdit(UndoableChangeEntriesOfGroup.getUndoableEdit(this.node, undoRemove.get()));
        }
        Optional<EntriesGroupChange> undoAdd = this.node.addEntriesToGroup(entries);
        if (undoAdd.isPresent()) {
            undoAll.addEdit(UndoableChangeEntriesOfGroup.getUndoableEdit(this.node, undoAdd.get()));
        }
    }

    public void addToGroup(List<BibEntry> entries, NamedCompound undo) {
        if (!WarnAssignmentSideEffects.warnAssignmentSideEffects(this.node.getNode().getGroup(), (Component)this.panel.frame())) {
            return;
        }
        Optional<EntriesGroupChange> undoAdd = this.node.addEntriesToGroup(entries);
        if (undoAdd.isPresent()) {
            undo.addEdit(UndoableChangeEntriesOfGroup.getUndoableEdit(this.node, undoAdd.get()));
        }
    }
}

