/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.filelist;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.externalfiletype.UnknownExternalFileType;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.entry.FileField;
import net.sf.jabref.model.entry.ParsedFileField;

public class FileListTableModel
extends AbstractTableModel {
    private final List<FileListEntry> list = new ArrayList<FileListEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        List<FileListEntry> list = this.list;
        synchronized (list) {
            return this.list.size();
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    public Class<String> getColumnClass(int columnIndex) {
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List<FileListEntry> list = this.list;
        synchronized (list) {
            FileListEntry entry = this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return entry.description;
                }
                case 1: {
                    return entry.link;
                }
            }
            return entry.type.isPresent() ? entry.type.get().getName() : "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileListEntry getEntry(int index) {
        List<FileListEntry> list = this.list;
        synchronized (list) {
            return this.list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(int index, FileListEntry entry) {
        List<FileListEntry> list = this.list;
        synchronized (list) {
            this.list.set(index, entry);
            this.fireTableRowsUpdated(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(int index) {
        List<FileListEntry> list = this.list;
        synchronized (list) {
            this.list.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(int index, FileListEntry entry) {
        List<FileListEntry> list = this.list;
        synchronized (list) {
            this.list.add(index, entry);
            if (SwingUtilities.isEventDispatchThread()) {
                this.fireTableRowsInserted(index, index);
            } else {
                SwingUtilities.invokeLater(() -> this.fireTableRowsInserted(index, index));
            }
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public void setContent(String value) {
        this.setContent(value, false, true);
    }

    public void setContentDontGuessTypes(String value) {
        this.setContent(value, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileListEntry setContent(String val, boolean firstOnly, boolean deduceUnknownTypes) {
        String value = val;
        if (value == null) {
            value = "";
        }
        List<ParsedFileField> fields = FileField.parse(value);
        ArrayList<FileListEntry> files = new ArrayList<FileListEntry>();
        for (ParsedFileField entry : fields) {
            if (entry.isEmpty()) continue;
            if (firstOnly) {
                return this.decodeEntry(entry, deduceUnknownTypes);
            }
            files.add(this.decodeEntry(entry, deduceUnknownTypes));
        }
        List<FileListEntry> list = this.list;
        synchronized (list) {
            this.list.clear();
            this.list.addAll(files);
        }
        this.fireTableChanged(new TableModelEvent(this));
        return null;
    }

    public static JLabel getFirstLabel(String content) {
        FileListTableModel tm = new FileListTableModel();
        FileListEntry entry = tm.setContent(content, true, true);
        if (entry == null || !entry.type.isPresent()) {
            return null;
        }
        return entry.type.get().getIconLabel();
    }

    private FileListEntry decodeEntry(ParsedFileField entry, boolean deduceUnknownType) {
        Optional<ExternalFileType> typeGuess;
        Optional<String> extension;
        Optional<ExternalFileType> type = ExternalFileTypes.getInstance().getExternalFileTypeByName(entry.getFileType());
        if (deduceUnknownType && type.get() instanceof UnknownExternalFileType && !(type = ExternalFileTypes.getInstance().getExternalFileTypeByMimeType(entry.getFileType())).isPresent() && (extension = FileUtil.getFileExtension(entry.getLink())).isPresent() && (typeGuess = ExternalFileTypes.getInstance().getExternalFileTypeByExt(extension.get())).isPresent()) {
            type = typeGuess;
        }
        return new FileListEntry(entry.getDescription(), entry.getLink(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringRepresentation() {
        List<FileListEntry> list = this.list;
        synchronized (list) {
            String[][] array = new String[this.list.size()][];
            int i = 0;
            for (FileListEntry entry : this.list) {
                array[i] = entry.getStringArrayRepresentation();
                ++i;
            }
            return FileField.encodeStringArray(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipHTMLRepresentation() {
        StringJoiner sb = new StringJoiner("<br>", "<html>", "</html>");
        List<FileListEntry> list = this.list;
        synchronized (list) {
            for (FileListEntry entry : this.list) {
                sb.add(String.format("%s (%s)", entry.description, entry.link));
            }
        }
        return sb.toString();
    }
}

