/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.filelist;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileDialog;
import net.sf.jabref.gui.JabRefFrame;
import net.sf.jabref.gui.desktop.JabRefDesktop;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;
import net.sf.jabref.gui.externalfiletype.ExternalFileTypes;
import net.sf.jabref.gui.externalfiletype.UnknownExternalFileType;
import net.sf.jabref.gui.filelist.ConfirmCloseFileListEntryEditor;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.keyboard.KeyBinding;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.logic.util.io.FileUtil;
import net.sf.jabref.model.database.BibDatabaseContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileListEntryEditor {
    private static final Log LOGGER = LogFactory.getLog(FileListEntryEditor.class);
    private JDialog diag;
    private final JTextField link = new JTextField();
    private final JTextField description = new JTextField();
    private final JButton ok = new JButton(Localization.lang("OK", new String[0]));
    private final JComboBox<ExternalFileType> types;
    private final JProgressBar prog = new JProgressBar(0);
    private final JLabel downloadLabel = new JLabel(Localization.lang("Downloading...", new String[0]));
    private ConfirmCloseFileListEntryEditor externalConfirm;
    private FileListEntry entry;
    private BibDatabaseContext databaseContext;
    private boolean okPressed;
    private boolean okDisabledExternally;
    private boolean openBrowseWhenShown;
    private boolean dontOpenBrowseUntilDisposed;
    private JabRefFrame frame;
    private static final Pattern REMOTE_LINK_PATTERN = Pattern.compile("[a-z]+://.*");
    private final ActionListener browsePressed = e -> {
        String filePath = this.link.getText().trim();
        Optional<File> file = FileUtil.expandFilename(this.databaseContext, filePath, Globals.prefs.getFileDirectoryPreferences());
        String workingDir = file.isPresent() ? file.get().getPath() : Globals.prefs.get("workingDirectory");
        Optional<Path> path = new FileDialog(this.frame, workingDir).showDialogAndGetSelectedFile();
        path.ifPresent(selection -> {
            File newFile = selection.toFile();
            Globals.prefs.put("workingDirectory", newFile.getPath());
            List<String> fileDirs = this.databaseContext.getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
            newFile = FileUtil.shortenFileName(newFile, fileDirs);
            this.link.setText(newFile.getPath());
            this.link.requestFocus();
        });
    };

    public FileListEntryEditor(JabRefFrame frame, FileListEntry entry, boolean showProgressBar, boolean showOpenButton, BibDatabaseContext databaseContext) {
        this.entry = entry;
        this.databaseContext = databaseContext;
        this.frame = frame;
        ActionListener okAction = e -> {
            if (!this.ok.isEnabled()) {
                return;
            }
            if (this.externalConfirm != null) {
                this.storeSettings(entry);
                if (!this.externalConfirm.confirmClose(entry)) {
                    return;
                }
            }
            this.diag.dispose();
            this.storeSettings(this.entry);
            this.okPressed = true;
        };
        this.types = new JComboBox();
        this.types.addItemListener(itemEvent -> {
            if (!this.okDisabledExternally) {
                this.ok.setEnabled(this.types.getSelectedItem() != null);
            }
        });
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref, 4dlu, fill:pref", "p, 2dlu, p, 2dlu, p"));
        builder.add(Localization.lang("Link", new String[0]), new Object[0]).xy(1, 1);
        builder.add(this.link).xy(3, 1);
        final JButton browseBut = new JButton(Localization.lang("Browse", new String[0]));
        browseBut.addActionListener(this.browsePressed);
        builder.add(browseBut).xy(5, 1);
        JButton open = new JButton(Localization.lang("Open", new String[0]));
        if (showOpenButton) {
            builder.add(open).xy(7, 1);
        }
        builder.add(Localization.lang("Description", new String[0]), new Object[0]).xy(1, 3);
        builder.add(this.description).xyw(3, 3, 3);
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        builder.add(Localization.lang("File type", new String[0]), new Object[0]).xy(1, 5);
        builder.add(this.types).xyw(3, 5, 3);
        if (showProgressBar) {
            builder.appendRows("2dlu, p", new Object[0]);
            builder.add(this.downloadLabel).xy(1, 7);
            builder.add(this.prog).xyw(3, 7, 3);
        }
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addRelatedGap();
        bb.addButton((JComponent)this.ok);
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ok.addActionListener(okAction);
        this.link.addActionListener(okAction);
        this.description.addActionListener(okAction);
        open.addActionListener(e -> this.openFile());
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileListEntryEditor.this.diag.dispose();
            }
        };
        cancel.addActionListener(cancelAction);
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
        this.link.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FileListEntryEditor.this.checkExtension();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FileListEntryEditor.this.checkExtension();
            }
        });
        this.diag = new JDialog(frame, Localization.lang("Save file", new String[0]), true);
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        this.diag.setLocationRelativeTo(frame);
        this.diag.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent event) {
                if (FileListEntryEditor.this.openBrowseWhenShown && !FileListEntryEditor.this.dontOpenBrowseUntilDisposed) {
                    FileListEntryEditor.this.dontOpenBrowseUntilDisposed = true;
                    SwingUtilities.invokeLater(() -> FileListEntryEditor.this.browsePressed.actionPerformed(new ActionEvent(browseBut, 0, "")));
                }
            }

            @Override
            public void windowClosed(WindowEvent event) {
                FileListEntryEditor.this.dontOpenBrowseUntilDisposed = false;
            }
        });
        this.setValues(entry);
    }

    private void checkExtension() {
        if (this.types.getSelectedIndex() == -1 && !this.link.getText().trim().isEmpty()) {
            Optional<ExternalFileType> type;
            if (REMOTE_LINK_PATTERN.matcher(this.link.getText()).matches() && (type = ExternalFileTypes.getInstance().getExternalFileTypeByExt("html")).isPresent()) {
                this.types.setSelectedItem(type.get());
                return;
            }
            String theLink = this.link.getText().trim();
            ExternalFileTypes.getInstance().getExternalFileTypeForName(theLink).ifPresent(this.types::setSelectedItem);
        }
    }

    private void openFile() {
        ExternalFileType type = (ExternalFileType)this.types.getSelectedItem();
        if (type != null) {
            try {
                JabRefDesktop.openExternalFileAnyFormat(this.databaseContext, this.link.getText(), Optional.of(type));
            }
            catch (IOException e) {
                LOGGER.error("File could not be opened", e);
            }
        }
    }

    public void setExternalConfirm(ConfirmCloseFileListEntryEditor eC) {
        this.externalConfirm = eC;
    }

    public void setOkEnabled(boolean enabled) {
        this.okDisabledExternally = !enabled;
        this.ok.setEnabled(enabled);
    }

    public JProgressBar getProgressBar() {
        return this.prog;
    }

    public JLabel getProgressBarLabel() {
        return this.downloadLabel;
    }

    public void setEntry(FileListEntry entry) {
        this.entry = entry;
        this.setValues(entry);
    }

    public void setVisible(boolean visible, boolean openBrowse) {
        boolean bl = this.openBrowseWhenShown = openBrowse && Globals.prefs.getBoolean("allowFileAutoOpenBrowse");
        if (visible) {
            this.okPressed = false;
        }
        this.diag.setVisible(visible);
    }

    public boolean isVisible() {
        return this.diag != null && this.diag.isVisible();
    }

    private void setValues(FileListEntry entry) {
        this.description.setText(entry.description);
        this.link.setText(entry.link);
        Set<ExternalFileType> list = ExternalFileTypes.getInstance().getExternalFileTypeSelection();
        this.types.setModel(new DefaultComboBoxModel<ExternalFileType>(list.toArray(new ExternalFileType[list.size()])));
        this.types.setSelectedIndex(-1);
        if (entry.type.isPresent() && !(entry.type.get() instanceof UnknownExternalFileType)) {
            this.types.setSelectedItem(entry.type.get());
        } else if (entry.link != null && !entry.link.isEmpty()) {
            this.checkExtension();
        }
    }

    private void storeSettings(FileListEntry listEntry) {
        String descriptionText = this.description.getText().trim();
        String fileLink = "";
        try {
            List<String> dirs = this.databaseContext.getFileDirectory(Globals.prefs.getFileDirectoryPreferences());
            if (dirs.isEmpty()) {
                fileLink = this.link.getText().trim();
            } else {
                boolean found = false;
                for (String dir : dirs) {
                    String flPath;
                    String canPath = new File(dir).getCanonicalPath();
                    File fl = new File(this.link.getText().trim());
                    if (!fl.isAbsolute() || (flPath = fl.getCanonicalPath()).length() <= canPath.length() || !flPath.startsWith(canPath)) continue;
                    fileLink = fl.getCanonicalPath().substring(canPath.length() + 1);
                    found = true;
                    break;
                }
                if (!found) {
                    fileLink = this.link.getText().trim();
                }
            }
        }
        catch (IOException ex) {
            fileLink = this.link.getText().trim();
        }
        ExternalFileType type = (ExternalFileType)this.types.getSelectedItem();
        listEntry.description = descriptionText;
        listEntry.type = Optional.ofNullable(type);
        listEntry.link = fileLink;
    }

    public boolean okPressed() {
        return this.okPressed;
    }
}

