/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.filelist;

import java.util.Objects;
import java.util.Optional;
import net.sf.jabref.gui.externalfiletype.ExternalFileType;

public class FileListEntry {
    public String description;
    public String link;
    public Optional<ExternalFileType> type;

    public FileListEntry(String description, String link) {
        this(description, link, Optional.empty());
    }

    public FileListEntry(String description, String link, ExternalFileType type) {
        this.description = Objects.requireNonNull(description);
        this.link = Objects.requireNonNull(link);
        this.type = Optional.of(Objects.requireNonNull(type));
    }

    public FileListEntry(String description, String link, Optional<ExternalFileType> type) {
        this.description = Objects.requireNonNull(description);
        this.link = Objects.requireNonNull(link);
        this.type = Objects.requireNonNull(type);
    }

    public String[] getStringArrayRepresentation() {
        return new String[]{this.description, this.link, this.getTypeName()};
    }

    private String getTypeName() {
        return this.type.isPresent() ? this.type.get().getName() : "";
    }

    public String toString() {
        return this.description + " : " + this.link + " : " + this.type.orElse(null);
    }
}

