/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.filelist;

import net.sf.jabref.gui.BasePanel;
import net.sf.jabref.gui.actions.BaseAction;
import net.sf.jabref.gui.filelist.FileListEntry;
import net.sf.jabref.gui.filelist.FileListEntryEditor;
import net.sf.jabref.gui.filelist.FileListTableModel;
import net.sf.jabref.gui.undo.UndoableFieldChange;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.entry.BibEntry;

public class AttachFileAction
implements BaseAction {
    private final BasePanel panel;

    public AttachFileAction(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void action() {
        if (this.panel.getSelectedEntries().size() != 1) {
            this.panel.output(Localization.lang("This operation requires exactly one item to be selected.", new String[0]));
            return;
        }
        BibEntry entry = this.panel.getSelectedEntries().get(0);
        FileListEntry flEntry = new FileListEntry("", "");
        FileListEntryEditor editor = new FileListEntryEditor(this.panel.frame(), flEntry, false, true, this.panel.getBibDatabaseContext());
        editor.setVisible(true, true);
        if (editor.okPressed()) {
            FileListTableModel model = new FileListTableModel();
            entry.getField("file").ifPresent(model::setContent);
            model.addEntry(model.getRowCount(), flEntry);
            String newVal = model.getStringRepresentation();
            UndoableFieldChange ce = new UndoableFieldChange(entry, "file", entry.getField("file").orElse(null), newVal);
            entry.setField("file", newVal);
            this.panel.getUndoManager().addEdit(ce);
            this.panel.markBaseChanged();
        }
    }
}

