/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui.fieldeditors.contextmenu;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import net.sf.jabref.gui.ClipBoardManager;
import net.sf.jabref.gui.actions.CopyAction;
import net.sf.jabref.gui.actions.CopyDoiUrlAction;
import net.sf.jabref.gui.actions.PasteAction;
import net.sf.jabref.gui.fieldeditors.FieldEditor;
import net.sf.jabref.gui.fieldeditors.contextmenu.CaseChangeMenu;
import net.sf.jabref.gui.fieldeditors.contextmenu.ConversionMenu;
import net.sf.jabref.gui.fieldeditors.contextmenu.ProtectedTermsMenu;
import net.sf.jabref.logic.formatter.bibtexfields.NormalizeNamesFormatter;
import net.sf.jabref.logic.l10n.Localization;
import net.sf.jabref.model.strings.StringUtil;

public class FieldTextMenu
implements MouseListener {
    private final FieldEditor field;
    private final JPopupMenu inputMenu = new JPopupMenu();
    private final CopyAction copyAction;
    private final PasteAction pasteAction;
    private final JMenuItem doiMenuItem;
    private ProtectedTermsMenu protectedTermsMenu;
    private static final int MAX_PASTE_PREVIEW_LENGTH = 20;

    public FieldTextMenu(FieldEditor fieldComponent) {
        this.field = fieldComponent;
        this.copyAction = new CopyAction((JTextComponent)((Object)this.field));
        this.pasteAction = new PasteAction((JTextComponent)((Object)this.field));
        CopyDoiUrlAction copyDoiAction = new CopyDoiUrlAction((JTextComponent)((Object)this.field));
        this.doiMenuItem = new JMenuItem(copyDoiAction);
        this.initMenu();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger() && this.field != null) {
            this.field.requestFocus();
            String txt = this.field.getSelectedText();
            String allTxt = this.field.getText();
            boolean copyStatus = false;
            if (txt != null && !txt.isEmpty() || allTxt != null && !allTxt.isEmpty()) {
                copyStatus = true;
            }
            this.copyAction.setEnabled(copyStatus);
            String data = new ClipBoardManager().getClipboardContents();
            boolean pasteStatus = false;
            if (!data.isEmpty()) {
                pasteStatus = true;
                this.pasteAction.putValue("ShortDescription", Localization.lang("Paste from clipboard", new String[0]) + ": " + StringUtil.limitStringLength(data, 20));
            } else {
                this.pasteAction.putValue("ShortDescription", Localization.lang("Paste from clipboard", new String[0]));
            }
            this.pasteAction.setEnabled(pasteStatus);
            if (this.protectedTermsMenu != null) {
                this.protectedTermsMenu.updateFiles();
            }
            boolean isDOIField = this.field.getFieldName().equals("doi");
            this.doiMenuItem.setVisible(isDOIField);
            boolean isDoiFieldEmpty = this.field.getText().isEmpty();
            this.doiMenuItem.setEnabled(!isDoiFieldEmpty);
            this.inputMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void initMenu() {
        this.inputMenu.add(this.pasteAction);
        this.inputMenu.add(this.copyAction);
        if (this.field.getTextComponent() instanceof JTextComponent) {
            this.inputMenu.add(this.doiMenuItem);
        }
        this.inputMenu.addSeparator();
        this.inputMenu.add(new ReplaceAction());
        if (this.field.getTextComponent() instanceof JTextComponent) {
            this.inputMenu.add(new CaseChangeMenu((JTextComponent)this.field.getTextComponent()));
            this.inputMenu.add(new ConversionMenu((JTextComponent)this.field.getTextComponent()));
            this.inputMenu.addSeparator();
            this.protectedTermsMenu = new ProtectedTermsMenu((JTextComponent)this.field.getTextComponent());
            this.inputMenu.add(this.protectedTermsMenu);
        }
    }

    class ReplaceAction
    extends AbstractAction {
        public ReplaceAction() {
            this.putValue("Name", Localization.lang("Normalize to BibTeX name format", new String[0]));
            this.putValue("ShortDescription", Localization.lang("If possible, normalize this list of names to conform to standard BibTeX name formatting", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (FieldTextMenu.this.field.getText().isEmpty()) {
                return;
            }
            String input = FieldTextMenu.this.field.getText();
            FieldTextMenu.this.field.setText(new NormalizeNamesFormatter().format(input));
        }
    }
}

